/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.audit.sql.ForbidExpressPropertyFilter;
import kd.bos.audit.sql.ForbidPKRangeFilter;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.privacy.IPrivacyProperty;
import kd.bos.db.DB;
import kd.bos.db.DBExt;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.DataSetDataType;
import kd.bos.db.PeekingDataSet;
import kd.bos.db.QueryMeta;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.pktemptable.utils.TableVariableUtil;
import kd.bos.db.temptable.pk.PKTempTableUtil;
import kd.bos.db.tx.TX;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.EntityItemJoinProperty;
import kd.bos.orm.query.MergeDBBeacon;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.NoSuchPropertyException;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.SqlRequest;
import kd.bos.orm.query.cache.CacheableLazyQueryHashJoinDataSet;
import kd.bos.orm.query.cache.QueryHashJoinDataSetContext;
import kd.bos.orm.query.crossdb.TenantAccountCrossDBRuntime;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.orm.query.hugein.AutoRelease;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.query.hugein.HugeInUtil;
import kd.bos.orm.query.multi.EmptyDataSet;
import kd.bos.orm.query.multi.FieldDecrypt;
import kd.bos.orm.query.multi.GroupByInfo;
import kd.bos.orm.query.multi.JoinTableInfo;
import kd.bos.orm.query.multi.JoinTableTypeEnum;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.multi.QueryConfig;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.ReuseDBRoute;
import kd.bos.orm.query.multi.SingleQueryTableInfo;
import kd.bos.orm.query.optimize.JoinDBTodo;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.oql.g.expr.SelectFields;
import kd.bos.orm.query.privacy.PrivacyDataQuery;
import kd.bos.orm.query.privacy.PrivacyDataSet;
import kd.bos.orm.query.privacy.PrivacyFieldInfo;
import kd.bos.orm.query.privacy.PrivacyPeekingDataSet;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.temptable.facade.TemptableFacade;
import kd.bos.xdb.temptable.facade.TemptableFacadeContext;
import kd.bos.xdb.temptable.facade.TemptableFacadeContexts;
import kd.bos.xdb.util.Pair;

public class SingleQuery {
    public static final String SQL_KEY_SELECT = "SELECT ";
    private static final String SQL_KEY_DISTINCT = "DISTINCT ";
    private static final String SQL_KEY_SELECT_DISTINCT = "SELECT DISTINCT ";
    private static boolean SORT_JOINTABLE_BYWORDS = false;
    private static final boolean ENABLE_OPTIMIZE_LANG_MAINTABLE;
    private static final Log log;
    private static final LangReplaceMain empty_LangReplaceMain;
    private IDataEntityType entityType;
    private String fullObjName;
    private PropertyField[] selectFields;
    private Map<String, QFilter> allJoinFilterMap;
    private Map<String, QFilter> allFilterMap;
    private Set<String> curFilterObjSet = new HashSet<String>();
    private List<PropertyField> performJoinFieldList;
    private List<OrderByInfo> allOrderByList;
    private List<GroupByInfo> allGroupByList;
    private Map<String, QFilter> allHavingFilterMap;
    private int top;
    private int start;
    private int limit;
    private DBRoute dbRoute;
    private String parentFK;
    private QContext allCtx;
    private QContext ctx;
    private Set<String> myFullObjNameSet = new HashSet<String>();
    private QueryParameter queryParameter = null;
    private boolean withUserOriginFilter = false;
    private boolean isForceInnerJoin = false;
    private Set<QFilter> usedFilterAndHavingSet = new HashSet<QFilter>();
    private boolean emptyQuery = false;
    private boolean orderByOnSQL = true;
    private Set<DBConfig> dbConfigSet;
    private boolean shouldRebuildSQL = false;
    private boolean isWithCrossDBObjectOrFilter = false;
    private boolean shouldSelectPk;
    private QFilter multiTypeQFilter;
    private boolean hasDistinct;
    private boolean existsSubquery = false;
    private SingleQuery subQuey;
    private Map<String, String> tableToEntity = new HashMap<String, String>();
    private List<QueryTreeNode> subQueryNodes = new ArrayList<QueryTreeNode>();
    private QFilter existsQFilter;
    private static final ExtendReplaceMain empty_ExtendReplaceMain;

    private SingleQuery(DBRoute dbRoute, String parentFK, IDataEntityType entityType, String fullObjName, PropertyField[] selectFields, List<PropertyField> performJoinFieldList, Map<String, QFilter> allJoinFilterMap, Map<String, QFilter> allFilterMap, List<OrderByInfo> allOrderByList, List<GroupByInfo> allGroupByList, Map<String, QFilter> allHavingFilterMap, int top, int start, int limit, QContext allCtx, boolean withUserOriginFilter, boolean orderByOnSQL) {
        this(dbRoute, parentFK, entityType, fullObjName, selectFields, performJoinFieldList, allJoinFilterMap, allFilterMap, allOrderByList, allGroupByList, allHavingFilterMap, top, start, limit, allCtx, withUserOriginFilter, true, orderByOnSQL);
    }

    SingleQuery(DBRoute dbRoute, String parentFK, IDataEntityType entityType, String fullObjName, PropertyField[] selectFields, List<PropertyField> performJoinFieldList, Map<String, QFilter> allJoinFilterMap, Map<String, QFilter> allFilterMap, List<OrderByInfo> allOrderByList, List<GroupByInfo> allGroupByList, Map<String, QFilter> allHavingFilterMap, int top, int start, int limit, QContext allCtx, boolean withUserOriginFilter, boolean initQueryParameter, boolean orderByOnSQL, boolean shouldSelectPk) {
        this(dbRoute, parentFK, entityType, fullObjName, selectFields, performJoinFieldList, allJoinFilterMap, allFilterMap, allOrderByList, allGroupByList, allHavingFilterMap, top, start, limit, allCtx, withUserOriginFilter, initQueryParameter, orderByOnSQL);
        this.shouldSelectPk = shouldSelectPk;
    }

    SingleQuery(DBRoute dbRoute, String parentFK, IDataEntityType entityType, String fullObjName, PropertyField[] selectFields, List<PropertyField> performJoinFieldList, Map<String, QFilter> allJoinFilterMap, Map<String, QFilter> allFilterMap, List<OrderByInfo> allOrderByList, List<GroupByInfo> allGroupByList, Map<String, QFilter> allHavingFilterMap, int top, int start, int limit, QContext allCtx, boolean withUserOriginFilter, boolean initQueryParameter, boolean orderByOnSQL) {
        this.parentFK = parentFK;
        this.entityType = entityType;
        this.fullObjName = fullObjName;
        this.selectFields = selectFields;
        this.performJoinFieldList = performJoinFieldList;
        this.allJoinFilterMap = allJoinFilterMap;
        this.allFilterMap = allFilterMap;
        this.allOrderByList = allOrderByList;
        this.allGroupByList = allGroupByList;
        this.allHavingFilterMap = allHavingFilterMap;
        this.withUserOriginFilter = withUserOriginFilter;
        this.orderByOnSQL = orderByOnSQL;
        this.top = top;
        this.start = start;
        this.limit = limit;
        this.curFilterObjSet.add(fullObjName);
        this.dbRoute = ReuseDBRoute.useDBRoute(entityType, dbRoute);
        this.allCtx = allCtx;
        boolean silenceHandleAllFilterAndOrderAndGroupBy = !initQueryParameter;
        MergeDBBeacon.markAboutHandleAllFilterAndOrderAndGroupBy();
        this.ctx = new QContext(entityType, fullObjName, selectFields, allCtx.getEntityTypeCache(), allCtx.getORMHint(), allCtx.getDistinctable(), silenceHandleAllFilterAndOrderAndGroupBy, allCtx.getSimpleEntityAliasMap(), allCtx);
        TenantAccountCrossDBRuntime.parseEntityTables(entityType, allCtx.getEntityTypeCache());
        this.queryParameter = this.createQueryParameter();
    }

    public DataSet query(String algoKey, boolean finallySingleQuery) {
        return (DataSet)this.query(algoKey, finallySingleQuery, -1, true);
    }

    public DataSet queryWithTop(String algoKey) {
        return (DataSet)this.query(algoKey, true, -1, false);
    }

    public DataSet queryWithTop(String algoKey, boolean removeInnerField) {
        return (DataSet)this.query(algoKey, true, -1, removeInnerField);
    }

    public PeekingDataSet queryPeeking(String algoKey, int peekingSize) {
        return (PeekingDataSet)this.query(algoKey, false, peekingSize, false);
    }

    public PeekingDataSet queryPeekingForLazyHashJoin(String algoKey, int roleOnCostThreshold) {
        return CacheableLazyQueryHashJoinDataSet.queryPeekingForHashJoin(this, new QueryHashJoinDataSetContext(roleOnCostThreshold));
    }

    public PeekingDataSet queryPeekingWithTop(String algoKey, int peekingSize) {
        return (PeekingDataSet)this.query(algoKey, true, peekingSize, false);
    }

    public PeekingDataSet queryPeekingWithTopForLazyQuery(String algoKey, int peekingSize, int queryTop) {
        this.top = queryTop;
        this.start = 0;
        this.limit = queryTop;
        return this.queryPeekingWithTop(algoKey, peekingSize);
    }

    private Object query(String algoKey, boolean finallySingleQuery, int peekingSize, boolean removeInnerField) {
        boolean peeking;
        JoinDBTodo.test();
        boolean bl = peeking = peekingSize > 0;
        if (this.emptyQuery) {
            if (peeking) {
                return EmptyDataSet.createEmptyPeekingDataSet(algoKey, this.selectFields);
            }
            return EmptyDataSet.createEmptyDataSet(algoKey, this.selectFields);
        }
        try (TemptableFacadeContext temptableContext = TemptableFacadeContexts.create((String)"SingleQuery.query");){
            boolean withParallel;
            QFilter whereQFilter;
            AutoRelease autoRelease = this.optInFilter();
            this.auditFilter();
            if (QueryConfig.isOneNotEqualsOneEnable() && (whereQFilter = this.queryParameter.genQueryParameterWhereQFilter) != null) {
                boolean flag = whereQFilter.toQParameter(this.ctx).getSql().contains("1!=1");
                List<QFilter.QFilterNest> nests = whereQFilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    if (nest.isAnd()) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    log.info("\u67e5\u8be2\u8bed\u53e5\u4e0d\u6267\u884c:\n" + this.queryParameter.getSql());
                    PeekingDataSet peekingDataSet = peeking ? EmptyDataSet.createEmptyPeekingDataSet(algoKey, this.selectFields) : EmptyDataSet.createEmptyDataSet(algoKey, this.selectFields);
                    return peekingDataSet;
                }
            }
            this.removeInnerField(finallySingleQuery, removeInnerField);
            if (this.containsExists(this.queryParameter.genQueryParameterWhereQFilter)) {
                this.shouldRebuildSQL = true;
            }
            if (this.shouldRebuildSQL) {
                this.queryParameter = this.createQueryParameter();
            }
            String sql = this.queryParameter.sql;
            if (finallySingleQuery && this.top >= 0) {
                sql = sql.startsWith(SQL_KEY_SELECT_DISTINCT) ? (this.limit > 0 ? "SELECT DISTINCT TOP " + this.limit + "," + this.start + ' ' + sql.substring(SQL_KEY_SELECT_DISTINCT.length()) : "SELECT DISTINCT TOP " + this.top + ' ' + sql.substring(SQL_KEY_SELECT_DISTINCT.length())) : (this.limit > 0 ? "SELECT TOP " + this.limit + "," + this.start + ' ' + sql.substring(SQL_KEY_SELECT.length()) : "SELECT TOP " + this.top + ' ' + sql.substring(SQL_KEY_SELECT.length()));
            }
            if (withParallel = QueryConfig.isParallelAlwaysEnable()) {
                sql = SQL_KEY_SELECT + QueryConfig.getParallelHint() + sql.substring(SQL_KEY_SELECT.length() - 1);
            }
            String fullSQL = "/*ORM*/ " + sql;
            DataSet ret = null;
            try {
                if (peeking) {
                    PeekingDataSet pds = this.ctx.getORMHint().isQueryAlone() ? (PeekingDataSet)DB.queryAlone(() -> DBExt.queryPeekingDataSet((String)algoKey, (DBRoute)this.dbRoute, (String)fullSQL, (Object[])this.queryParameter.params, (int)peekingSize, (QueryMeta)this.createQueryMeta())) : DBExt.queryPeekingDataSet((String)algoKey, (DBRoute)this.dbRoute, (String)fullSQL, (Object[])this.queryParameter.params, (int)peekingSize, (QueryMeta)this.createQueryMeta());
                    ret = this.handPrivacyData(pds, autoRelease, this.dbRoute, this.ctx.getORMHint().getCacheSize());
                } else {
                    DataSet ds = this.ctx.getORMHint().isQueryAlone() ? (DataSet)DB.queryAlone(() -> DBExt.queryDataSet((String)algoKey, (DBRoute)this.dbRoute, (String)fullSQL, (Object[])this.queryParameter.params, (QueryMeta)this.createQueryMeta())) : DBExt.queryDataSet((String)algoKey, (DBRoute)this.dbRoute, (String)fullSQL, (Object[])this.queryParameter.params, (QueryMeta)this.createQueryMeta());
                    ret = this.handPrivacyData(ds, autoRelease, this.dbRoute, this.ctx.getORMHint().getCacheSize());
                }
                if (autoRelease != null) {
                    autoRelease.onQueried();
                }
                this.closeTemptableContextTableList(temptableContext.getTableList(), ret);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (autoRelease != null) {
                        autoRelease.onQueried();
                    }
                    this.closeTemptableContextTableList(temptableContext.getTableList(), ret);
                    throw throwable;
                }
            }
            DataSet dataSet = ret;
            return dataSet;
        }
    }

    private void closeTemptableImmediate(List<TemptableFacade> tables) {
        for (TemptableFacade table : tables) {
            table.close();
        }
    }

    private void bindTemptableCloseListener(final List<TemptableFacade> temptableList, Object ret) {
        if (ret instanceof PeekingDataSet) {
            ((PeekingDataSet)ret).addListener(new DataSet.Listener(){

                public void afterClosed() {
                    SingleQuery.this.closeTemptableImmediate(temptableList);
                }
            });
        } else if (ret instanceof DataSet) {
            ((DataSet)ret).addListener(new DataSet.Listener(){

                public void afterClosed() {
                    SingleQuery.this.closeTemptableImmediate(temptableList);
                }
            });
        }
    }

    private void closeTemptableContextTableList(List<TemptableFacade> temptableList, Object ret) {
        ArrayList<TemptableFacade> tableList = new ArrayList<TemptableFacade>(temptableList);
        if (TX.inTX()) {
            ORMUtil.__releaseTemptable(tableList);
        } else {
            this.bindTemptableCloseListener(tableList, ret);
        }
    }

    private PeekingDataSet handPrivacyData(PeekingDataSet pds, final AutoRelease autoRelease, DBRoute dbRoute, Integer cacheSize) {
        try {
            if (!ORMConfig.PRIVACY_ENABLE.getBoolean()) {
                return pds;
            }
            String pkAlias = PrivacyDataQuery.getPkAlias(this.selectFields, this.entityType);
            Map<String, PrivacyFieldInfo> privacyFields = PrivacyDataQuery.getPrivacyFields(pds.getRowMeta(), this.selectFields, this.allCtx.getMainEntityItem().getFullObjectName(), pkAlias, this.allCtx);
            if (privacyFields == null || privacyFields.isEmpty()) {
                return pds;
            }
            PrivacyPeekingDataSet ppds = new PrivacyPeekingDataSet(pds, pkAlias, dbRoute, this.entityType.getAlias(), privacyFields, cacheSize);
            if (autoRelease != null) {
                ppds.addListener(new DataSet.Listener(){

                    public void beforeClosed() {
                        autoRelease.close();
                    }
                });
            }
            return ppds;
        }
        catch (Exception e) {
            log.error("handle privacy field error", (Throwable)e);
            return pds;
        }
    }

    private DataSet handPrivacyData(DataSet ds, final AutoRelease autoRelease, DBRoute dbRoute, Integer cacheSize) {
        try {
            if (!ORMConfig.PRIVACY_ENABLE.getBoolean()) {
                return ds;
            }
            String pkAlias = PrivacyDataQuery.getPkAlias(this.selectFields, this.entityType);
            Map<String, PrivacyFieldInfo> privacyFields = PrivacyDataQuery.getPrivacyFields(ds.getRowMeta(), this.selectFields, this.allCtx.getMainEntityItem().getFullObjectName(), pkAlias, this.allCtx);
            if (privacyFields == null || privacyFields.isEmpty()) {
                return ds;
            }
            PrivacyDataSet ppds = new PrivacyDataSet(ds, pkAlias, dbRoute, this.entityType.getAlias(), privacyFields, cacheSize);
            if (autoRelease != null) {
                ppds.addListener(new DataSet.Listener(){

                    public void beforeClosed() {
                        autoRelease.close();
                    }
                });
            }
            return ppds;
        }
        catch (Exception e) {
            log.error("handle privacy field error", (Throwable)e);
            return ds;
        }
    }

    public AutoRelease optInFilter() {
        if (!HugeInConfig.isEnableOpt() || HugeInConfig.getOptType() == HugeInConfig.OptType.split_in) {
            return null;
        }
        try {
            final ArrayList<AutoRelease> all = new ArrayList<AutoRelease>();
            HashSet<String> objNameSet = new HashSet<String>();
            objNameSet.addAll(this.getCurFilterObjSet());
            this.sortJoinTable(this.ctx.getJoinTableList());
            List<JoinTableInfo> joinTableList = this.ctx.getJoinTableList();
            for (JoinTableInfo jti : joinTableList) {
                String joinObjectFullName = jti.getTableAlias();
                boolean shouldAdd = false;
                for (String name : objNameSet) {
                    if (!joinObjectFullName.startsWith(name + ".") || !ORMConfiguration.isEntryEntityType(jti.getEntityItem().entityType)) continue;
                    shouldAdd = true;
                    break;
                }
                if (!shouldAdd) continue;
                objNameSet.add(joinObjectFullName);
            }
            for (String objName : objNameSet) {
                QFilter havingFilter;
                QFilter whereFilter = this.allFilterMap.get(objName);
                if (whereFilter != null) {
                    this.optInFilter(whereFilter, all);
                }
                if ((havingFilter = this.allHavingFilterMap.get(objName)) == null) continue;
                this.optInFilter(havingFilter, all);
            }
            if (all.isEmpty()) {
                return null;
            }
            if (all.size() == 1) {
                this.queryParameter = this.createQueryParameter();
                return (AutoRelease)all.get(0);
            }
            this.queryParameter = this.createQueryParameter();
            return new AutoRelease(){

                @Override
                public void close() {
                    for (AutoRelease ar : all) {
                        ar.close();
                    }
                }

                @Override
                public void onQueried() {
                    for (AutoRelease ar : all) {
                        ar.onQueried();
                    }
                }
            };
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }

    private void optInFilter(QFilter filterLinks, List<AutoRelease> all) {
        if (filterLinks.getValue() instanceof MultiBaseDataFilterValue) {
            this.multiTypeQFilter = filterLinks.copy();
        }
        List<QFilter> inFilters = HugeInUtil.findOptInFilter(filterLinks, this.dbRoute, this.allCtx);
        DBType dbType = DB.getDBType((DBRoute)this.dbRoute);
        for (QFilter filter : inFilters) {
            if (TableVariableUtil.allowUseTableVariable((DBType)dbType)) {
                HugeInUtil.optWithVariableTable(filter, dbType);
                this.shouldRebuildSQL = true;
                continue;
            }
            try {
                Pair<AutoRelease, QFilter> pair;
                if (filter.__getParsedPropertyFields().isEmpty()) {
                    filter.toQParameter(this.ctx);
                }
                if ((pair = HugeInUtil.optWithTemplateTableAsJoin(filter, filterLinks, this.dbRoute, this.ctx.getEntityTypeCache(), dbType, this.fullObjName, this.ctx)) != null) {
                    QFilter newFilter = (QFilter)pair.getValue();
                    newFilter.toQParameter(this.ctx);
                    QFilter oldJoinFilter = this.allJoinFilterMap.get(newFilter.getJoinEntityPath());
                    if (oldJoinFilter == null) {
                        this.allJoinFilterMap.put(newFilter.getJoinEntityPath(), newFilter);
                    } else {
                        this.allJoinFilterMap.put(newFilter.getJoinEntityPath(), newFilter.and(oldJoinFilter));
                    }
                    all.add((AutoRelease)pair.getKey());
                    this.shouldRebuildSQL = true;
                    this.allCtx.getORMHint().setOptMainExtJoin(false);
                    continue;
                }
                AutoRelease releaseTable = HugeInUtil.optWithTemplateTableAsSubQuery(filter, this.dbRoute, this.ctx);
                if (releaseTable == null) continue;
                all.add(releaseTable);
                this.shouldRebuildSQL = true;
            }
            catch (RuntimeException e) {
                if (PKTempTableUtil.isReadOnlyException((Exception)e)) {
                    log.error((Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    public SqlRequest getQuerySql() {
        return new SqlRequest(this.queryParameter.sql, this.queryParameter.params, this.dbRoute, this.parentFK);
    }

    public QueryMeta createQueryMeta() {
        boolean isConvertField = this.ctx.getORMHint().isConvertField();
        QueryMeta qm = new QueryMeta();
        Field[] fs = new Field[this.selectFields.length];
        int i = 0;
        for (PropertyField f : this.selectFields) {
            IDataEntityProperty dp = f.getPeropertyType();
            String name = f.getAlias();
            if (isConvertField) {
                if (dp instanceof IComplexProperty) {
                    dp = ((IComplexProperty)dp).getComplexType().getPrimaryKey();
                }
                DataType dt = this.getDataType(f, dp);
                boolean nullable = dp != null && dp.isEnableNull();
                Field fieldItem = new Field(name, dt, nullable);
                fs[i++] = fieldItem;
                if (!(dp instanceof ISimpleProperty)) continue;
                if (((ISimpleProperty)dp).getPrivacyType() != 0L) {
                    if (dp.getParent() == null) continue;
                    String privacyName = dp.getName() + "_pr";
                    IDataEntityProperty privacyProp = (IDataEntityProperty)dp.getParent().getProperties().get((Object)privacyName);
                    if (!(privacyProp instanceof IPrivacyProperty)) continue;
                    qm.setTransFunction(fieldItem, FieldDecrypt.getPrivacyConverter((IPrivacyProperty)privacyProp));
                    continue;
                }
                if (!((ISimpleProperty)dp).isEncrypt()) continue;
                qm.setTransFunction(fieldItem, FieldDecrypt.get((ISimpleProperty)dp));
                continue;
            }
            Field fieldItem = new Field(name, (DataType)DateType.UnknownType, true);
            fs[i++] = fieldItem;
        }
        qm.setRowMeta(new RowMeta(fs));
        return qm;
    }

    private DataType getDataType(PropertyField field, IDataEntityProperty dp) {
        NullType dt = null;
        String fiedldName = field.getName();
        if ("NULL".equalsIgnoreCase(fiedldName)) {
            dt = DateType.NullType;
        } else if (dp != null) {
            dt = DataSetDataType.getDataType((Class)dp.getPropertyType());
        } else {
            Literal literal = field.getPropertySegExpress().getLiteral();
            if (literal != null) {
                dt = literal.getDataType();
            }
            if (dt == null) {
                dt = DateType.UnknownType;
            }
        }
        return dt;
    }

    private void auditFilter() {
        QFilter havingFilter;
        LinkedList<QFilter> allFilter = new LinkedList<QFilter>();
        QFilter whereFilter = this.getWhereFilter();
        if (whereFilter != null) {
            allFilter.add(whereFilter);
            for (QFilter.QFilterNest qFilterNest : whereFilter.getNests(true)) {
                allFilter.add(qFilterNest.getFilter());
            }
        }
        if ((havingFilter = this.getHavingFilter()) != null) {
            allFilter.add(havingFilter);
            for (QFilter.QFilterNest nest : havingFilter.getNests(true)) {
                allFilter.add(nest.getFilter());
            }
        }
        if (!allFilter.isEmpty()) {
            String string = this.entityType.getPrimaryKey().getName().toLowerCase(Locale.ENGLISH);
            for (QFilter filter : allFilter) {
                String cp;
                PropertyField pf;
                if (ForbidExpressPropertyFilter.isEnable() && ((pf = filter.__getParsedProperty(this.ctx)).isExpress() && ForbidExpressPropertyFilter.audit((String)this.queryParameter.sql) || filter.isExpressValue() && ((pf = filter.__getParsedExpressValue(this.ctx)) == null || pf.isExpress()) && ForbidExpressPropertyFilter.audit((String)this.queryParameter.sql))) break;
                if (!ForbidPKRangeFilter.isEnable() || (filter.isExpressValue() || !string.equalsIgnoreCase(filter.getProperty())) && (!filter.isExpressValue() || !string.equalsIgnoreCase(String.valueOf(filter.getValue()))) || !"<".equals(cp = filter.getCP()) && !">".equals(cp) && !">=".equals(cp) && !"<=".equals(cp)) continue;
                ForbidPKRangeFilter.audit((String)this.queryParameter.sql);
                break;
            }
        }
    }

    public boolean withCrossDBObjectOrFilter() {
        return this.isWithCrossDBObjectOrFilter;
    }

    private boolean hasCrossDBObjectOrFilter(QFilter whereFilter, QFilter havingFilter) {
        return this.hasCrossDBObjectOrFilter(whereFilter) || this.hasCrossDBObjectOrFilter(havingFilter);
    }

    private boolean hasCrossDBObjectOrFilter(QFilter filterChain) {
        if (filterChain != null) {
            HashSet<String> objectNames = new HashSet<String>(4);
            HashSet<String> routeKeys = new HashSet<String>(4);
            for (QFilter filter : filterChain.recombine()) {
                List<QFilter.QFilterNest> nests = filter.getNests(true);
                if (nests.isEmpty()) continue;
                objectNames.clear();
                for (PropertyField pf : filter.__getParsedPropertyFields()) {
                    objectNames.add(pf.getFullObjectName());
                }
                for (QFilter.QFilterNest nest : nests) {
                    for (PropertyField pf : nest.getFilter().__getParsedPropertyFields()) {
                        objectNames.add(pf.getFullObjectName());
                    }
                }
                routeKeys.clear();
                block4: for (String fullName : objectNames) {
                    while (true) {
                        String routeKey = this.ctx.getEntityItem((String)fullName).entityType.getDBRouteKey().toLowerCase();
                        routeKeys.add(routeKey);
                        int i = fullName.lastIndexOf(46);
                        if (i == -1) continue block4;
                        fullName = fullName.substring(0, i);
                    }
                }
                if (TenantAccountCrossDBRuntime.useSameDB(routeKeys)) continue;
                if (!TenantAccountCrossDBRuntime.isCrossDBEnable() && Boolean.parseBoolean(System.getProperty("orm.crossdb.check", "false"))) {
                    throw new RuntimeException("Found cross object or filter (crossdb disabled): " + filter);
                }
                return true;
            }
        }
        return false;
    }

    public void setEmptyQuery(boolean emptyQuery) {
        this.emptyQuery = emptyQuery;
    }

    public QContext getAllCtx() {
        return this.allCtx;
    }

    public QContext getCtx() {
        return this.ctx;
    }

    public List<OrderByInfo> getOrderInfoList() {
        ArrayList<OrderByInfo> ret = new ArrayList<OrderByInfo>();
        for (OrderByInfo orderBy : this.allOrderByList) {
            if (!this.myFullObjNameSet.contains(orderBy.getFullObjectName())) continue;
            ret.add(orderBy);
        }
        return ret;
    }

    public List<GroupByInfo> getGroupByInfoList() {
        ArrayList<GroupByInfo> ret = new ArrayList<GroupByInfo>();
        for (GroupByInfo groupBy : this.allGroupByList) {
            if (!this.myFullObjNameSet.contains(groupBy.getFullObjectName())) continue;
            ret.add(groupBy);
        }
        return ret;
    }

    public boolean isInnerJoin() {
        return this.isForceInnerJoin || this.withUserOriginFilter;
    }

    public void forceInnerJoin() {
        this.isForceInnerJoin = true;
    }

    void setWithUserOriginFilter(boolean withUserOriginFilter) {
        this.withUserOriginFilter = withUserOriginFilter;
        if (withUserOriginFilter) {
            this.forceInnerJoin();
        }
    }

    public boolean withWhereFilter() {
        for (String objName : this.myFullObjNameSet) {
            QFilter objFilter = this.allFilterMap.get(objName);
            if (objFilter == null) continue;
            return true;
        }
        return false;
    }

    public QFilter getWhereFilter() {
        QFilter ret = null;
        for (String objName : this.myFullObjNameSet) {
            QFilter objFilter = this.allFilterMap.get(objName);
            if (objFilter == null) continue;
            objFilter = objFilter.copy();
            if (ret == null) {
                ret = objFilter;
                continue;
            }
            ret = ret.and(objFilter);
        }
        return ret;
    }

    public QFilter getHavingFilter() {
        QFilter ret = null;
        for (String objName : this.curFilterObjSet) {
            QFilter objFilter = this.allHavingFilterMap.get(objName);
            if (objFilter == null) continue;
            objFilter = objFilter.copy();
            if (ret == null) {
                ret = objFilter;
                continue;
            }
            ret = ret.and(objFilter);
        }
        return ret;
    }

    public QFilter getJoinOnFilter() {
        QFilter ret = null;
        for (String objName : this.curFilterObjSet) {
            QFilter objFilter = this.allJoinFilterMap.get(objName);
            if (objFilter == null) continue;
            objFilter = objFilter.copy();
            if (ret == null) {
                ret = objFilter;
                continue;
            }
            ret = ret.and(objFilter);
        }
        return ret;
    }

    int getQueryObjectCount() {
        return this.myFullObjNameSet.size();
    }

    public Set<String> getCurFilterObjSet() {
        return this.curFilterObjSet;
    }

    public List<OrderByInfo> getAllOrderByList() {
        return this.allOrderByList;
    }

    public Map<String, QFilter> getAllWhereFilterMap() {
        return this.allFilterMap;
    }

    public void setOrderByOnSQL(boolean orderByOnSQL) {
        this.orderByOnSQL = orderByOnSQL;
    }

    public boolean isOrderByOnSQL() {
        return this.orderByOnSQL;
    }

    public QueryParameter getQueryParameter() {
        if (this.containsExists(this.queryParameter.genQueryParameterWhereQFilter)) {
            this.shouldRebuildSQL = true;
        }
        if (this.shouldRebuildSQL) {
            this.queryParameter = this.createQueryParameter();
        }
        return this.queryParameter;
    }

    /*
     * Loose catch block
     */
    private QueryParameter createQueryParameter() {
        Throwable throwable;
        QFilter havingFilter;
        QFilter whereFilter;
        if (this.performJoinFieldList != null) {
            for (PropertyField field : this.performJoinFieldList) {
                this.ctx.putPerformJoinField(field);
            }
        }
        if ((whereFilter = this.allFilterMap.get(this.fullObjName)) != null) {
            whereFilter = whereFilter.copy();
        }
        if ((havingFilter = this.allHavingFilterMap.get(this.fullObjName)) != null) {
            havingFilter = havingFilter.copy();
        }
        this.myFullObjNameSet.add(this.fullObjName);
        for (JoinTableInfo join : this.ctx.getJoinTableList()) {
            JoinTableTypeEnum type = join.getJoinTableType();
            if (type == JoinTableTypeEnum.extend || type == JoinTableTypeEnum.multi_lang) continue;
            String joinFullObjName = join.getEntityItem().getFullObjectName();
            QFilter and = this.allFilterMap.get(joinFullObjName);
            if (and != null) {
                and = and.copy();
            }
            if (whereFilter == null) {
                whereFilter = and;
            } else if (and != null) {
                whereFilter = whereFilter.and(and);
            }
            and = this.allHavingFilterMap.get(joinFullObjName);
            if (and != null) {
                and = and.copy();
            }
            if (havingFilter == null) {
                havingFilter = and;
            } else if (and != null) {
                havingFilter = havingFilter.and(and);
            }
            this.myFullObjNameSet.add(joinFullObjName);
        }
        if (ORMUtil.isMainExtOptOpen(this.allCtx.getORMHint().isOptMainExtJoin())) {
            try {
                throwable = null;
                try (ExtendReplaceMain extendReplaceMain = this.tryReplaceMainByExtend(whereFilter, havingFilter);){
                    Map<JoinTableInfo, List<JoinTableInfo>> joinTableInfoJoinTableInfoMap = extendReplaceMain.replaceMainJoinTableInfoMap();
                    Map<JoinTableInfo, JoinTableInfo> replaceMainJoinTableInfoMap = this.replaceJoinFieldForExtend(extendReplaceMain.withOutReplaceJoinTableInfo(), joinTableInfoJoinTableInfoMap);
                    QueryParameter queryParameter = this.doCreateQueryParameter(whereFilter, havingFilter, replaceMainJoinTableInfoMap, extendReplaceMain.replaceFromJoinTableInfo(), true);
                    return queryParameter;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                {
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
            finally {
                this.shouldRebuildSQL = false;
                this.ctx.setReplaceEntityAliasMap(null);
            }
        }
        try {
            throwable = null;
            try (LangReplaceMain replace = this.tryReplaceMainByLang(whereFilter, havingFilter);){
                QueryParameter queryParameter = this.doCreateQueryParameter(whereFilter, havingFilter, replace.replaceMainJoinTableInfoMap(), replace.replaceFromJoinTableInfo(), false);
                return queryParameter;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            {
                catch (Throwable throwable5) {
                    throw throwable5;
                }
            }
        }
        finally {
            this.shouldRebuildSQL = false;
            this.ctx.setReplaceEntityAliasMap(null);
        }
    }

    private boolean hasJoinSQLFilter(QFilter f) {
        if (f != null) {
            if (f.isJoinSQLFilter()) {
                return true;
            }
            for (QFilter.QFilterNest nest : f.getNests(true)) {
                if (!nest.getFilter().isJoinSQLFilter()) continue;
                return true;
            }
        }
        return false;
    }

    private LangReplaceMain tryReplaceMainByLang(QFilter whereFilter, QFilter havingFilter) {
        if (!ENABLE_OPTIMIZE_LANG_MAINTABLE || this.hasJoinSQLFilter(whereFilter) || this.hasJoinSQLFilter(this.getJoinOnFilter()) || this.hasJoinSQLFilter(havingFilter)) {
            return empty_LangReplaceMain;
        }
        if (this.allCtx.getgLanTransLanFullObjectNameSet().contains(this.fullObjName)) {
            return empty_LangReplaceMain;
        }
        this.tryReplaceMainByLang_prePerformJoin(whereFilter, havingFilter);
        HashMap<SingleQueryTableInfo, SingleQueryTableInfo> mainLangTableInfoMap = new HashMap<SingleQueryTableInfo, SingleQueryTableInfo>();
        HashMap<String, SingleQueryTableInfo> allTableInfoMap = new HashMap<String, SingleQueryTableInfo>(4);
        allTableInfoMap.put(this.fullObjName, SingleQueryTableInfo.createSingleQueryTableInfoByFromTable(this.entityType, this.fullObjName));
        for (JoinTableInfo join : this.ctx.getJoinTableList()) {
            allTableInfoMap.put(join.getTableAlias(), SingleQueryTableInfo.createSingleQueryTableInfoByJoinTable(join));
        }
        for (JoinTableInfo langJoin : this.ctx.getJoinTableList()) {
            if (langJoin.getJoinTableType() != JoinTableTypeEnum.multi_lang) continue;
            boolean findMain = false;
            String mainAlias = langJoin.getJoinTableAlias();
            for (JoinTableInfo joinTableInfo : this.ctx.getJoinTableList()) {
                if (!joinTableInfo.getTableAlias().equals(mainAlias)) continue;
                SingleQueryTableInfo mainTableInfo = (SingleQueryTableInfo)allTableInfoMap.get(joinTableInfo.getTableAlias());
                SingleQueryTableInfo langTableInfo = (SingleQueryTableInfo)allTableInfoMap.get(langJoin.getTableAlias());
                if (!this.allCtx.getgLanTransLanFullObjectNameSet().contains(langTableInfo.getFullObjectName())) {
                    mainLangTableInfoMap.put(mainTableInfo, langTableInfo);
                }
                findMain = true;
                break;
            }
            if (findMain) continue;
            SingleQueryTableInfo mainTableInfo = (SingleQueryTableInfo)allTableInfoMap.get(this.fullObjName);
            SingleQueryTableInfo singleQueryTableInfo = (SingleQueryTableInfo)allTableInfoMap.get(langJoin.getTableAlias());
            if (this.allCtx.getgLanTransLanFullObjectNameSet().contains(singleQueryTableInfo.getFullObjectName())) continue;
            mainLangTableInfoMap.put(mainTableInfo, singleQueryTableInfo);
        }
        HashMap<SingleQueryTableInfo, Object> replaceMap = new HashMap<SingleQueryTableInfo, Object>();
        if (!mainLangTableInfoMap.isEmpty()) {
            HashMap<String, String> replaceAliasMap = new HashMap<String, String>();
            for (Map.Entry entry : mainLangTableInfoMap.entrySet()) {
                SingleQueryTableInfo mainJoin = (SingleQueryTableInfo)entry.getKey();
                SingleQueryTableInfo singleQueryTableInfo = (SingleQueryTableInfo)entry.getValue();
                boolean canIgnoreJoin = true;
                if (!mainJoin.isFromTable() && !mainJoin.joinTable.getField().equalsIgnoreCase(mainJoin.entityType.getPrimaryKey().getAlias())) {
                    canIgnoreJoin = false;
                }
                if (!mainJoin.isFromTable()) {
                    canIgnoreJoin &= mainJoin.joinTable.getJoin() != ORMHint.JoinHint.INNER;
                }
                if (!singleQueryTableInfo.isFromTable()) {
                    canIgnoreJoin &= singleQueryTableInfo.joinTable.getJoin() != ORMHint.JoinHint.INNER;
                }
                if (canIgnoreJoin &= this.canReplaceByLang_selectFields(mainJoin)) {
                    String pk = mainJoin.entityType.getPrimaryKey().getName().toLowerCase();
                    if (canIgnoreJoin &= this.canReplaceByLang_QFilter(mainJoin, singleQueryTableInfo, pk, whereFilter)) {
                        canIgnoreJoin &= this.canReplaceByLang_QFilter(mainJoin, singleQueryTableInfo, pk, havingFilter);
                    }
                    if (canIgnoreJoin && singleQueryTableInfo.joinTable.getJoinFilters() != null) {
                        canIgnoreJoin &= this.canReplaceByLang_QFilter(mainJoin, singleQueryTableInfo, pk, singleQueryTableInfo.joinTable.getJoinFilters());
                    }
                    if (canIgnoreJoin) {
                        canIgnoreJoin &= this.canReplaceByLang_orderBy(mainJoin, singleQueryTableInfo, pk);
                    }
                    if (canIgnoreJoin) {
                        canIgnoreJoin &= this.canReplaceByLang_groupBy(mainJoin, singleQueryTableInfo, pk);
                    }
                }
                if (canIgnoreJoin) {
                    for (SingleQueryTableInfo join : allTableInfoMap.values()) {
                        if (join.isFromTable() || join == mainJoin || join == singleQueryTableInfo || !join.joinTable.getJoinTableAlias().equalsIgnoreCase(mainJoin.getTableAlias())) continue;
                        String pkField = mainJoin.entityType.getPrimaryKey().getAlias();
                        if (join.joinTable.getJoinField().equalsIgnoreCase(pkField)) continue;
                        canIgnoreJoin = false;
                        break;
                    }
                }
                if (!canIgnoreJoin) continue;
                replaceAliasMap.put(mainJoin.getTableAlias(), singleQueryTableInfo.getTableAlias());
                replaceMap.put(singleQueryTableInfo, mainJoin);
            }
            final HashMap<JoinTableInfo, JoinTableInfo> replaceMainJoinTableInfoMap = new HashMap<JoinTableInfo, JoinTableInfo>();
            JoinTableInfo replaceFromJoinTableInfo = null;
            for (Map.Entry entry : replaceMap.entrySet()) {
                SingleQueryTableInfo main = (SingleQueryTableInfo)entry.getValue();
                if (main.isFromTable()) {
                    replaceFromJoinTableInfo = ((SingleQueryTableInfo)entry.getKey()).joinTable;
                    continue;
                }
                replaceMainJoinTableInfoMap.put(((SingleQueryTableInfo)entry.getKey()).joinTable, main.joinTable);
            }
            this.ctx.setReplaceEntityAliasMap(replaceAliasMap);
            final JoinTableInfo aReplaceFromJoinTableInfo = replaceFromJoinTableInfo;
            return new LangReplaceMain(){

                @Override
                public void close() {
                    SingleQuery.this.ctx.setReplaceEntityAliasMap(null);
                }

                @Override
                public Map<JoinTableInfo, JoinTableInfo> replaceMainJoinTableInfoMap() {
                    return replaceMainJoinTableInfoMap;
                }

                @Override
                public JoinTableInfo replaceFromJoinTableInfo() {
                    return aReplaceFromJoinTableInfo;
                }
            };
        }
        return empty_LangReplaceMain;
    }

    private boolean canReplaceByLang_selectFields(SingleQueryTableInfo mainJoin) {
        String joinFullObjectAliasName = mainJoin.getTableAlias();
        for (PropertyField pf : this.selectFields) {
            Collection<PropertyField> propertyFields;
            String fullObjectAliasName = pf.getEntityAlias();
            if (StringUtils.isEmpty(fullObjectAliasName) && (propertyFields = pf.getPropertySegExpress().getPropertyFields()) != null && propertyFields.size() > 0) {
                for (PropertyField mulField : propertyFields) {
                    String entityAlias = mulField.getEntityAlias();
                    if (this.ignore(joinFullObjectAliasName, entityAlias, mulField)) continue;
                    return false;
                }
            }
            if (this.ignore(joinFullObjectAliasName, fullObjectAliasName, pf)) continue;
            return false;
        }
        return true;
    }

    private boolean ignore(String joinFullObjectAliasName, String entityAlias, PropertyField field) {
        if (joinFullObjectAliasName.equals(entityAlias)) {
            boolean isPKField = field.getEntityType().getPrimaryKey().getName().equalsIgnoreCase(field.getName());
            if (field.isExpress() || !isPKField) {
                return false;
            }
        }
        return !field.isMultiLangProperty() || field.canIgnoreJoinMainTable();
    }

    private boolean canReplaceByLang_orderBy(SingleQueryTableInfo mainJoin, SingleQueryTableInfo langJoin, String pk) {
        if (this.orderByOnSQL) {
            for (OrderByInfo ob : this.getOrderInfoList()) {
                String mainFullObjectName = mainJoin.getFullObjectName().toLowerCase(Locale.ENGLISH);
                PropertySegExpress pe = ob.getPropertySegExpress();
                if (pe != null && !pe.isExpress()) {
                    PropertyField pf;
                    if (!ob.getFullObjectName().toLowerCase(Locale.ENGLISH).equals(mainFullObjectName) || (pf = pe.getPropertyField()).getName().equals(pk)) continue;
                    if (pf.isMultiLangProperty() && !pf.canIgnoreJoinMainTable()) {
                        return false;
                    }
                    IDataEntityProperty pType = (IDataEntityProperty)mainJoin.entityType.getProperties().get((Object)pf.getName());
                    if (pType != null && ORMConfiguration.isMultiLangPropertyType(pType)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private boolean canReplaceByLang_groupBy(SingleQueryTableInfo mainJoin, SingleQueryTableInfo langJoin, String pk) {
        for (GroupByInfo gb : this.getGroupByInfoList()) {
            String mainFullObjectName = mainJoin.getFullObjectName().toLowerCase(Locale.ENGLISH);
            PropertySegExpress pe = gb.getPropertySegExpress();
            if (pe != null && !pe.isExpress()) {
                PropertyField pf;
                if (!gb.getFullObjectName().toLowerCase(Locale.ENGLISH).equals(mainFullObjectName) || (pf = pe.getPropertyField()).getName().equals(pk)) continue;
                if (pf.isMultiLangProperty() && !pf.canIgnoreJoinMainTable()) {
                    return false;
                }
                IDataEntityProperty pType = (IDataEntityProperty)mainJoin.entityType.getProperties().get((Object)pf.getName());
                if (pType != null && ORMConfiguration.isMultiLangPropertyType(pType)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void tryReplaceMainByLang_prePerformJoin(QFilter whereFilter, QFilter havingFilter) {
        if (whereFilter != null) {
            whereFilter.toQParameter(this.ctx);
        }
        if (this.orderByOnSQL) {
            for (OrderByInfo orderBy : this.getOrderInfoList()) {
                try {
                    this.ctx.getOrderBy(orderBy);
                }
                catch (NoSuchPropertyException noSuchPropertyException) {}
            }
        }
        for (GroupByInfo groupBy : this.getGroupByInfoList()) {
            try {
                this.ctx.getGroupBy(groupBy);
            }
            catch (NoSuchPropertyException e) {
                log.warn("multiBasedata getOrderBy failed , try allCtx, fullObjName=" + this.fullObjName);
                this.allCtx.getGroupBy(groupBy);
            }
        }
        if (havingFilter != null) {
            havingFilter.toQParameter(this.ctx);
        }
    }

    private boolean canReplaceByLang_QFilter(SingleQueryTableInfo mainJoin, SingleQueryTableInfo langJoin, String pk, QFilter whereFilter) {
        if (whereFilter != null) {
            ArrayList<QFilter> segs = new ArrayList<QFilter>(16);
            segs.add(whereFilter);
            for (QFilter.QFilterNest nest : whereFilter.getNests(true)) {
                segs.add(nest.getFilter());
            }
            String mainFullObjectName = mainJoin.getTableAlias();
            for (QFilter f : segs) {
                if (QMatches.isFtlike(f)) {
                    return false;
                }
                PropertyField pf = f.__getParsedProperty(this.ctx);
                if (pf.isMultiLangProperty() && !pf.canIgnoreJoinMainTable()) {
                    return false;
                }
                if (!this.langHasProperty(pf, mainFullObjectName, mainJoin, pk, false)) {
                    return false;
                }
                if (!f.isExpressValue() || (pf = f.__getParsedExpressValue(this.ctx)) != null && this.langHasProperty(pf, mainFullObjectName, mainJoin, pk, false)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean langHasProperty(PropertyField rootPF, String mainFullObjectName, SingleQueryTableInfo mainJoin, String pk, boolean isMatchPF) {
        if ((rootPF = this.ctx.putPerformJoinField(rootPF)) != null) {
            ArrayList<PropertyField> pfs = new ArrayList<PropertyField>();
            if (rootPF.isExpress()) {
                pfs.addAll(rootPF.getPropertySegExpress().getPropertyFields());
            } else {
                pfs.add(rootPF);
            }
            for (PropertyField pf : pfs) {
                IDataEntityProperty pType;
                if (!(mainFullObjectName.equals(pf.getFullObjectName()) ? !pf.getName().equals(pk) && ((pType = (IDataEntityProperty)mainJoin.entityType.getProperties().get((Object)pf.getName())) == null || !ORMConfiguration.isMultiLangPropertyType(pType)) : isMatchPF)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private QueryParameter doCreateQueryParameter(QFilter whereFilter, QFilter havingFilter, Map<JoinTableInfo, JoinTableInfo> replaceTableInfoMap, JoinTableInfo replaceFromJoinTableInfo, boolean replaceExtend) {
        void var12_16;
        boolean copyAndSet;
        Boolean booleanExt = ORMUtil.isMainExtOptOpen(this.allCtx.getORMHint().isOptMainExtJoin());
        QueryParameter ret = new QueryParameter();
        String sqlWhere = null;
        QParameter whereQP = null;
        if (whereFilter != null) {
            whereQP = whereFilter.toQParameter(this.ctx);
            sqlWhere = whereQP.getSql();
        }
        this.myFullObjNameSet.addAll(this.ctx.getCurrentSelectObjectSet());
        String sqlOrderBy = null;
        if (this.orderByOnSQL) {
            for (OrderByInfo orderByInfo : this.getOrderInfoList()) {
                String seg;
                try {
                    seg = this.ctx.getOrderBy(orderByInfo);
                }
                catch (NoSuchPropertyException e) {
                    log.warn("multiBasedata getOrderBy failed , try allCtx, fullObjName=" + this.fullObjName);
                    seg = this.allCtx.getOrderBy(orderByInfo);
                }
                if (sqlOrderBy == null) {
                    sqlOrderBy = "\r\nORDER BY " + seg;
                    continue;
                }
                sqlOrderBy = sqlOrderBy + ", " + seg;
            }
        }
        StringBuilder sqlGroupBy = null;
        for (GroupByInfo groupBy : this.getGroupByInfoList()) {
            String seg;
            try {
                seg = this.ctx.getGroupBy(groupBy);
            }
            catch (NoSuchPropertyException e) {
                log.warn("multiBasedata getOrderBy failed , try allCtx, fullObjName=" + this.fullObjName);
                seg = this.allCtx.getGroupBy(groupBy);
            }
            if (sqlGroupBy == null) {
                sqlGroupBy = new StringBuilder("\r\nGROUP BY ").append(seg);
                continue;
            }
            sqlGroupBy.append(", ").append(seg);
        }
        Object var12_14 = null;
        QParameter havingQP = null;
        if (havingFilter != null) {
            havingQP = havingFilter.toQParameter(this.ctx);
            String string = "\r\nHAVING " + havingQP.getSql();
        }
        this.sortJoinTable(this.ctx.getJoinTableList());
        StringBuilder sql = new StringBuilder(1024);
        sql.append(SQL_KEY_SELECT);
        boolean hasDistinct = false;
        if (this.ctx.getDistinctable() != null && this.fullObjName.indexOf(46) == -1) {
            HashMap joinEntitySelectFieldMap = new HashMap(16);
            for (JoinTableInfo join : this.ctx.getJoinTableList()) {
                joinEntitySelectFieldMap.put(join.getEntityItem().getFullObjectName(), Boolean.FALSE);
            }
            for (PropertyField f : this.selectFields) {
                if (f.isExpress()) {
                    if (f.getPropertySegExpress() == null) continue;
                    for (PropertyField ef : f.getPropertySegExpress().getPropertyFields()) {
                        if (!joinEntitySelectFieldMap.containsKey(ef.getFullObjectName())) continue;
                        joinEntitySelectFieldMap.put(ef.getFullObjectName(), Boolean.TRUE);
                    }
                    continue;
                }
                if (!joinEntitySelectFieldMap.containsKey(f.getFullObjectName())) continue;
                joinEntitySelectFieldMap.put(f.getFullObjectName(), Boolean.TRUE);
            }
            if (this.ctx.getDistinctable().distinct(this.entityType, joinEntitySelectFieldMap, this.ctx)) {
                hasDistinct = true;
                this.hasDistinct = true;
            }
        }
        if (!hasDistinct) {
            for (JoinTableInfo join : this.ctx.getJoinTableList()) {
                EntityItem ei = join.getEntityItem();
                if (!ORMConfiguration.isMulBasedata(ei.entityType)) continue;
                hasDistinct = true;
                this.hasDistinct = true;
                break;
            }
        }
        if (hasDistinct) {
            sql.append(SQL_KEY_DISTINCT);
        }
        this.isWithCrossDBObjectOrFilter = this.hasCrossDBObjectOrFilter(whereFilter, havingFilter);
        sql.append(this.ctx.getSelects(this.fullObjName, hasDistinct, this.selectFields));
        sql.append("\r\nFROM ");
        QParameter langAsMainQP = null;
        if (replaceFromJoinTableInfo != null) {
            String langAlias;
            if (replaceFromJoinTableInfo.getJoinTableType() == JoinTableTypeEnum.extend) {
                langAlias = this.ctx.getSimpleEntityAlias(replaceFromJoinTableInfo.getTableAlias());
                String tableName = TenantAccountCrossDBRuntime.getCrossDBTable(replaceFromJoinTableInfo.getEntityItem() == null ? null : replaceFromJoinTableInfo.getEntityItem().entityType.getDBRouteKey(), replaceFromJoinTableInfo.getTable(), this.dbRoute.getRouteKey(), this.isWithCrossDBObjectOrFilter);
                String table = replaceFromJoinTableInfo.getTable();
                int index = table.lastIndexOf("_");
                this.tableToEntity.put(tableName.toLowerCase(), this.fullObjName.toLowerCase() + table.substring(index));
                sql.append(tableName).append(' ').append(langAlias).append(" ");
            } else {
                langAlias = this.ctx.getSimpleEntityAlias(replaceFromJoinTableInfo.getTableAlias());
                String tableName = TenantAccountCrossDBRuntime.getCrossDBTable(replaceFromJoinTableInfo.getEntityItem() == null ? null : replaceFromJoinTableInfo.getEntityItem().entityType.getDBRouteKey(), replaceFromJoinTableInfo.getTable(), this.dbRoute.getRouteKey(), this.isWithCrossDBObjectOrFilter);
                if (StringUtils.isEmpty(tableName)) {
                    throw new KDException(BosErrorCode.tableNotDefined, new Object[]{"the table of the entity '" + this.fullObjName + "' is not exists!"});
                }
                sql.append(tableName).append(' ').append(langAlias);
                QFilter joinFilter = replaceFromJoinTableInfo.getJoinFilters();
                String langFilterSQL = langAlias + '.' + "FLocaleId" + "='" + this.ctx.getORMHint().getLang() + '\'';
                if (joinFilter != null) {
                    langAsMainQP = joinFilter.toQParameter(this.ctx);
                    langFilterSQL = langFilterSQL + " AND (" + langAsMainQP.getSql() + ')';
                }
                sqlWhere = sqlWhere == null ? langFilterSQL : langFilterSQL + " AND (" + sqlWhere + ')';
                this.tableToEntity.put(tableName.toLowerCase(), this.fullObjName.toLowerCase() + "_l");
            }
        } else {
            String tableName = TenantAccountCrossDBRuntime.getCrossDBTable(this.entityType.getDBRouteKey(), this.entityType.getAlias(), this.dbRoute.getRouteKey(), this.isWithCrossDBObjectOrFilter);
            if (StringUtils.isEmpty(tableName)) {
                throw new KDException(BosErrorCode.tableNotDefined, new Object[]{"the table of the entity '" + this.fullObjName + "' is not exists!"});
            }
            this.tableToEntity.put(tableName.toLowerCase(), this.fullObjName.toLowerCase());
            sql.append(tableName).append(' ').append(this.ctx.getSimpleEntityAlias(this.fullObjName)).append(" ");
        }
        ArrayList<JoinTableInfo> joinWithFilters = new ArrayList<JoinTableInfo>();
        List<JoinTableInfo> joinTableList = this.handlerJoinOrderForTemp(this.ctx.getJoinTableList());
        if (!booleanExt.booleanValue() && ORMConfig.REPLACE_EXTEND.getBoolean() && (copyAndSet = this.copyAndSet(joinTableList, replaceTableInfoMap, replaceFromJoinTableInfo, replaceExtend))) {
            this.sortJoinTable(joinTableList);
        }
        for (JoinTableInfo join : joinTableList) {
            Object type;
            JoinTableInfo mainJoin;
            if (replaceTableInfoMap.containsValue(join) || join == replaceFromJoinTableInfo) continue;
            if (!booleanExt.booleanValue() && !ORMConfig.REPLACE_EXTEND.getBoolean() && (mainJoin = replaceTableInfoMap.get(join)) != null) {
                join = join.copy();
                join.setJoinField(mainJoin.getJoinField());
                join.setJoinTableAlias(mainJoin.getJoinTableAlias());
            }
            if ((type = join.getJoinTableType()) != JoinTableTypeEnum.extend && type != JoinTableTypeEnum.multi_lang) {
                QFilter joinFilter = this.allJoinFilterMap.get(join.getEntityItem().getFullObjectName());
                if (joinFilter != null && !joinFilter.isJoinSQLFilter()) {
                    if (joinFilter.isOnMetaJoinPropertyFilter()) {
                        join.setJoinFilter(joinFilter);
                    } else {
                        List<QFilter.QFilterNest> joinFilterNests = joinFilter.getNests(false);
                        if (!joinFilterNests.isEmpty()) {
                            if (!joinFilterNests.get(0).isAnd()) {
                                throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"SingleQuery_0", (String)"the format of the JoinFilter is incorrect\uff0cplease use QFilter.join to create\u3002", (Object[])new Object[]{null}));
                            }
                            QFilter nestFilter = joinFilter.copy();
                            nestFilter.maskCurrent();
                            join.setJoinFilter(nestFilter);
                        }
                    }
                    joinWithFilters.add(join);
                }
            } else if (ORMUtil.useInnerJoin(this.allCtx.getORMHint()) && this.allJoinFilterMap != null && !this.allJoinFilterMap.isEmpty() && this.allCtx.isAllAndQFilter()) {
                for (Map.Entry<String, QFilter> next : this.allJoinFilterMap.entrySet()) {
                    Object tableAlias;
                    String key = next.getKey();
                    if (!key.equalsIgnoreCase((String)(tableAlias = join.getTableAlias() == null ? join.getTableAlias() : join.getTableAlias().toLowerCase(Locale.ENGLISH)))) continue;
                    QFilter value = next.getValue();
                    QFilter newFilter = value.copy();
                    join.setJoinFilter(newFilter);
                    newFilter.maskCurrent();
                }
                joinWithFilters.add(join);
            }
            String tableName = join.getTable().toLowerCase();
            this.tableToEntity.put(tableName, join.getTableAlias().toLowerCase());
            sql.append(join.toJoinSql(this.dbRoute.getRouteKey(), this.isWithCrossDBObjectOrFilter, this.ctx));
        }
        if (joinTableList.size() != this.ctx.getJoinTableList().size()) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"SingleQuery_1", (String)"The on condition must be on the join object\u3002", (Object[])new Object[]{null}));
        }
        ArrayList<Object[]> joinSQLParams = new ArrayList<Object[]>();
        ArrayList<QFilter> joinFilters = new ArrayList<QFilter>();
        for (String objectName : this.myFullObjNameSet) {
            QFilter joinFilter = this.allJoinFilterMap.get(objectName);
            joinFilters.clear();
            if (joinFilter == null || !joinFilter.isJoinSQLFilter()) continue;
            joinFilters.add(joinFilter);
            List<QFilter.QFilterNest> nests = joinFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                if (!nest.getFilter().isJoinSQLFilter()) continue;
                if (!nest.isAnd()) {
                    throw new RuntimeException("Join filter cann't be or: " + joinFilter);
                }
                joinFilters.add(nest.getFilter());
            }
            for (QFilter joinFilterItem : joinFilters) {
                sql.append("\r\n");
                QParameter qp = joinFilterItem.__getSelfDefinedQParameter();
                sql.append(qp.getSql());
                joinSQLParams.add(qp.getParameters());
            }
        }
        if (sqlWhere != null) {
            sql.append("\r\nWHERE ").append(sqlWhere);
        }
        if (sqlGroupBy != null) {
            sql.append((CharSequence)sqlGroupBy);
        }
        if (var12_16 != null) {
            sql.append((String)var12_16);
        }
        if (sqlOrderBy != null) {
            sql.append(sqlOrderBy);
        }
        ret.sql = sql.toString();
        if (whereFilter != null) {
            this.usedFilterAndHavingSet.add(whereFilter);
        }
        if (havingFilter != null) {
            this.usedFilterAndHavingSet.add(havingFilter);
        }
        for (JoinTableInfo join : joinWithFilters) {
            ret.addParams(join.getJoinParameters());
        }
        for (Object[] ps : joinSQLParams) {
            ret.addParams(ps);
        }
        if (whereQP != null) {
            ret.addParams(whereQP.getParameters());
        }
        if (havingQP != null) {
            ret.addParams(havingQP.getParameters());
        }
        if (langAsMainQP != null) {
            ret.addParams(langAsMainQP.getParameters());
        }
        ret.genQueryParameterWhereQFilter = whereFilter;
        if (ret.params != null && ret.params.length > 0) {
            boolean hasRemoveParameter = false;
            for (Object param : ret.params) {
                if (param != HugeInUtil.REMOVED_PARAMETER) continue;
                hasRemoveParameter = true;
                break;
            }
            if (hasRemoveParameter) {
                ArrayList<Object> newParams = new ArrayList<Object>(ret.params.length);
                for (Object param : ret.params) {
                    if (param == HugeInUtil.REMOVED_PARAMETER) continue;
                    newParams.add(param);
                }
                ret.params = newParams.toArray();
            }
        }
        return ret;
    }

    private void sortJoinTable(List<JoinTableInfo> joinTableList) {
        if (SORT_JOINTABLE_BYWORDS) {
            this.sortByWords(joinTableList);
        } else {
            this.sortByOnCondition(joinTableList);
        }
    }

    public Set<String> getTables(boolean withMainEntity, boolean withMainEntityEntry, boolean withExtends, boolean withLang) {
        HashSet<String> tableNameSet = new HashSet<String>(this.ctx.getJoinTableList().size() + 1);
        if (withMainEntity) {
            tableNameSet.add(this.entityType.getAlias().toLowerCase());
        }
        block5: for (JoinTableInfo join : this.ctx.getJoinTableList()) {
            String joinTable = join.getTable().toLowerCase();
            switch (join.getJoinTableType()) {
                case entry: {
                    if (!withMainEntityEntry) continue block5;
                    tableNameSet.add(joinTable);
                    continue block5;
                }
                case extend: {
                    if (!withExtends) continue block5;
                    tableNameSet.add(joinTable);
                    continue block5;
                }
                case multi_lang: {
                    if (!withLang) continue block5;
                    tableNameSet.add(joinTable);
                    continue block5;
                }
            }
            tableNameSet.add(joinTable);
        }
        return tableNameSet;
    }

    public IDataEntityType getDataEntityType() {
        return this.entityType;
    }

    public String[] getSelectFieldAlias() {
        String[] alias = new String[this.selectFields.length];
        for (int i = 0; i < alias.length; ++i) {
            alias[i] = this.selectFields[i].getAlias();
        }
        return alias;
    }

    public PropertyField[] getSelectFields() {
        return this.selectFields;
    }

    public String getFullObjName() {
        return this.fullObjName;
    }

    public String getParentFK() {
        return this.parentFK;
    }

    public String toString() {
        return this.fullObjName;
    }

    public DBRoute getDBRoute() {
        return this.dbRoute;
    }

    public void setDBRoute(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    public Set<DBConfig> getDBConfigSet() {
        return this.dbConfigSet;
    }

    public void setDBConfigSet(Set<DBConfig> dbConfigSet) {
        this.dbConfigSet = dbConfigSet;
    }

    Set<QFilter> usedFilterAndHaving() {
        return this.usedFilterAndHavingSet;
    }

    public SingleQuery optMerge(SingleQuery subBDQuery) {
        if (subBDQuery.isExistsSubquery()) {
            return this;
        }
        ArrayList<PropertyField> mergedFields = new ArrayList<PropertyField>(this.selectFields.length + subBDQuery.selectFields.length);
        EntityItem ei = this.allCtx.getEntityItem(subBDQuery.getFullObjName());
        HashSet<String> excludePKFieldSet = new HashSet<String>(4);
        String fkName = ei.joinProperty.getParentJoinPropertyType().getName().toLowerCase(Locale.ENGLISH);
        for (PropertyField field : this.selectFields) {
            if (field.isInnerField() && field.getName().toLowerCase(Locale.ENGLISH).equals(fkName) && !this.orderByItemClassProp(field)) {
                excludePKFieldSet.add(field.getEntityAlias() + '.' + field.getField());
                continue;
            }
            mergedFields.add(field);
        }
        String pkName = ei.joinProperty.getSubJoinPropertyType().getName().toLowerCase(Locale.ENGLISH);
        for (PropertyField field : subBDQuery.selectFields) {
            if (field.isInnerField() && field.getName().toLowerCase(Locale.ENGLISH).equals(pkName)) {
                String nameWithoutRoot = subBDQuery.getFullObjName();
                nameWithoutRoot = nameWithoutRoot.substring(nameWithoutRoot.indexOf(46) + 1);
                String linkParentPKAlias = "INNER_" + nameWithoutRoot;
                if (field.getAlias().equals(linkParentPKAlias)) continue;
                boolean ignoreSameAliasCol = false;
                for (PropertyField mf : mergedFields) {
                    if (!mf.isInnerField() || !field.getAlias().equals(mf.getAlias())) continue;
                    ignoreSameAliasCol = true;
                    break;
                }
                if (ignoreSameAliasCol) continue;
                mergedFields.add(field);
                continue;
            }
            if (!this.returnMultiKTypeInnerField(field, subBDQuery) || excludePKFieldSet.contains(field.getEntityAlias() + '.' + field.getField()) && this.needRemoveMultilBaseDatePkId(subBDQuery, field, pkName)) continue;
            mergedFields.add(field);
        }
        PropertyField[] selectFields = mergedFields.toArray(new PropertyField[mergedFields.size()]);
        ArrayList<PropertyField> performJoinFieldList = new ArrayList<PropertyField>();
        if (this.performJoinFieldList != null) {
            performJoinFieldList.addAll(this.performJoinFieldList);
        }
        if (subBDQuery.performJoinFieldList != null) {
            performJoinFieldList.addAll(subBDQuery.performJoinFieldList);
        }
        List<QueryTreeNode> subQueryNodesBak = this.subQueryNodes;
        SingleQuery newQuery = new SingleQuery(this.dbRoute, this.parentFK, this.entityType, this.fullObjName, selectFields, performJoinFieldList, this.allJoinFilterMap, this.allFilterMap, this.allOrderByList, this.allGroupByList, this.allHavingFilterMap, this.top, this.start, this.limit, this.allCtx, this.withUserOriginFilter || subBDQuery.withUserOriginFilter, this.orderByOnSQL || subBDQuery.orderByOnSQL);
        newQuery.shouldSelectPk = this.shouldSelectPk;
        this.inheriteQueryRuntimeInfo(newQuery, subBDQuery);
        this.inheriteQueryRuntimeInfo(newQuery, this);
        newQuery.subQueryNodes = subQueryNodesBak;
        return newQuery;
    }

    private boolean needRemoveMultilBaseDatePkId(SingleQuery subBDQuery, PropertyField field, String pkName) {
        if (this.shouldSelectPk) {
            return false;
        }
        boolean flag = true;
        PropertyField[] userSelectFields = this.allCtx.getUserSelectFields();
        for (PropertyField sameObjectField : subBDQuery.selectFields) {
            if (sameObjectField == field || sameObjectField.getEntityAlias() == null || !sameObjectField.getEntityAlias().startsWith(field.getEntityAlias() + '.') || sameObjectField.isInnerField() && sameObjectField.getName().equalsIgnoreCase(pkName)) continue;
            return false;
        }
        for (PropertyField userSelectField : userSelectFields) {
            String multilBaseDatePkFieldName;
            String onlyName = userSelectField.getEntityAlias() + '.' + userSelectField.getField();
            if (!onlyName.equals(multilBaseDatePkFieldName = field.getEntityAlias() + '.' + field.getField())) continue;
            return false;
        }
        return flag;
    }

    public SingleQuery optMergeFields(List<PropertyField> added, List<PropertyField> removedInner) {
        ArrayList<PropertyField> append = new ArrayList<PropertyField>();
        for (PropertyField addField : added) {
            boolean exists = false;
            for (PropertyField field : this.selectFields) {
                if (!field.isInnerField() || !field.isSameWith(addField)) continue;
                field.setAlias(addField.getAlias());
                exists = true;
                break;
            }
            if (exists) continue;
            append.add(addField);
        }
        int len = this.selectFields.length;
        int appendLen = append.size();
        PropertyField[] selectFields = new PropertyField[len + appendLen];
        System.arraycopy(this.selectFields, 0, selectFields, 0, len);
        for (int i = 0; i < appendLen; ++i) {
            selectFields[len + i] = (PropertyField)append.get(i);
        }
        if (removedInner.size() > 0) {
            HashSet<String> nameSet = new HashSet<String>(removedInner.size());
            for (PropertyField rm : removedInner) {
                nameSet.add(rm.getName());
            }
            ArrayList<PropertyField> selectFieldList = new ArrayList<PropertyField>(selectFields.length);
            for (PropertyField field : selectFields) {
                if (field.isInnerField() && nameSet.contains(field.getName().toLowerCase())) continue;
                selectFieldList.add(field);
            }
            if (selectFieldList.size() != selectFields.length) {
                selectFields = selectFieldList.toArray(new PropertyField[selectFieldList.size()]);
            }
        }
        List<QueryTreeNode> subQueryNodesBak = this.subQueryNodes;
        SingleQuery newQuery = new SingleQuery(this.dbRoute, this.parentFK, this.entityType, this.fullObjName, selectFields, this.performJoinFieldList, this.allJoinFilterMap, this.allFilterMap, this.allOrderByList, this.allGroupByList, this.allHavingFilterMap, this.top, this.start, this.limit, this.allCtx, this.withUserOriginFilter, this.orderByOnSQL);
        newQuery.shouldSelectPk = this.shouldSelectPk;
        this.inheriteQueryRuntimeInfo(newQuery, this);
        newQuery.subQueryNodes = subQueryNodesBak;
        return newQuery;
    }

    public SingleQuery optResetFilter(QFilter filter) {
        List<QueryTreeNode> subQueryNodesBak = this.subQueryNodes;
        this.allFilterMap.put(this.fullObjName, filter);
        SingleQuery newQuery = new SingleQuery(this.dbRoute, this.parentFK, this.entityType, this.fullObjName, this.selectFields, this.performJoinFieldList, this.allJoinFilterMap, this.allFilterMap, this.allOrderByList, this.allGroupByList, this.allHavingFilterMap, this.top, this.start, this.limit, this.allCtx, this.withUserOriginFilter, this.orderByOnSQL);
        newQuery.shouldSelectPk = this.shouldSelectPk;
        this.inheriteQueryRuntimeInfo(newQuery, this);
        newQuery.subQueryNodes = subQueryNodesBak;
        return newQuery;
    }

    public SingleQuery optRebuild() {
        List<QueryTreeNode> subQueryNodesBak = this.subQueryNodes;
        SingleQuery newQuery = new SingleQuery(this.dbRoute, this.parentFK, this.entityType, this.fullObjName, this.selectFields, this.performJoinFieldList, this.allJoinFilterMap, this.allFilterMap, this.allOrderByList, this.allGroupByList, this.allHavingFilterMap, this.top, this.start, this.limit, this.allCtx, this.withUserOriginFilter, this.orderByOnSQL);
        newQuery.shouldSelectPk = this.shouldSelectPk;
        this.inheriteQueryRuntimeInfo(newQuery, this);
        newQuery.subQueryNodes = subQueryNodesBak;
        return newQuery;
    }

    public SingleQuery optRebuildForCount(String countSelectField) {
        return this.optRebuildFields(countSelectField);
    }

    public SingleQuery optRebuildFields(String selectFields) {
        List<PropertyField> list = SelectFields.parseFrom(selectFields).createPropertyFields(this.entityType.getName());
        PropertyField[] selectFieldsForCount = list.toArray(new PropertyField[list.size()]);
        return this.optRebuildFields(selectFieldsForCount);
    }

    public SingleQuery optRebuildFields(String selectFields, QFilter filter) {
        List<QueryTreeNode> subQueryNodesBak = this.subQueryNodes;
        this.allFilterMap.put(this.fullObjName, filter);
        List<PropertyField> list = SelectFields.parseFrom(selectFields).createPropertyFields(this.entityType.getName());
        PropertyField[] selectFieldsForCount = list.toArray(new PropertyField[list.size()]);
        SingleQuery newQuery = new SingleQuery(this.dbRoute, this.parentFK, this.entityType, this.fullObjName, selectFieldsForCount, this.performJoinFieldList, this.allJoinFilterMap, this.allFilterMap, this.allOrderByList, this.allGroupByList, this.allHavingFilterMap, this.top, this.start, this.limit, this.allCtx, this.withUserOriginFilter, this.orderByOnSQL);
        this.inheriteQueryRuntimeInfo(newQuery, this);
        newQuery.subQueryNodes = subQueryNodesBak;
        return newQuery;
    }

    public SingleQuery optRebuildFields(PropertyField[] selectFields) {
        List<QueryTreeNode> subQueryNodesBak = this.subQueryNodes;
        SingleQuery newQuery = new SingleQuery(this.dbRoute, this.parentFK, this.entityType, this.fullObjName, selectFields, this.performJoinFieldList, this.allJoinFilterMap, this.allFilterMap, this.allOrderByList, this.allGroupByList, this.allHavingFilterMap, this.top, this.start, this.limit, this.allCtx, this.withUserOriginFilter, this.orderByOnSQL);
        this.inheriteQueryRuntimeInfo(newQuery, this);
        newQuery.subQueryNodes = subQueryNodesBak;
        return newQuery;
    }

    private void inheriteQueryRuntimeInfo(SingleQuery query, SingleQuery inheriteFrom) {
        query.usedFilterAndHavingSet.addAll(inheriteFrom.usedFilterAndHavingSet);
        query.curFilterObjSet.addAll(inheriteFrom.curFilterObjSet);
        query.withUserOriginFilter = query.withUserOriginFilter || inheriteFrom.withUserOriginFilter;
        query.isForceInnerJoin = query.isForceInnerJoin || inheriteFrom.isForceInnerJoin;
        boolean bl = query.orderByOnSQL = query.orderByOnSQL || inheriteFrom.orderByOnSQL;
        if (query.dbConfigSet == null) {
            query.dbConfigSet = new HashSet<DBConfig>();
        } else {
            query.dbConfigSet.clear();
        }
        if (inheriteFrom.dbConfigSet != null) {
            query.dbConfigSet.addAll(inheriteFrom.dbConfigSet);
        }
    }

    public String getSql() {
        return this.queryParameter.sql;
    }

    public Object[] getParams() {
        return this.queryParameter.params;
    }

    public QFilter getGenQueryParameterWhereQFilter() {
        return this.queryParameter.genQueryParameterWhereQFilter;
    }

    private List<JoinTableInfo> handlerJoinOrderForTemp(List<JoinTableInfo> joinTableList) {
        ArrayList<JoinTableInfo> newList = new ArrayList<JoinTableInfo>();
        ArrayList<JoinTableInfo> tempList = new ArrayList<JoinTableInfo>();
        if (!CollectionUtils.isEmpty(joinTableList)) {
            for (JoinTableInfo joinTableInfo : joinTableList) {
                if (joinTableInfo.getTable().startsWith("TMP_")) {
                    tempList.add(joinTableInfo);
                    continue;
                }
                newList.add(joinTableInfo);
            }
            if (!CollectionUtils.isEmpty(tempList)) {
                newList.addAll(tempList);
            }
        }
        return newList;
    }

    public boolean isExistsSubquery() {
        return this.existsSubquery;
    }

    public void setExistsSubquery(boolean existsSubquery) {
        this.existsSubquery = existsSubquery;
    }

    public SingleQuery getSubQuey() {
        return this.subQuey;
    }

    public Map<String, String> getTableToEntity() {
        return this.tableToEntity;
    }

    public List<QueryTreeNode> getSubQueryNodes() {
        return this.subQueryNodes;
    }

    public List<QueryTreeNode> clearSubQueryNodes() {
        this.subQueryNodes = new ArrayList<QueryTreeNode>();
        return this.subQueryNodes;
    }

    public void addSubQueryNode(QueryTreeNode subQueryNode) {
        this.subQueryNodes.add(subQueryNode);
    }

    public void addSubQueryNodes(List<QueryTreeNode> subQueryNodes) {
        this.subQueryNodes.addAll(subQueryNodes);
    }

    public Map<String, QFilter> getAllJoinFilterMap() {
        return this.allJoinFilterMap;
    }

    private boolean containsExists(QFilter filter) {
        return QueryUtils.containsExists(filter);
    }

    public QFilter getExistsQFilter() {
        return this.existsQFilter;
    }

    public void setExistsQFilter(QFilter existsQFilter) {
        this.existsQFilter = existsQFilter;
    }

    private String getTableAlias(String tableAlias, EntityItem joinEntityItem) {
        EntityItemJoinProperty joinProperty;
        if (joinEntityItem == null) {
            return tableAlias;
        }
        String joinAlias = joinEntityItem.getFullObjectName();
        if (joinAlias == null) {
            return tableAlias;
        }
        int index = joinAlias.indexOf(".");
        String rootName = joinAlias.toUpperCase(Locale.ENGLISH);
        if (index != -1) {
            rootName = joinAlias.substring(0, index).toUpperCase(Locale.ENGLISH);
        }
        if ((joinProperty = joinEntityItem.joinProperty) == null) {
            return tableAlias;
        }
        EntityItem parentEI = joinProperty.getParentEntityItem();
        if (parentEI == null) {
            return tableAlias;
        }
        String parentAlias = parentEI.getFullObjectName();
        if (joinAlias == null) {
            return tableAlias;
        }
        int index1 = parentAlias.indexOf(".");
        String rootName1 = parentAlias.toUpperCase(Locale.ENGLISH);
        if (index1 != -1) {
            rootName1 = parentAlias.substring(0, index1).toUpperCase(Locale.ENGLISH);
        }
        if (!rootName.equals(rootName1)) {
            return parentAlias + "." + joinAlias;
        }
        return tableAlias;
    }

    private void sortByWords(List<JoinTableInfo> joinTableList) {
        joinTableList.sort(new Comparator<JoinTableInfo>(){

            @Override
            public int compare(JoinTableInfo o1, JoinTableInfo o2) {
                int level2;
                String a1 = o1.getTableAlias().toUpperCase(Locale.ENGLISH);
                String a2 = o2.getTableAlias().toUpperCase(Locale.ENGLISH);
                if (a1.startsWith("TEMP_") || a2.startsWith("TEMP_")) {
                    return o1.getJoinTableAlias().compareTo(o2.getJoinTableAlias());
                }
                a1 = SingleQuery.this.getTableAlias(a1, o1.getEntityItem());
                a2 = SingleQuery.this.getTableAlias(a2, o2.getEntityItem());
                int level1 = a1.length() - a1.replaceAll("\\.", "").length();
                int dt = level1 - (level2 = a2.length() - a2.replaceAll("\\.", "").length());
                if (dt == 0) {
                    dt = a1.compareTo(a2);
                }
                return dt;
            }
        });
    }

    private void sortByOnCondition(List<JoinTableInfo> joinTableList) {
        if (joinTableList.size() <= 1) {
            return;
        }
        LinkedList<JoinTableInfo> newJoinTableLIst = new LinkedList<JoinTableInfo>();
        HashMap<String, JoinTableInfo> currentTable = new HashMap<String, JoinTableInfo>(joinTableList.size());
        HashMap<String, JoinTableInfo> currentTableCopy = new HashMap<String, JoinTableInfo>(joinTableList.size());
        for (JoinTableInfo next : joinTableList) {
            currentTable.put(next.getTableAlias(), next);
            currentTableCopy.put(next.getTableAlias(), next);
        }
        JoinTableInfo initTable = joinTableList.get(0);
        int addPosition = 0;
        while (true) {
            newJoinTableLIst.add(addPosition, initTable);
            if (initTable != null) {
                currentTable.remove(initTable.getTableAlias());
                String joinKey = initTable.getJoinTableAlias();
                initTable = (JoinTableInfo)currentTable.get(joinKey);
            }
            if (initTable == null) {
                Iterator iterator1 = currentTable.entrySet().iterator();
                if (!iterator1.hasNext()) break;
                Map.Entry next = iterator1.next();
                initTable = (JoinTableInfo)next.getValue();
                addPosition = this.getPosition(initTable, currentTableCopy, newJoinTableLIst);
                continue;
            }
            addPosition = this.getPosition(initTable, currentTableCopy, newJoinTableLIst);
            if (currentTable.isEmpty()) break;
        }
        joinTableList.clear();
        joinTableList.addAll(newJoinTableLIst);
    }

    private int getPosition(JoinTableInfo initTable, Map<String, JoinTableInfo> currentTableCopy, LinkedList<JoinTableInfo> newJoinTableLIst) {
        if (initTable == null) {
            return 0;
        }
        String joinTableAlias = initTable.getJoinTableAlias();
        JoinTableInfo joinTableInfo = currentTableCopy.get(joinTableAlias);
        if (joinTableInfo == null) {
            return 0;
        }
        int addPosition = newJoinTableLIst.indexOf(joinTableInfo);
        for (JoinTableInfo joinInfo : currentTableCopy.values()) {
            String fieldFullObjectName = joinInfo.getEntityItem().getFullObjectName();
            if (!fieldFullObjectName.equals(joinTableAlias) || newJoinTableLIst.indexOf(joinInfo) < 0) continue;
            addPosition = Math.max(addPosition, newJoinTableLIst.indexOf(joinInfo));
        }
        if (addPosition < 0) {
            return this.getPosition(joinTableInfo, currentTableCopy, newJoinTableLIst);
        }
        return ++addPosition;
    }

    public int getTop() {
        return this.top;
    }

    public void removeInnerField(boolean finallySingleQuery, boolean removeInnerField) {
        if (finallySingleQuery && removeInnerField) {
            ArrayList<PropertyField> pfs = new ArrayList<PropertyField>(this.selectFields.length);
            for (PropertyField pf : this.selectFields) {
                if (pf.isInnerField()) continue;
                pfs.add(pf);
            }
            if (pfs.size() < this.selectFields.length) {
                this.selectFields = pfs.toArray(new PropertyField[pfs.size()]);
                this.shouldRebuildSQL = true;
            }
        }
    }

    public void removeSpecificInnerField(String fieldAlias) {
        ArrayList<PropertyField> pfs = new ArrayList<PropertyField>();
        for (PropertyField pf : this.selectFields) {
            if (pf.getAlias().equals(fieldAlias) && pf.isInnerField() && !this.orderByItemClassProp(pf)) continue;
            pfs.add(pf);
        }
        if (pfs.size() < this.selectFields.length) {
            this.selectFields = pfs.toArray(new PropertyField[0]);
            this.shouldRebuildSQL = true;
        }
    }

    public void rebuildSelectFields(List<String> fields) {
        ArrayList<PropertyField> pfs = new ArrayList<PropertyField>(this.selectFields.length);
        for (PropertyField pf : this.selectFields) {
            if (!fields.contains(pf.getFullName())) continue;
            pfs.add(pf);
        }
        if (pfs.size() < this.selectFields.length) {
            this.selectFields = pfs.toArray(new PropertyField[0]);
            this.shouldRebuildSQL = true;
        }
    }

    private boolean copyAndSet(List<JoinTableInfo> joinTableList, Map<JoinTableInfo, JoinTableInfo> replaceTableInfoMap, JoinTableInfo replaceFromJoinTableInfo, boolean replaceExtend) {
        if (replaceTableInfoMap == null || joinTableList == null || joinTableList.size() == 0) {
            return false;
        }
        ArrayList<JoinTableInfo> newJoinTableList = new ArrayList<JoinTableInfo>();
        boolean replace = false;
        for (Map.Entry<JoinTableInfo, JoinTableInfo> repalceTableInfo : replaceTableInfoMap.entrySet()) {
            JoinTableInfo repalceTable = repalceTableInfo.getKey();
            JoinTableInfo mainTable = repalceTableInfo.getValue();
            Iterator<JoinTableInfo> joinTableInfoIterator = joinTableList.iterator();
            while (joinTableInfoIterator.hasNext()) {
                JoinTableInfo joinTableInfo = joinTableInfoIterator.next();
                EntityItem entityItem = joinTableInfo.getEntityItem();
                if (mainTable == joinTableInfo || joinTableInfo == replaceFromJoinTableInfo || repalceTable.getEntityItem() != entityItem && !repalceTable.getEntityItem().getFullObjectName().equalsIgnoreCase(entityItem.getFullObjectName())) continue;
                if ((joinTableInfo = joinTableInfo.copy()).getJoinTableType() == JoinTableTypeEnum.multi_lang && replaceExtend) {
                    joinTableInfo.setJoinTableAlias(repalceTable.getTableAlias());
                } else {
                    joinTableInfo.setJoinTableAlias(mainTable.getJoinTableAlias());
                }
                joinTableInfo.setJoinField(mainTable.getJoinField());
                replace = true;
                newJoinTableList.add(joinTableInfo);
                joinTableInfoIterator.remove();
            }
        }
        if (replace) {
            if (joinTableList != null && joinTableList.size() > 0) {
                newJoinTableList.addAll(joinTableList);
            }
            joinTableList.clear();
            joinTableList.addAll(newJoinTableList);
        }
        return replace;
    }

    public QFilter getMultiTypeQFilter() {
        return this.multiTypeQFilter;
    }

    public void setAllJoinFilterMap(Map<String, QFilter> allJoinFilterMap) {
        this.allJoinFilterMap = allJoinFilterMap;
    }

    public boolean isHasDistinct() {
        return this.hasDistinct;
    }

    private Map<JoinTableInfo, JoinTableInfo> replaceJoinFieldForExtend(List<JoinTableInfo> withOutReplaceJoinTableInfo, Map<JoinTableInfo, List<JoinTableInfo>> extendJoinMap) {
        if (extendJoinMap == null || extendJoinMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<JoinTableInfo, JoinTableInfo> returnMap = new HashMap<JoinTableInfo, JoinTableInfo>(8);
        Iterator<Map.Entry<JoinTableInfo, List<JoinTableInfo>>> iterator = extendJoinMap.entrySet().iterator();
        Map<String, String> replaceEntityAliasMap = this.ctx.getReplaceEntityAliasMap();
        while (iterator.hasNext()) {
            JoinTableInfo extendTableInfo;
            int i;
            Map.Entry<JoinTableInfo, List<JoinTableInfo>> next = iterator.next();
            JoinTableInfo maintableInfo = next.getKey();
            List<JoinTableInfo> extendTables = next.getValue();
            JoinTableInfo firstJoinTable = null;
            JoinTableInfo firstJoinTableBak = null;
            if (extendTables.size() == 1 && ORMConfiguration.isEntryEntityType(maintableInfo.getEntityItem().entityType) && extendTables.get(0).getJoinTableType() == JoinTableTypeEnum.multi_lang) {
                iterator.remove();
                continue;
            }
            if (extendTables.size() == 1) {
                firstJoinTableBak = extendTables.get(0);
                firstJoinTable = firstJoinTableBak.copy();
            } else {
                for (i = 0; i < extendTables.size(); ++i) {
                    extendTableInfo = extendTables.get(i);
                    if (extendTableInfo.getJoinTableType() == JoinTableTypeEnum.multi_lang) continue;
                    firstJoinTableBak = extendTables.get(i);
                    firstJoinTable = firstJoinTableBak.copy();
                    break;
                }
            }
            for (i = 0; i < extendTables.size(); ++i) {
                extendTableInfo = extendTables.get(i);
                EntityItem entityItem = extendTableInfo.getEntityItem();
                if (extendTableInfo == firstJoinTableBak) {
                    String replaceJoinTableAlias = replaceEntityAliasMap.get(maintableInfo.getJoinTableAlias());
                    if (replaceJoinTableAlias == null) {
                        replaceJoinTableAlias = maintableInfo.getJoinTableAlias();
                    }
                    if (ORMConfiguration.isEntryEntityType(entityItem.entityType)) {
                        String alias = entityItem.getParentEntityItem().entityType.getPrimaryKey().getAlias();
                        extendTableInfo.setJoinTableAlias(replaceJoinTableAlias);
                        extendTableInfo.setField(alias);
                        extendTableInfo.setJoinField(alias);
                    } else if (entityItem.getParentEntityItem() != null) {
                        extendTableInfo.setJoinField(maintableInfo.getJoinField());
                        extendTableInfo.setJoinTableAlias(replaceJoinTableAlias);
                    } else {
                        extendTableInfo.setJoinTableAlias(replaceJoinTableAlias);
                        if (maintableInfo.getJoinField() != null) {
                            extendTableInfo.setJoinField(maintableInfo.getJoinField());
                        }
                    }
                } else {
                    extendTableInfo.setJoinTableAlias(firstJoinTable.getTableAlias());
                }
                returnMap.put(extendTableInfo, maintableInfo);
            }
        }
        if (replaceEntityAliasMap != null && replaceEntityAliasMap.size() > 0 && !withOutReplaceJoinTableInfo.isEmpty()) {
            for (JoinTableInfo joinTableInfo : withOutReplaceJoinTableInfo) {
                String joinTableAlias = joinTableInfo.getJoinTableAlias();
                if (!replaceEntityAliasMap.containsKey(joinTableAlias)) continue;
                joinTableInfo.setJoinTableAlias(replaceEntityAliasMap.get(joinTableAlias));
            }
        }
        return returnMap;
    }

    private ExtendReplaceMain tryReplaceMainByExtend(QFilter whereFilter, QFilter havingFilter) {
        if (this.hasJoinSQLFilter(whereFilter) || this.hasJoinSQLFilter(this.getJoinOnFilter()) || this.hasJoinSQLFilter(havingFilter)) {
            return empty_ExtendReplaceMain;
        }
        this.tryReplaceMainByLang_prePerformJoin(whereFilter, havingFilter);
        HashMap<SingleQueryTableInfo, ArrayList<Object>> mainExtendTableInfoMap = new HashMap<SingleQueryTableInfo, ArrayList<Object>>();
        HashMap<String, SingleQueryTableInfo> allTableInfoMap = new HashMap<String, SingleQueryTableInfo>(4);
        allTableInfoMap.put(this.fullObjName, SingleQueryTableInfo.createSingleQueryTableInfoByFromTable(this.entityType, this.fullObjName));
        for (JoinTableInfo joinTableInfo : this.ctx.getJoinTableList()) {
            allTableInfoMap.put(joinTableInfo.getTableAlias(), SingleQueryTableInfo.createSingleQueryTableInfoByJoinTable(joinTableInfo));
        }
        final ArrayList<JoinTableInfo> withOutReplaceJoinTableInfo = new ArrayList<JoinTableInfo>(2);
        for (JoinTableInfo extendJoinTable : this.ctx.getJoinTableList()) {
            if (extendJoinTable.getJoinTableType() == JoinTableTypeEnum.extend || extendJoinTable.getJoinTableType() == JoinTableTypeEnum.multi_lang) {
                int n;
                List<Object> singleQueryTableInfos;
                Object extendTable;
                SingleQueryTableInfo mainTableInfo;
                boolean findMain = false;
                for (JoinTableInfo joinTableInfo : this.ctx.getJoinTableList()) {
                    JoinTableTypeEnum joinTableType = joinTableInfo.getJoinTableType();
                    if (joinTableType == JoinTableTypeEnum.extend || joinTableType == JoinTableTypeEnum.multi_lang || !joinTableInfo.getTableAlias().equalsIgnoreCase(extendJoinTable.getEntityItem().getFullObjectName())) continue;
                    mainTableInfo = (SingleQueryTableInfo)allTableInfoMap.get(joinTableInfo.getTableAlias());
                    extendTable = (SingleQueryTableInfo)allTableInfoMap.get(extendJoinTable.getTableAlias());
                    singleQueryTableInfos = (List)mainExtendTableInfoMap.get(mainTableInfo);
                    if (singleQueryTableInfos == null) {
                        singleQueryTableInfos = new ArrayList(2);
                        mainExtendTableInfoMap.put(mainTableInfo, (ArrayList<Object>)singleQueryTableInfos);
                    }
                    singleQueryTableInfos.add(extendTable);
                    findMain = true;
                    break;
                }
                if (findMain) continue;
                String extendTableAlias = extendJoinTable.getTableAlias();
                String mainTableAlias = extendTableAlias.substring(0, n = extendTableAlias.lastIndexOf("_"));
                mainTableInfo = (SingleQueryTableInfo)allTableInfoMap.get(mainTableAlias);
                if (mainTableInfo == null) {
                    mainTableInfo = SingleQueryTableInfo.createSingleQueryTableInfoByFromTable(this.allCtx.getEntityItem((String)mainTableAlias).entityType, mainTableAlias);
                }
                extendTable = (SingleQueryTableInfo)allTableInfoMap.get(extendJoinTable.getTableAlias());
                singleQueryTableInfos = (ArrayList<Object>)mainExtendTableInfoMap.get(mainTableInfo);
                if (singleQueryTableInfos == null) {
                    singleQueryTableInfos = new ArrayList<Object>(2);
                    mainExtendTableInfoMap.put(mainTableInfo, (ArrayList<Object>)singleQueryTableInfos);
                }
                singleQueryTableInfos.add(extendTable);
                continue;
            }
            withOutReplaceJoinTableInfo.add(extendJoinTable);
        }
        HashMap<SingleQueryTableInfo, ArrayList<JoinTableInfo>> hashMap = new HashMap<SingleQueryTableInfo, ArrayList<JoinTableInfo>>();
        if (!mainExtendTableInfoMap.isEmpty()) {
            HashMap<String, String> replaceAliasMap = new HashMap<String, String>();
            for (Map.Entry entry : mainExtendTableInfoMap.entrySet()) {
                SingleQueryTableInfo singleQueryTableInfo = (SingleQueryTableInfo)entry.getKey();
                List extendJoins = (List)entry.getValue();
                boolean canIgnoreJoin = true;
                for (SingleQueryTableInfo extendJoin : extendJoins) {
                    if (canIgnoreJoin = this.canIgnore(canIgnoreJoin, singleQueryTableInfo, extendJoin, whereFilter, havingFilter)) {
                        for (SingleQueryTableInfo join : allTableInfoMap.values()) {
                            if (join.isFromTable() || join == singleQueryTableInfo || join == extendJoin || !join.joinTable.getJoinTableAlias().equalsIgnoreCase(singleQueryTableInfo.getTableAlias())) continue;
                            String pkField = singleQueryTableInfo.entityType.getPrimaryKey().getAlias();
                            if (join.joinTable.getJoinField().equalsIgnoreCase(pkField)) continue;
                            canIgnoreJoin = false;
                            break;
                        }
                    }
                    if (canIgnoreJoin) {
                        ArrayList<JoinTableInfo> joinTableInfos = (ArrayList<JoinTableInfo>)hashMap.get(singleQueryTableInfo);
                        if (joinTableInfos == null) {
                            joinTableInfos = new ArrayList<JoinTableInfo>(2);
                            hashMap.put(singleQueryTableInfo, joinTableInfos);
                        }
                        joinTableInfos.add(extendJoin.joinTable);
                        continue;
                    }
                    withOutReplaceJoinTableInfo.add(extendJoin.joinTable);
                }
            }
            final HashMap replaceMainJoinTableInfoMap = new HashMap();
            JoinTableInfo replaceFromJoinTableInfo = null;
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                SingleQueryTableInfo mainTableInfo = (SingleQueryTableInfo)next.getKey();
                List extendTablesList = (List)next.getValue();
                if (mainTableInfo.joinTable != null && extendTablesList.size() == 1 && ORMConfiguration.isEntryEntityType(mainTableInfo.joinTable.getEntityItem().entityType) && ((JoinTableInfo)extendTablesList.get(0)).getJoinTableType() == JoinTableTypeEnum.multi_lang) {
                    iterator.remove();
                    continue;
                }
                for (JoinTableInfo temp : extendTablesList) {
                    List<JoinTableInfo> joinTableInfos;
                    SingleQueryTableInfo mainTable;
                    if (replaceFromJoinTableInfo == null) {
                        if (mainTableInfo.isFromTable()) {
                            boolean contiansIsNull;
                            if (temp.getJoinTableType() != JoinTableTypeEnum.multi_lang) {
                                replaceFromJoinTableInfo = temp;
                                replaceAliasMap.put(mainTableInfo.getTableAlias(), temp.getTableAlias());
                                continue;
                            }
                            if (temp.getJoinTableType() != JoinTableTypeEnum.multi_lang || (contiansIsNull = this.containsIsNullContidion(this.getWhereFilter())) && (!contiansIsNull || extendTablesList.size() <= 1)) continue;
                            replaceFromJoinTableInfo = temp;
                            replaceAliasMap.put(mainTableInfo.getTableAlias(), temp.getTableAlias());
                            continue;
                        }
                        String fullObjectName = mainTableInfo.joinTable.getEntityItem().getFullObjectName();
                        mainTable = (SingleQueryTableInfo)allTableInfoMap.get(fullObjectName);
                        if (!replaceAliasMap.containsKey(mainTableInfo.joinTable.getTableAlias()) && (temp.getJoinTableType() == JoinTableTypeEnum.multi_lang && !ORMConfiguration.isEntryEntityType(temp.getEntityItem().entityType) || temp.getJoinTableType() == JoinTableTypeEnum.extend)) {
                            replaceAliasMap.put(mainTableInfo.joinTable.getTableAlias(), temp.getTableAlias());
                        }
                        if ((joinTableInfos = (ArrayList<JoinTableInfo>)replaceMainJoinTableInfoMap.get(mainTable.joinTable)) == null) {
                            joinTableInfos = new ArrayList<JoinTableInfo>(2);
                            replaceMainJoinTableInfoMap.put(mainTable.joinTable, joinTableInfos);
                        }
                        joinTableInfos.add(temp);
                        continue;
                    }
                    if (mainTableInfo.joinTable != null && mainTableInfo.joinTable.getEntityItem() != null && mainTableInfo.joinTable.getEntityItem().getParentEntityItem() != null) {
                        String fullObjectName = mainTableInfo.joinTable.getEntityItem().getFullObjectName();
                        mainTable = (SingleQueryTableInfo)allTableInfoMap.get(fullObjectName);
                        if (!replaceAliasMap.containsKey(mainTableInfo.joinTable.getTableAlias()) && (temp.getJoinTableType() == JoinTableTypeEnum.multi_lang && !ORMConfiguration.isEntryEntityType(temp.getEntityItem().entityType) || temp.getJoinTableType() == JoinTableTypeEnum.extend)) {
                            replaceAliasMap.put(mainTableInfo.joinTable.getTableAlias(), temp.getTableAlias());
                        }
                        if ((joinTableInfos = (List)replaceMainJoinTableInfoMap.get(mainTable.joinTable)) == null) {
                            joinTableInfos = new ArrayList(2);
                            replaceMainJoinTableInfoMap.put(mainTable.joinTable, joinTableInfos);
                        }
                        joinTableInfos.add(temp);
                        continue;
                    }
                    ArrayList<JoinTableInfo> joinTableInfos2 = (ArrayList<JoinTableInfo>)replaceMainJoinTableInfoMap.get(replaceFromJoinTableInfo);
                    JoinTableTypeEnum joinTableType = replaceFromJoinTableInfo.getJoinTableType();
                    if (joinTableInfos2 == null) {
                        joinTableInfos2 = new ArrayList<JoinTableInfo>(2);
                    }
                    joinTableInfos2.add(temp);
                    if (joinTableType != JoinTableTypeEnum.multi_lang && joinTableType != JoinTableTypeEnum.extend) {
                        replaceMainJoinTableInfoMap.put(replaceFromJoinTableInfo, joinTableInfos2);
                        continue;
                    }
                    String tableAlias = replaceFromJoinTableInfo.getTableAlias();
                    int index = tableAlias.lastIndexOf("_");
                    SingleQueryTableInfo singleQueryTableInfo = (SingleQueryTableInfo)allTableInfoMap.get(tableAlias = tableAlias.substring(0, index));
                    if (singleQueryTableInfo == null || singleQueryTableInfo.joinTable == null) continue;
                    replaceMainJoinTableInfoMap.put(singleQueryTableInfo.joinTable, joinTableInfos2);
                }
            }
            this.ctx.setReplaceEntityAliasMap(replaceAliasMap);
            final JoinTableInfo aReplaceFromJoinTableInfo = replaceFromJoinTableInfo;
            return new ExtendReplaceMain(){

                @Override
                public void close() {
                    SingleQuery.this.ctx.setReplaceEntityAliasMap(null);
                }

                @Override
                public Map<JoinTableInfo, List<JoinTableInfo>> replaceMainJoinTableInfoMap() {
                    return replaceMainJoinTableInfoMap;
                }

                @Override
                public JoinTableInfo replaceFromJoinTableInfo() {
                    return aReplaceFromJoinTableInfo;
                }

                @Override
                public List<JoinTableInfo> withOutReplaceJoinTableInfo() {
                    return withOutReplaceJoinTableInfo;
                }
            };
        }
        return empty_ExtendReplaceMain;
    }

    private boolean canReplaceByExtend_selectFields(SingleQueryTableInfo mainJoin) {
        String joinFullObjectAliasName = mainJoin.getTableAlias();
        String pk = mainJoin.entityType.getPrimaryKey().getName().toLowerCase();
        for (PropertyField pf : this.selectFields) {
            Collection<PropertyField> propertyFields;
            String fullObjectAliasName = pf.getEntityAlias();
            if (StringUtils.isEmpty(fullObjectAliasName) && (propertyFields = pf.getPropertySegExpress().getPropertyFields()) != null && propertyFields.size() > 0) {
                for (PropertyField mulField : propertyFields) {
                    String entityAlias = mulField.getEntityAlias();
                    if (this.ignoreForExtend(mainJoin, pk, joinFullObjectAliasName, entityAlias, mulField, this.selectFields)) continue;
                    return false;
                }
            }
            if (this.ignoreForExtend(mainJoin, pk, joinFullObjectAliasName, fullObjectAliasName, pf, this.selectFields)) continue;
            return false;
        }
        return true;
    }

    private boolean ignoreForExtend(SingleQueryTableInfo mainJoin, String pk, String joinFullObjectAliasName, String entityAlias, PropertyField field, PropertyField[] fields) {
        if (!this.hasMultiGlLangProperty(Arrays.asList(fields), field)) {
            return false;
        }
        if (joinFullObjectAliasName.equals(entityAlias)) {
            ArrayList<PropertyField> pfs = new ArrayList<PropertyField>();
            if (field.isExpress()) {
                pfs.addAll(field.getPropertySegExpress().getPropertyFields());
            } else {
                pfs.add(field);
            }
            for (PropertyField pf : pfs) {
                IDataEntityProperty pType;
                String tableGroup;
                if (!joinFullObjectAliasName.equals(pf.getFullObjectName()) || pf.getName().equals(pk) || !StringUtils.isEmpty(tableGroup = (pType = (IDataEntityProperty)mainJoin.entityType.getProperties().get((Object)pf.getName())).getTableGroup())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasMultiGlLangProperty(List<PropertyField> fields, PropertyField field) {
        ArrayList<PropertyField> tempFields = new ArrayList<PropertyField>();
        for (PropertyField tempField : fields) {
            if (tempField.isExpress()) {
                tempFields.addAll(tempField.getPropertySegExpress().getPropertyFields());
                continue;
            }
            tempFields.add(tempField);
        }
        ArrayList<PropertyField> pfs = new ArrayList<PropertyField>();
        if (field.isExpress()) {
            pfs.addAll(field.getPropertySegExpress().getPropertyFields());
        } else {
            pfs.add(field);
        }
        for (PropertyField pf : pfs) {
            for (PropertyField tempField : tempFields) {
                if (!pf.getFullObjectName().equalsIgnoreCase(tempField.getFullObjectName()) || !tempField.isMultiLangProperty() || !tempField.isGLField()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canReplaceByExtend_orderBy(SingleQueryTableInfo mainJoin, SingleQueryTableInfo langJoin, String pk) {
        if (this.orderByOnSQL) {
            for (OrderByInfo ob : this.getOrderInfoList()) {
                String mainFullObjectName = mainJoin.getFullObjectName().toLowerCase(Locale.ENGLISH);
                PropertySegExpress pe = ob.getPropertySegExpress();
                if (pe != null && !pe.isExpress()) {
                    PropertyField pf;
                    if (!ob.getFullObjectName().toLowerCase(Locale.ENGLISH).equals(mainFullObjectName) || (pf = pe.getPropertyField()).getName().equals(pk)) continue;
                    IDataEntityProperty pType = (IDataEntityProperty)mainJoin.entityType.getProperties().get((Object)pf.getName());
                    if (pType == null) {
                        return false;
                    }
                    String tableGroup = pType.getTableGroup();
                    if (!StringUtils.isEmpty(tableGroup) || pf.isMultiLangProperty()) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private boolean canReplaceByExtend_groupBy(SingleQueryTableInfo mainJoin, SingleQueryTableInfo extendJoin, String pk) {
        for (GroupByInfo gb : this.getGroupByInfoList()) {
            String mainFullObjectName = mainJoin.getFullObjectName().toLowerCase(Locale.ENGLISH);
            PropertySegExpress pe = gb.getPropertySegExpress();
            if (pe != null && !pe.isExpress()) {
                PropertyField pf;
                if (!gb.getFullObjectName().toLowerCase(Locale.ENGLISH).equals(mainFullObjectName) || (pf = pe.getPropertyField()).getName().equals(pk)) continue;
                IDataEntityProperty pType = (IDataEntityProperty)mainJoin.entityType.getProperties().get((Object)pf.getName());
                if (pType == null) {
                    return false;
                }
                String tableGroup = pType.getTableGroup();
                if (!StringUtils.isEmpty(tableGroup) || pf.isMultiLangProperty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean canReplaceByExtend_QFilter(SingleQueryTableInfo mainJoin, SingleQueryTableInfo langJoin, String pk, QFilter whereFilter) {
        if (whereFilter != null) {
            ArrayList<QFilter> segs = new ArrayList<QFilter>(16);
            segs.add(whereFilter);
            for (QFilter.QFilterNest nest : whereFilter.getNests(true)) {
                segs.add(nest.getFilter());
            }
            String mainFullObjectName = mainJoin.getTableAlias();
            ArrayList<PropertyField> tempFields = new ArrayList<PropertyField>();
            for (QFilter f : segs) {
                if (QMatches.isFtlike(f)) continue;
                PropertyField pf = f.__getParsedProperty(this.ctx);
                if (f.isExpressValue()) {
                    PropertyField tempPF = f.__getParsedExpressValue(this.ctx);
                    if (tempPF == null) {
                        tempFields.add(pf);
                        continue;
                    }
                    if (tempPF.isExpress()) {
                        tempFields.addAll(tempPF.getPropertySegExpress().getPropertyFields());
                        continue;
                    }
                    tempFields.add(tempPF);
                    continue;
                }
                tempFields.add(pf);
            }
            for (PropertyField selectField : this.selectFields) {
                if (selectField.isExpress()) {
                    tempFields.addAll(selectField.getPropertySegExpress().getPropertyFields());
                    continue;
                }
                tempFields.add(selectField);
            }
            for (QFilter f : segs) {
                if (QMatches.isFtlike(f) || this.canToTempTable(f)) {
                    return false;
                }
                PropertyField pf = f.__getParsedProperty(this.ctx);
                if (f.isExpressValue()) {
                    PropertyField tmepPF = f.__getParsedExpressValue(this.ctx);
                    if (tmepPF == null) {
                        tmepPF = pf;
                    }
                    if (tmepPF != null && this.extendHasProperty(tempFields, tmepPF, mainFullObjectName, mainJoin, pk, false)) continue;
                    return false;
                }
                if (this.extendHasProperty(tempFields, pf, mainFullObjectName, mainJoin, pk, false)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean extendHasProperty(List<PropertyField> tempFields, PropertyField rootPF, String mainFullObjectName, SingleQueryTableInfo mainJoin, String pk, boolean isMatchPF) {
        if ((rootPF = this.ctx.putPerformJoinField(rootPF)) != null) {
            ArrayList<PropertyField> pfs = new ArrayList<PropertyField>();
            if (rootPF.isExpress()) {
                pfs.addAll(rootPF.getPropertySegExpress().getPropertyFields());
            } else {
                pfs.add(rootPF);
            }
            for (PropertyField pf : pfs) {
                if (pf == null || !mainFullObjectName.equals(pf.getFullObjectName())) continue;
                if (!pf.getName().equals(pk)) {
                    IDataEntityProperty pType = (IDataEntityProperty)mainJoin.entityType.getProperties().get((Object)pf.getName());
                    if (pType == null) {
                        return false;
                    }
                    String tableGroup = pType.getTableGroup();
                    if (!StringUtils.isEmpty(tableGroup) || pf.isMultiLangProperty()) continue;
                    return false;
                }
                boolean existExtend = false;
                for (PropertyField field : tempFields) {
                    String tableGroup;
                    IDataEntityProperty pType;
                    if (pf == null || field == null || !pf.getFullObjectName().equalsIgnoreCase(field.getFullObjectName()) || (pType = field.getPeropertyType()) == null || StringUtils.isEmpty(tableGroup = pType.getTableGroup())) continue;
                    existExtend = true;
                    break;
                }
                if (existExtend) continue;
                return false;
            }
        }
        return true;
    }

    private boolean returnMultiKTypeInnerField(PropertyField field, SingleQuery subQuey) {
        try {
            String name;
            IDataEntityProperty parentJoinPropertyType;
            EntityItem entityItem = this.allCtx.getEntityItem(field.getFullObjectName());
            EntityItemJoinProperty joinProperty = entityItem.joinProperty;
            if (joinProperty != null && (parentJoinPropertyType = joinProperty.getParentJoinPropertyType()) != null && "kd.bos.entity.property.ItemClassProp".equalsIgnoreCase(parentJoinPropertyType.getClass().getName()) && ((name = parentJoinPropertyType.getName()) + ".id").equalsIgnoreCase(field.getAlias())) {
                return this.shouldSelectPk || this.selectFieldContainthisField(field, subQuey);
            }
        }
        catch (Exception e) {
            log.error("judge error:", (Throwable)e);
        }
        return true;
    }

    private boolean selectFieldContainthisField(PropertyField field, SingleQuery subQuey) {
        for (PropertyField selectField : this.selectFields) {
            if (!field.getAlias().trim().equalsIgnoreCase(selectField.getAlias().trim())) continue;
            return true;
        }
        for (PropertyField selectField : subQuey.getSelectFields()) {
            if (!field.getAlias().trim().equalsIgnoreCase(selectField.getAlias().trim())) continue;
            return true;
        }
        return false;
    }

    void removeUselessField(boolean finallySingleQuery, boolean removeInnerField) {
        if (finallySingleQuery && removeInnerField) {
            ArrayList<PropertyField> pfs = new ArrayList<PropertyField>(this.selectFields.length);
            PropertyField[] userSelectFields = this.allCtx.getUserSelectFields();
            for (PropertyField pf : this.selectFields) {
                if (pf.isInnerField() || !this.userFieldsContains(pf, userSelectFields)) continue;
                pfs.add(pf);
            }
            if (pfs.size() < this.selectFields.length) {
                this.selectFields = pfs.toArray(new PropertyField[pfs.size()]);
                this.shouldRebuildSQL = true;
            }
        }
    }

    private boolean userFieldsContains(PropertyField pf, PropertyField[] userSelectFields) {
        for (PropertyField tempField : userSelectFields) {
            if (pf != tempField && !pf.getFullName().toLowerCase(Locale.ENGLISH).equals(tempField.getFullName().toLowerCase(Locale.ENGLISH)) && !pf.getAlias().toLowerCase(Locale.ENGLISH).equals(tempField.getAlias().toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private boolean canIgnore(boolean canIgnoreJoin, SingleQueryTableInfo mainJoin, SingleQueryTableInfo extendJoin, QFilter whereFilter, QFilter havingFilter) {
        if (!mainJoin.isFromTable()) {
            canIgnoreJoin &= mainJoin.joinTable.getJoin() != ORMHint.JoinHint.INNER;
        }
        if (!extendJoin.isFromTable()) {
            canIgnoreJoin &= extendJoin.joinTable.getJoin() != ORMHint.JoinHint.INNER;
        }
        if (canIgnoreJoin &= this.canReplaceByExtend_selectFields(mainJoin)) {
            String pk = mainJoin.entityType.getPrimaryKey().getName().toLowerCase();
            if (canIgnoreJoin &= this.canReplaceByExtend_QFilter(mainJoin, extendJoin, pk, whereFilter)) {
                canIgnoreJoin &= this.canReplaceByExtend_QFilter(mainJoin, extendJoin, pk, havingFilter);
            }
            if (canIgnoreJoin && extendJoin.joinTable.getJoinFilters() != null) {
                canIgnoreJoin &= this.canReplaceByExtend_QFilter(mainJoin, extendJoin, pk, extendJoin.joinTable.getJoinFilters());
            }
            if (canIgnoreJoin) {
                canIgnoreJoin &= this.canReplaceByExtend_orderBy(mainJoin, extendJoin, pk);
            }
            if (canIgnoreJoin) {
                canIgnoreJoin &= this.canReplaceByExtend_groupBy(mainJoin, extendJoin, pk);
            }
        }
        return canIgnoreJoin;
    }

    private boolean containsIsNullContidion(QFilter whereFilter) {
        if (whereFilter == null) {
            return false;
        }
        String filterProperty = whereFilter.getProperty();
        PropertyField field = whereFilter.__getParsedProperty(this.ctx);
        if (field != null && field.isMultiLangProperty() && filterProperty != null && filterProperty.trim().indexOf(".") == -1 && (whereFilter.getCP().trim().toLowerCase(Locale.ENGLISH).equals("is null") || whereFilter.getValue() instanceof QEmptyValue)) {
            return true;
        }
        List<QFilter.QFilterNest> nests = whereFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            if (!this.containsIsNullContidion(nest.getFilter())) continue;
            return true;
        }
        return false;
    }

    private boolean canToTempTable(QFilter filter) {
        if (filter == null) {
            return false;
        }
        if (!filter.isExpressValue() && filter.getCP() != null && filter.getCP().toLowerCase().indexOf("in") != -1) {
            Object value = filter.getValue();
            if (value != null) {
                Object[] params = QFilterUtil.getWithoutDuplicateInValues(value);
                int size = params.length;
                return size >= ORMUtil.toTempTableSize(this.ctx == null ? null : this.ctx.getORMHint());
            }
            return false;
        }
        return false;
    }

    private boolean orderByItemClassProp(PropertyField field) {
        if ("kd.bos.entity.property.ItemClassProp".equalsIgnoreCase(field.getPeropertyType().getClass().getName())) {
            for (OrderByInfo orderByInfo : this.getAllOrderByList()) {
                String orderByInfoFullName;
                String[] split;
                if (!field.getFullName().equalsIgnoreCase(orderByInfo.getFullObjectName()) || (split = (orderByInfoFullName = orderByInfo.getPropertySegExpress().getPropertyField().getFullName()).split(orderByInfo.getFullObjectName())).length <= 1) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ConfigurationUtil.observeBoolean((String)"orm.opt.sortjointable.bywords", (boolean)SORT_JOINTABLE_BYWORDS, b -> {
            SORT_JOINTABLE_BYWORDS = b;
        });
        ENABLE_OPTIMIZE_LANG_MAINTABLE = Boolean.parseBoolean(System.getProperty("orm.optimize.langmaintable", "true"));
        log = LogFactory.getLog(SingleQuery.class);
        empty_LangReplaceMain = new LangReplaceMain(){

            @Override
            public void close() {
            }

            @Override
            public Map<JoinTableInfo, JoinTableInfo> replaceMainJoinTableInfoMap() {
                return Collections.emptyMap();
            }

            @Override
            public JoinTableInfo replaceFromJoinTableInfo() {
                return null;
            }
        };
        empty_ExtendReplaceMain = new ExtendReplaceMain(){

            @Override
            public void close() {
            }

            @Override
            public Map<JoinTableInfo, List<JoinTableInfo>> replaceMainJoinTableInfoMap() {
                return Collections.emptyMap();
            }

            @Override
            public JoinTableInfo replaceFromJoinTableInfo() {
                return null;
            }

            @Override
            public List<JoinTableInfo> withOutReplaceJoinTableInfo() {
                return null;
            }
        };
    }

    private static interface ExtendReplaceMain
    extends AutoCloseable {
        @Override
        public void close();

        public Map<JoinTableInfo, List<JoinTableInfo>> replaceMainJoinTableInfoMap();

        public JoinTableInfo replaceFromJoinTableInfo();

        public List<JoinTableInfo> withOutReplaceJoinTableInfo();
    }

    public static class QueryParameter {
        String sql;
        Object[] params;
        QFilter genQueryParameterWhereQFilter;

        private void addParams(Object[] params) {
            if (params != null && params.length > 0) {
                if (this.params == null || this.params.length == 0) {
                    this.params = params;
                } else {
                    Object[] both = new Object[this.params.length + params.length];
                    System.arraycopy(this.params, 0, both, 0, this.params.length);
                    System.arraycopy(params, 0, both, this.params.length, params.length);
                    this.params = both;
                }
            }
        }

        public String toString() {
            return this.sql;
        }

        public String getSql() {
            return this.sql;
        }

        public Object[] getParams() {
            return this.params;
        }
    }

    private static interface LangReplaceMain
    extends AutoCloseable {
        @Override
        public void close();

        public Map<JoinTableInfo, JoinTableInfo> replaceMainJoinTableInfoMap();

        public JoinTableInfo replaceFromJoinTableInfo();
    }
}

