/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.multi.JoinTableInfo;

class SingleQueryTableInfo {
    boolean fromTable;
    JoinTableInfo joinTable;
    IDataEntityType entityType;
    String tableAlias;
    String fullObjectName;

    SingleQueryTableInfo() {
    }

    static SingleQueryTableInfo createSingleQueryTableInfoByJoinTable(JoinTableInfo joinTable) {
        SingleQueryTableInfo ti = new SingleQueryTableInfo();
        ti.fromTable = false;
        ti.joinTable = joinTable;
        ti.entityType = joinTable.getEntityItem().entityType;
        ti.tableAlias = joinTable.getTableAlias();
        ti.fullObjectName = joinTable.getEntityItem().getFullObjectName();
        return ti;
    }

    static SingleQueryTableInfo createSingleQueryTableInfoByFromTable(IDataEntityType entityType, String fullObjName) {
        SingleQueryTableInfo ti = new SingleQueryTableInfo();
        ti.fromTable = true;
        ti.joinTable = null;
        ti.entityType = entityType;
        ti.tableAlias = fullObjName.length() == 0 ? entityType.getName() : fullObjName;
        ti.fullObjectName = fullObjName;
        return ti;
    }

    boolean isFromTable() {
        return this.fromTable;
    }

    String getTableAlias() {
        return this.tableAlias;
    }

    String getFullObjectName() {
        return this.fullObjectName;
    }
}

