/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.Iterator;
import java.util.Locale;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.bundle.BosRes;
import kd.bos.db.QueryMeta;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.OptimizeOnCostDownIter;
import kd.bos.orm.query.optimize.QueryTreeNode;

public class OptimizeOnCostDownDataSet
extends AbstractDataSet {
    private DataSet originDataSet;
    private QueryTreeNode lazyQueryNode;
    private RowMeta rowMeta;
    private String keyName;

    public OptimizeOnCostDownDataSet(DataSet originDataSet, QueryTreeNode lazyQueryNode) {
        super("OptimizeOnCostDownDataSet", (AbstractDataSet)originDataSet);
        PropertyField field;
        SingleQuery query;
        this.originDataSet = originDataSet;
        this.lazyQueryNode = lazyQueryNode;
        QueryMeta queryMeta = lazyQueryNode.getQuery().createQueryMeta();
        RowMeta rowMeta = queryMeta.getRowMeta();
        Field[] fields = rowMeta.getFields();
        boolean hasUnkownType = false;
        for (Field field2 : fields) {
            if (field2.getDataType() != DataType.UnknownType) continue;
            hasUnkownType = true;
            break;
        }
        if (hasUnkownType) {
            query = lazyQueryNode.getQuery();
            QFilter bakQFilter = query.getWhereFilter();
            SingleQuery singleQuery = query.optResetFilter(new QFilter("1", "!=", 1));
            DataSet dataSet = singleQuery.queryWithTop("OptimizeOnCostDownDataSet", false);
            this.rowMeta = dataSet.getRowMeta();
            query.optResetFilter(bakQFilter);
        } else {
            this.rowMeta = rowMeta;
        }
        query = lazyQueryNode.getQuery();
        EntityItem ei = query.getAllCtx().getEntityItem(query.getFullObjName());
        String fkName = ei.joinProperty.getParentOriginProperty().getName().toLowerCase(Locale.ENGLISH);
        String fkAlias = null;
        PropertyField[] propertyFieldArray = lazyQueryNode.getParent().getQuery().getSelectFields();
        int n = propertyFieldArray.length;
        for (int i = 0; !(i >= n || ((field = propertyFieldArray[i]).getName().equalsIgnoreCase(fkName) || ("INNER_" + fkName).equalsIgnoreCase(field.getAlias())) && (fkAlias = field.getAlias()) != null && fkAlias.equalsIgnoreCase(query.getParentFK())); ++i) {
        }
        if (fkAlias == null) {
            throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"QueryOptimizeMate_2", (String)"{0}#{1}\u5173\u8054\u5bf9\u8c61\u7684\u5c5e\u6027\u4e0d\u5728selectFields\u4e2d:{2}#{3}", (Object[])new Object[]{query.getFullObjName(), fkName, lazyQueryNode.getParent().getQuery().getFullObjName(), lazyQueryNode.getParent().getQuery().getSelectFields()}));
        }
        this.keyName = fkAlias;
    }

    protected RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    protected InnerRowIterator createIterator() {
        return new OptimizeOnCostDownIter((Iterator<Row>)((AbstractDataSet)this.originDataSet).innerIterator(), this.keyName, this.lazyQueryNode);
    }

    public void realClose() {
        if (this.originDataSet != null) {
            this.originDataSet.close();
        }
    }
}

