/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.QueryTreeNode;

public class OptimizeOnCostDownIter
extends InnerRowIterator {
    private QueryTreeNode node;
    private Iterator<Row> iter;
    private Iterator<Row> cacheRowIter;
    private String keyName;

    public OptimizeOnCostDownIter(Iterator<Row> iter, String keyName, QueryTreeNode node) {
        this.iter = iter;
        this.node = node;
        this.keyName = keyName;
    }

    protected boolean _hasNext() {
        if (this.cacheRowIter != null) {
            boolean b = this.cacheRowIter.hasNext();
            if (!b) {
                this.cacheData();
                b = this.cacheRowIter.hasNext();
            }
            return b;
        }
        this.cacheData();
        return this.cacheRowIter != null && this.cacheRowIter.hasNext();
    }

    protected Row _next() {
        return this.cacheRowIter.next();
    }

    private void cacheData() {
        int cacheSize = ORMConfig.OPTIMIZE_ON_COST_CACHESIZE.getInt();
        do {
            String fullObjName;
            int index;
            String rootName;
            int count = 0;
            HashSet<Object> ids = new HashSet<Object>(cacheSize);
            while (this.iter.hasNext()) {
                Row row = this.iter.next();
                ids.add(row.get(this.keyName));
                if (++count <= cacheSize) continue;
                break;
            }
            if (ids.isEmpty()) {
                return;
            }
            SingleQuery query = this.node.getQuery();
            Map<String, QFilter> allJoinFilterMap = query.getAllJoinFilterMap();
            HashMap<String, QFilter> allJoinFilterMapBak = new HashMap<String, QFilter>();
            if (allJoinFilterMap != null && allJoinFilterMap.size() > 0) {
                allJoinFilterMapBak.putAll(allJoinFilterMap);
            }
            EntityItem ei = query.getAllCtx().getEntityItem(query.getFullObjName());
            String fkName = ei.joinProperty.getParentOriginProperty().getName().toLowerCase(Locale.ENGLISH);
            String pkName = this.node.getQuery().getDataEntityType().getPrimaryKey().getName().toLowerCase();
            QFilter filter = query.getWhereFilter();
            boolean isMulTypeBasedata = ORMUtil.isMulTypeBasedata(fkName, ei);
            String downFullName = QueryUtils.getDownFullName(filter, query.getFullObjName(), pkName, isMulTypeBasedata);
            if (!downFullName.startsWith((rootName = (index = (fullObjName = query.getFullObjName()).indexOf(".")) == -1 ? fullObjName : fullObjName.substring(0, index)) + ".")) {
                downFullName = rootName + "." + downFullName;
            }
            QFilter addFilter = new QFilter(downFullName, "in", ids);
            query = query.optResetFilter(addFilter);
            DataSet optimizeCostOn = query.queryWithTop("OptimizeCostOnDown", false);
            query.setAllJoinFilterMap(allJoinFilterMapBak);
            this.node.setQuery(query);
            this.cacheRowIter = optimizeCostOn.iterator();
        } while (!this.cacheRowIter.hasNext());
    }
}

