/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.datatype.AnyType;
import kd.bos.db.QueryMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.OptimizeOnCostUpIter;
import kd.bos.orm.query.optimize.QueryOptimizater;
import kd.bos.orm.query.optimize.QueryTreeNode;

public class OptimizeOnCostUpDataSet
extends AbstractDataSet {
    private Map<String, DataSet> originDataSets;
    private Map<String, SingleQuery> querys;
    private QueryTreeNode lazyQueryNode;
    private RowMeta rowMeta;
    private QueryOptimizater qo;

    public OptimizeOnCostUpDataSet(Map<String, DataSet> originDataSets, Map<String, SingleQuery> querys, List<AbstractDataSet> dataSets, QueryTreeNode lazyQueryNode, QueryOptimizater qo) {
        super("OptimizeOnCostUpDataSet", dataSets.get(0).getEnvironment(), new ArrayList());
        this.originDataSets = originDataSets;
        this.lazyQueryNode = lazyQueryNode;
        this.querys = querys;
        this.qo = qo;
        QueryMeta queryMeta = lazyQueryNode.getQuery().createQueryMeta();
        RowMeta rowMeta = queryMeta.getRowMeta();
        Field[] fields = rowMeta.getFields();
        boolean hasUnkownType = false;
        for (Field field : fields) {
            DataType dataType = field.getDataType();
            if (dataType != DataType.UnknownType && dataType != AnyType.instance) continue;
            hasUnkownType = true;
            break;
        }
        if (hasUnkownType) {
            SingleQuery query = lazyQueryNode.getQuery();
            QFilter bakQFilter = query.getWhereFilter();
            SingleQuery singleQuery = query.optResetFilter(new QFilter("1", "!=", 1));
            DataSet dataSet = singleQuery.queryWithTop("OptimizeOnCostUpDataSet", false);
            this.rowMeta = dataSet.getRowMeta();
            query.optResetFilter(bakQFilter);
        } else {
            this.rowMeta = rowMeta;
        }
    }

    protected RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    protected InnerRowIterator createIterator() {
        return new OptimizeOnCostUpIter(this.originDataSets, this.querys, this.lazyQueryNode, this.qo);
    }

    public void realClose() {
        if (this.originDataSets != null && this.originDataSets.size() > 0) {
            Collection<DataSet> values = this.originDataSets.values();
            for (DataSet dataSet : values) {
                dataSet.close();
            }
        }
    }
}

