/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.QueryOptimizater;
import kd.bos.orm.query.optimize.QueryTreeNode;

public class OptimizeOnCostUpIter
extends InnerRowIterator {
    private QueryTreeNode node;
    private Map<String, Iterator<Row>> originIters;
    private Map<String, SingleQuery> querys;
    private Map<String, String> keyNames;
    private Iterator<Row> cacheRowIter;
    private QFilter originQFilter;
    private QueryOptimizater qo;

    public OptimizeOnCostUpIter(Map<String, DataSet> originDataSets, Map<String, SingleQuery> querys, QueryTreeNode node, QueryOptimizater qo) {
        Set<Map.Entry<String, DataSet>> entries = originDataSets.entrySet();
        this.originIters = new HashMap<String, Iterator<Row>>(entries.size());
        this.keyNames = new HashMap<String, String>(entries.size());
        this.qo = qo;
        for (Map.Entry<String, DataSet> entry : entries) {
            String key = entry.getKey();
            DataSet value = entry.getValue();
            this.originIters.put(key, value.iterator());
            SingleQuery childrenQuery = querys.get(key);
            EntityItem ei = childrenQuery.getAllCtx().getEntityItem(childrenQuery.getFullObjName());
            String pkName = ei.entityType.getPrimaryKey().getName().toLowerCase(Locale.ENGLISH);
            String pkAlias = null;
            for (PropertyField field : childrenQuery.getSelectFields()) {
                if (!field.getName().toLowerCase(Locale.ENGLISH).equals(pkName) || !field.getFullObjectName().equalsIgnoreCase(childrenQuery.getFullObjName())) continue;
                pkAlias = field.getAlias();
                break;
            }
            this.keyNames.put(key, pkAlias);
        }
        this.node = node;
        this.querys = querys;
        this.originQFilter = node.getQuery().getWhereFilter();
    }

    protected boolean _hasNext() {
        if (this.cacheRowIter != null) {
            boolean b = this.cacheRowIter.hasNext();
            if (!b) {
                this.cacheData();
                b = this.cacheRowIter.hasNext();
            }
            return b;
        }
        this.cacheData();
        return this.cacheRowIter != null && this.cacheRowIter.hasNext();
    }

    protected Row _next() {
        return this.cacheRowIter.next();
    }

    private void cacheData() {
        int cacheSize = ORMConfig.OPTIMIZE_ON_COST_CACHESIZE.getInt();
        do {
            HashMap<String, HashSet<Object>> ids = new HashMap<String, HashSet<Object>>();
            Set<Map.Entry<String, Iterator<Row>>> entries = this.originIters.entrySet();
            for (int i = 0; i < cacheSize; ++i) {
                for (Map.Entry<String, Iterator<Row>> next : entries) {
                    String key = next.getKey();
                    Iterator<Row> value = next.getValue();
                    if (!value.hasNext()) continue;
                    Row row = value.next();
                    String keyName = this.keyNames.get(key);
                    Object id = row.get(keyName);
                    HashSet<Object> objects = (HashSet<Object>)ids.get(key);
                    if (objects == null) {
                        objects = new HashSet<Object>(cacheSize);
                        ids.put(key, objects);
                    }
                    objects.add(id);
                }
            }
            if (ids.isEmpty()) {
                return;
            }
            Iterator iterator = ids.entrySet().iterator();
            SingleQuery parentQuery = this.node.getQuery();
            Map<String, QFilter> allJoinFilterMap = parentQuery.getAllJoinFilterMap();
            HashMap<String, QFilter> allJoinFilterMapBak = new HashMap<String, QFilter>();
            if (allJoinFilterMap != null && allJoinFilterMap.size() > 0) {
                allJoinFilterMapBak.putAll(allJoinFilterMap);
            }
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String fullObject = (String)next.getKey();
                Set idSet = (Set)next.getValue();
                String downFullName = QueryUtils.getUpFullName(this.querys.get(fullObject), this.node.getQuery());
                int dot = downFullName.indexOf(46);
                if (dot != -1) {
                    downFullName = downFullName.substring(dot + 1);
                }
                QFilter addFilter = QueryUtils.generateRoleUpCP(this.node.getQuery(), this.querys.get(fullObject), downFullName, idSet);
                QFilter filter = this.originQFilter == null ? null : this.originQFilter.copy();
                filter = filter == null ? addFilter : QueryUtils.generateRoleUpQFilter(filter, addFilter);
                parentQuery = parentQuery.optResetFilter(filter);
                this.node.setQuery(parentQuery);
            }
            ORMOptimization opt = new ORMOptimization();
            int roleDownThreshold = Math.min(opt.getRootForcePushDownCostThreshold(), opt.getRoleOnCostThreshold());
            DataSet optimizeCostOn = this.node.getParent() == null && this.qo.isQueryRootWithTop() ? (this.qo.isAllPushUp() ? parentQuery.queryWithTop("OptimizeCostOnUp", true) : parentQuery.queryPeekingWithTop("OptimizeCostOnUp", roleDownThreshold).getDataSet()) : parentQuery.queryPeeking("OptimizeCostOnUp", roleDownThreshold).getDataSet();
            this.cacheRowIter = optimizeCostOn.iterator();
            parentQuery.setAllJoinFilterMap(allJoinFilterMapBak);
            this.node.setQuery(parentQuery);
        } while (!this.cacheRowIter.hasNext());
    }
}

