/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.PeekingDataSet;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.dataentity.AggregateFuncs;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.PrepareJoinDB;
import kd.bos.orm.query.optimize.QueryOptimizeMate;
import kd.bos.orm.query.optimize.QueryOrders;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.optimize.QueryTreeNodeDeepVisitor;
import kd.bos.orm.query.optimize.QueryTreeNodeVisitor;
import kd.bos.orm.util.CollectionUtils;

public class QueryOptimizater {
    final ORMOptimization opt;
    final QContext allCtx;
    final int roleOnCostThreshold;
    private final PropertyField[] userSelectFields;
    private QueryOptimizeMate mate;
    private boolean queryRootWithTop;
    private boolean allPushUp;

    public QueryOptimizater(ORMOptimization opt, PropertyField[] userSelectFields, QContext allCtx) {
        this.opt = opt;
        this.userSelectFields = userSelectFields;
        this.roleOnCostThreshold = opt.getRoleOnCostThreshold();
        this.allCtx = allCtx;
        this.mate = new QueryOptimizeMate(this);
    }

    public boolean isQueryRootWithTop() {
        return this.queryRootWithTop;
    }

    public boolean isAllPushUp() {
        return this.allPushUp;
    }

    public DataSet query(String algoKey, SingleQuery[] queries) {
        QueryOrders customerOrders;
        QueryTreeNode root = QueryTreeNode.create(queries);
        QueryUtils.rebuildRecursion(algoKey, root);
        boolean bl = this.queryRootWithTop = queries.length == 1;
        if (queries.length == 1 && CollectionUtils.isEmpty(root.getQuery().getSubQueryNodes())) {
            this.replaceOrderBy(root);
            return this.finallySingleQuery(algoKey, root);
        }
        if (this.opt.isTurnOff()) {
            OrderInfo oi = this.removeOrderOnSQL(algoKey, root);
            return this.finallyMultiQuery(algoKey, root, oi, true);
        }
        if (this.opt.isJoinInSameDatabase()) {
            PrepareJoinDB.prepare(root);
        }
        this.reduceUnnessesaryJoin(root);
        this.joinInSameDatabase(root);
        this.replaceOrderBy(root);
        if (root.isLeaf()) {
            this.queryRootWithTop = true;
            return this.finallySingleQuery(algoKey, root);
        }
        OrderInfo oi = this.removeOrderOnSQL(algoKey, root);
        if (this.mate.withRoleOnPK(root)) {
            if (root.getQuery().getTop() >= 0 && root.isPkRoleOn()) {
                root.setPkRoleOn(false);
            }
            this.roleOnPK(algoKey, root);
        }
        if ((customerOrders = QueryOrders.customerOrders(this.allCtx.getORMHint().getQueryOrders(), root)).effect()) {
            this.queryWithOrders(algoKey, customerOrders, root);
        }
        if (this.mate.withRoleOnCost(root) || this.opt.isForcePushEnabled()) {
            this.roleOnCost(algoKey, root);
        }
        return this.finallyMultiQuery(algoKey, root, oi, false);
    }

    public QueryTreeNode getOptimalQueryTreeNode(SingleQuery[] queries) {
        QueryTreeNode root = QueryTreeNode.create(queries);
        boolean bl = this.queryRootWithTop = queries.length == 1;
        if (queries.length != 1) {
            if (this.opt.isTurnOff()) {
                this.removeOrderOnSQL(null, root);
            } else {
                if (this.opt.isJoinInSameDatabase()) {
                    PrepareJoinDB.prepare(root);
                }
                this.reduceUnnessesaryJoin(root);
                this.joinInSameDatabase(root);
            }
        }
        return root;
    }

    private void replaceOrderBy(QueryTreeNode root) {
        root.accept(new QueryTreeNodeVisitor(){

            @Override
            public void visit(QueryTreeNode node) {
                SingleQuery query = node.getQuery();
                List<OrderByInfo> orderBys = query.getOrderInfoList();
                if (orderBys != null && !orderBys.isEmpty()) {
                    boolean resetOrderBy = false;
                    for (OrderByInfo ob : orderBys) {
                        String fullPropertyName;
                        int pos;
                        PropertySegExpress pe = ob.getPropertySegExpress();
                        if (pe == null || pe.isExpress() || (pos = (fullPropertyName = pe.getFullPropertyNames().get(0)).lastIndexOf(46)) <= 0) continue;
                        String propertyName = fullPropertyName.substring(pos + 1);
                        EntityItem ei = query.getAllCtx().getEntityItem(ob.getFullObjectName());
                        IDataEntityProperty ptype = ei.getPropertyItem(propertyName).getPropertyType();
                        if (ei.getParentEntityItem() == null || ORMConfiguration.isEntryEntityType(ptype.getParent()) || !ei.entityType.getPrimaryKey().getName().equalsIgnoreCase(ptype.getName()) || query.isHasDistinct()) continue;
                        ob.replaceWhenOneProperty(new PropertyField(ei.getParentEntityItem().getFullObjectName() + '.' + fullPropertyName.substring(0, pos)));
                        if (resetOrderBy) continue;
                        resetOrderBy = true;
                    }
                    if (resetOrderBy) {
                        node.setQuery(query.optRebuild());
                    }
                }
                for (QueryTreeNode subNode : node.getChildren()) {
                    subNode.accept(this);
                }
            }
        });
    }

    private OrderInfo removeOrderOnSQL(String algoKey, final QueryTreeNode root) {
        boolean withOrder;
        final AtomicBoolean main = new AtomicBoolean(false);
        final AtomicBoolean sub = new AtomicBoolean(false);
        root.accept(new QueryTreeNodeVisitor(){

            @Override
            public void visit(QueryTreeNode node) {
                List<OrderByInfo> orderBys = node.getQuery().getOrderInfoList();
                if (orderBys != null && !orderBys.isEmpty()) {
                    if (root == node) {
                        main.set(true);
                    } else {
                        sub.set(true);
                    }
                }
                for (QueryTreeNode subNode : node.getChildren()) {
                    subNode.accept(this);
                }
            }
        });
        MixedOrder mo = main.get() ? (sub.get() ? MixedOrder.mainAndSub : MixedOrder.main) : (sub.get() ? MixedOrder.sub : MixedOrder.none);
        final ArrayList<OrderByInfo> outerOrderBys = new ArrayList<OrderByInfo>();
        final boolean orderByOnSQL = mo == MixedOrder.main;
        boolean bl = withOrder = mo != MixedOrder.none;
        if (withOrder) {
            root.accept(new QueryTreeNodeVisitor(){

                @Override
                public void visit(QueryTreeNode node) {
                    SingleQuery query = node.getQuery();
                    List<OrderByInfo> orderBys = query.getOrderInfoList();
                    if (orderBys != null && !orderBys.isEmpty() && !orderByOnSQL && query.isOrderByOnSQL()) {
                        outerOrderBys.addAll(orderBys);
                        query.setOrderByOnSQL(false);
                        query = query.optRebuild();
                        node.setQuery(query);
                    }
                    for (QueryTreeNode subNode : node.getChildren()) {
                        subNode.accept(this);
                    }
                }
            });
        }
        if (mo != MixedOrder.none) {
            QContext allCtx = root.getQuery().getAllCtx();
            allCtx.setHasOrderField(true);
        }
        OrderInfo oi = new OrderInfo();
        oi.mo = mo;
        oi.outerOrderBys = outerOrderBys;
        return oi;
    }

    DataSet finallySingleQuery(String algoKey, QueryTreeNode root) {
        if (root.getPeekingDataSet() == null) {
            return root.getQuery().query(algoKey, true);
        }
        return root.getPeekingDataSet().getDataSet();
    }

    private void queryWithOrders(String algoKey, QueryOrders orders, QueryTreeNode root) {
        final HashMap originCostMap = new HashMap();
        root.accept(new QueryTreeNodeDeepVisitor(){

            @Override
            protected void deepFirstVisit(QueryTreeNode node) {
                originCostMap.put(node, node.isCostRoleOn());
            }
        });
        for (QueryTreeNode queryTreeNode : originCostMap.keySet()) {
            queryTreeNode.setCostRoleOn(false);
        }
        for (QueryTreeNode queryTreeNode : orders.getOrderQueryTreeNode()) {
            if (queryTreeNode.getPeekingDataSet() != null || ORMUtil.optimizeOnCostEnable(queryTreeNode.getQuery().getAllCtx()) && queryTreeNode.isLazyQuery()) continue;
            PeekingDataSet pds = queryTreeNode.queryPeeking(algoKey, this.roleOnCostThreshold);
            queryTreeNode.setPeekingDataSet(pds);
            if (pds.getPeekingRowCount() >= this.roleOnCostThreshold) continue;
            this.roleOnCost(algoKey, root);
        }
        for (Map.Entry entry : originCostMap.entrySet()) {
            QueryTreeNode node = (QueryTreeNode)entry.getKey();
            node.setCostRoleOn((Boolean)entry.getValue());
        }
    }

    DataSet finallyMultiQuery(final String algoKey, final QueryTreeNode root, OrderInfo oi, boolean optOFF) {
        RowMeta rm;
        final HashMap<QueryTreeNode, DataSet> dsMap = new HashMap<QueryTreeNode, DataSet>();
        if (optOFF) {
            root.accept(new QueryTreeNodeVisitor(){

                @Override
                public void visit(QueryTreeNode node) {
                    if (node.getPeekingDataSet() == null) {
                        DataSet ds = QueryOptimizater.this.queryRootWithTop && node == root ? node.getQuery().queryWithTop(algoKey) : node.getQuery().query(algoKey, false);
                        dsMap.put(node, ds);
                    } else {
                        dsMap.put(node, node.getPeekingDataSet().getDataSet());
                    }
                    for (QueryTreeNode subNode : node.getChildren()) {
                        subNode.accept(this);
                    }
                }
            });
        } else {
            int roleDownThreshold = Math.min(this.opt.getRootForcePushDownCostThreshold(), this.roleOnCostThreshold);
            if (root.getPeekingDataSet() == null || root.isLazyQuery()) {
                PropertyField[] rootSelectFields;
                if ((oi.mo == MixedOrder.none || oi.mo == MixedOrder.main) && (rootSelectFields = root.getQuery().getSelectFields()).length >= this.userSelectFields.length) {
                    boolean onSelectRootField = true;
                    HashSet<String> rootSelectAlias = new HashSet<String>(this.userSelectFields.length);
                    for (PropertyField pf : rootSelectFields) {
                        rootSelectAlias.add(pf.getAlias().toLowerCase());
                    }
                    for (PropertyField pf : this.userSelectFields) {
                        if (rootSelectAlias.contains(pf.getAlias().toLowerCase())) continue;
                        onSelectRootField = false;
                        break;
                    }
                    if (onSelectRootField) {
                        final AtomicBoolean allPushUp = new AtomicBoolean(true);
                        root.accept(new QueryTreeNodeVisitor(){

                            @Override
                            public void visit(QueryTreeNode node) {
                                if (node != root) {
                                    if (!node.isPushUp()) {
                                        allPushUp.set(false);
                                    } else {
                                        for (QueryTreeNode subNode : node.getChildren()) {
                                            subNode.accept(this);
                                        }
                                    }
                                } else {
                                    for (QueryTreeNode subNode : node.getChildren()) {
                                        subNode.accept(this);
                                    }
                                }
                            }
                        });
                        if (allPushUp.get()) {
                            this.queryRootWithTop = true;
                            if (ORMConfig.AGGREGATE_CROSSDB_BY_SQL.getBoolean() && this.allCtx.isAggregate() && !this.allCtx.isAggregateByGroup()) {
                                return this.crossDBAggreteIntoSqlAggregate(algoKey, root);
                            }
                            if (root.isLazyQuery() && root.getPeekingDataSet() != null) {
                                this.allPushUp = allPushUp.get();
                                return root.getPeekingDataSet().getDataSet();
                            }
                            return root.getQuery().queryWithTop(algoKey, true);
                        }
                    }
                }
                if (this.queryRootWithTop) {
                    PeekingDataSet pds;
                    if (root.isLazyQuery() && root.getPeekingDataSet() != null) {
                        pds = root.getPeekingDataSet();
                    } else {
                        pds = root.getQuery().queryPeekingWithTop(algoKey, roleDownThreshold);
                        root.setPeekingDataSet(pds);
                    }
                    dsMap.put(root, pds.getDataSet());
                }
            }
            root.accept(new QueryTreeNodeDeepVisitor(){

                @Override
                protected void deepFirstVisit(QueryTreeNode node) {
                    node.setCostRoleOn(true);
                }
            });
            this.mate.queryWithRoleDown(algoKey, root, roleDownThreshold);
            this.queryWithOrders(algoKey, QueryOrders.defaultOrders(root), root);
            root.accept(new QueryTreeNodeDeepVisitor(){

                @Override
                protected void deepFirstVisit(QueryTreeNode node) {
                    if (!dsMap.containsKey(node) && node.getPeekingDataSet() != null) {
                        dsMap.put(node, node.getPeekingDataSet().getDataSet());
                    }
                }
            });
        }
        this.preJoin(root, dsMap);
        DataSet ret = this.mate.joinAll(root, dsMap);
        if (oi.mo == MixedOrder.mainAndSub || oi.mo == MixedOrder.sub) {
            rm = ret.getRowMeta();
            List<OrderByInfo> allOrderByList = root.getQuery().getAllOrderByList();
            final HashMap<OrderByInfo, Integer> indexMap = new HashMap<OrderByInfo, Integer>(allOrderByList.size());
            int index = 0;
            for (OrderByInfo item : allOrderByList) {
                indexMap.put(item, index++);
            }
            Collections.sort(oi.outerOrderBys, new Comparator<OrderByInfo>(){

                @Override
                public int compare(OrderByInfo o1, OrderByInfo o2) {
                    return (Integer)indexMap.get(o1) - (Integer)indexMap.get(o2);
                }
            });
            String[] orderBys = new String[oi.outerOrderBys.size()];
            int n = oi.outerOrderBys.size();
            for (int i = 0; i < n; ++i) {
                orderBys[i] = oi.outerOrderBys.get(i).toString();
                if (rm.getField(oi.outerOrderBys.get(i).getPropertySegExpress().toString(), false) != null) continue;
                throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"QueryOptimizater_0", (String)"[Outer order]select field must contains order by property %1$s\uff0call=%2$s\uff0cRowMeta=%3$s\u3002", (Object[])new Object[]{oi.outerOrderBys.get(i).getPropertySegExpress(), oi.outerOrderBys, rm}));
            }
            ret = ret.orderBy(orderBys);
        } else if (oi.mo == MixedOrder.main) {
            rm = ret.getRowMeta();
            List<OrderByInfo> allOrderByList = root.getQuery().getAllOrderByList();
            String[] orderBys = new String[allOrderByList.size()];
            boolean validated = true;
            int n = allOrderByList.size();
            for (int i = 0; i < n; ++i) {
                orderBys[i] = allOrderByList.get(i).toString();
                if (rm.getField(allOrderByList.get(i).getPropertySegExpress().toString(), false) != null) continue;
                validated = false;
                break;
            }
            if (validated) {
                ret = ret.orderBy(orderBys);
            }
        }
        return ret;
    }

    private boolean reduceUnnessesaryJoin(QueryTreeNode root) {
        if (!this.opt.isReduceUnnessesaryJoin()) {
            return false;
        }
        AtomicBoolean optimized = new AtomicBoolean(false);
        this.mate.moveUpField(root, optimized);
        return optimized.get();
    }

    private void joinInSameDatabase(QueryTreeNode root) {
        if (!this.opt.isJoinInSameDatabase() || root.isLeaf()) {
            return;
        }
        QueryUtils.joinInSameDatabase(root);
    }

    private void roleOnPK(final String algoKey, QueryTreeNode root) {
        root.accept(new QueryTreeNodeDeepVisitor(){

            @Override
            protected void deepFirstVisit(QueryTreeNode node) {
                if (node.isPkRoleOn()) {
                    PeekingDataSet pds = node.queryPeeking(algoKey, QueryOptimizater.this.roleOnCostThreshold);
                    node.setPeekingDataSet(pds);
                }
            }
        });
    }

    private void roleOnCost(final String algoKey, QueryTreeNode root) {
        if (this.opt.isForcePushEnabled()) {
            for (QueryTreeNode queryTreeNode : root.getChildren()) {
                this.mate.queryWithRoleDown(algoKey, queryTreeNode, this.roleOnCostThreshold);
            }
            root.accept(new QueryTreeNodeDeepVisitor(){

                @Override
                protected void deepFirstVisit(QueryTreeNode node) {
                    QueryOptimizater.this.mate.queryWithRoleUp(algoKey, node, false, true);
                }
            });
            for (QueryTreeNode queryTreeNode : root.getChildren()) {
                this.mate.queryWithRoleDown(algoKey, queryTreeNode, this.roleOnCostThreshold);
            }
            boolean hasPending = false;
            for (QueryTreeNode child : root.getChildren()) {
                if (child.getPeekingDataSet() != null) continue;
                hasPending = true;
                break;
            }
            if (hasPending && (!root.isWithOriginFilter() && (root.getQuery().getQueryParameter().getParams() == null || root.getQuery().getQueryParameter().getParams().length == 0) || this.opt.isForcePushToRoot())) {
                root.accept(new QueryTreeNodeDeepVisitor(){

                    @Override
                    protected void deepFirstVisit(QueryTreeNode node) {
                        node.setCostRoleOn(true);
                    }
                });
                root.accept(new QueryTreeNodeDeepVisitor(){

                    @Override
                    protected void deepFirstVisit(QueryTreeNode node) {
                        QueryOptimizater.this.mate.queryWithRoleUp(algoKey, node, false, true);
                    }
                });
            }
            int n = this.mate.queryWithRoleUp(algoKey, root, true, false);
            this.queryRootWithTop = this.queryRootWithTop || n == root.getChildren().size();
        } else {
            this.mate.queryWithRoleDown(algoKey, root, this.roleOnCostThreshold);
            root.accept(new QueryTreeNodeDeepVisitor(){

                @Override
                protected void deepFirstVisit(QueryTreeNode node) {
                    QueryOptimizater.this.mate.queryWithRoleUp(algoKey, node, true, true);
                }
            });
            this.mate.queryWithRoleDown(algoKey, root, this.roleOnCostThreshold);
        }
    }

    private void preJoin(QueryTreeNode root, Map<QueryTreeNode, DataSet> dsMap) {
        Iterator<QueryTreeNode> iterator = dsMap.keySet().iterator();
        while (iterator.hasNext()) {
            QueryTreeNode next = iterator.next();
            if (!next.getQuery().isExistsSubquery()) continue;
            iterator.remove();
        }
        List<QueryTreeNode> children = root.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            Iterator<QueryTreeNode> childrenIterator = children.iterator();
            while (childrenIterator.hasNext()) {
                if (!childrenIterator.next().getQuery().isExistsSubquery()) continue;
                childrenIterator.remove();
            }
        }
    }

    private DataSet crossDBAggreteIntoSqlAggregate(String algoKey, QueryTreeNode root) {
        int size;
        String[] funcs = this.allCtx.getFuncs();
        AggregateFuncs aggregateFuncs = new AggregateFuncs(funcs);
        Map<String, List<Integer>> listListMap = ORMUtil.groupBy(aggregateFuncs);
        Iterator<Map.Entry<String, List<Integer>>> iterator = listListMap.entrySet().iterator();
        SingleQuery query = root.getQuery();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(query.getAllJoinFilterMap().values());
        int fieldGroupSize = size = listListMap.size();
        int count = 0;
        QFilter genQueryParameterWhereQFilter = query.getGenQueryParameterWhereQFilter();
        Field[] fields = new Field[funcs.length];
        Object[] returnResult = new Object[funcs.length];
        while (iterator.hasNext()) {
            Map.Entry<String, List<Integer>> next = iterator.next();
            List<Integer> fieldIndex = next.getValue();
            AggregateFuncs newAggFunc = ORMUtil.rebuildFuncs(fieldIndex, funcs);
            String queryFields = ORMUtil.generateSelectFields(newAggFunc);
            SingleQuery newQuery = fieldGroupSize > 1 && count >= 1 ? query.optRebuildFields(queryFields, genQueryParameterWhereQFilter) : query.optRebuildFields(queryFields);
            Object[] results = ORMUtil.aggregateBySql(algoKey, newQuery, newAggFunc, new QFilter[]{newQuery.getWhereFilter()});
            this.resetJoinFilter(newQuery.getAllJoinFilterMap(), qFilters);
            String[] aliasFields = newAggFunc.getAliasFields();
            for (int i = 0; i < results.length; ++i) {
                Integer index = fieldIndex.get(i);
                returnResult[index.intValue()] = results[i];
                fields[index.intValue()] = new Field(aliasFields[i], ORMUtil.getDataTypeByValue(results[i]));
            }
            ++count;
        }
        RowMeta rowMeta = new RowMeta(fields);
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(returnResult);
        this.allCtx.setCrossAggregateIntoSql(true);
        return Algo.create((String)algoKey).createDataSet(list, rowMeta);
    }

    private void resetJoinFilter(Map<String, QFilter> newJoinFilterMap, List<QFilter> joinFilters) {
        Iterator<Map.Entry<String, QFilter>> iterator;
        if (newJoinFilterMap == null) {
            return;
        }
        Set<Map.Entry<String, QFilter>> entries = newJoinFilterMap.entrySet();
        if (entries.size() > 0 && (iterator = entries.iterator()).hasNext()) {
            Map.Entry<String, QFilter> next = iterator.next();
            QFilter value = next.getValue();
            String newProperty = value.getProperty().trim();
            boolean exists = false;
            for (QFilter originJoinQFilter : joinFilters) {
                String originProperty = originJoinQFilter.getProperty().trim();
                if (!newProperty.equalsIgnoreCase(originProperty)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                iterator.remove();
            }
        }
    }

    private static class OrderInfo {
        MixedOrder mo;
        List<OrderByInfo> outerOrderBys;

        private OrderInfo() {
        }
    }

    private static enum MixedOrder {
        none,
        main,
        sub,
        mainAndSub;

    }
}

