/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.optimize.QueryTreeNodeVisitor;

class QueryOrders {
    private boolean isEffect;
    private List<QueryTreeNode> orderList;

    static QueryOrders customerOrders(String queryOrders, QueryTreeNode root) {
        return new QueryOrders(queryOrders, root);
    }

    static QueryOrders defaultOrders(QueryTreeNode root) {
        return new QueryOrders(root);
    }

    private QueryOrders(QueryTreeNode root) {
        this.isEffect = true;
        Map<String, QueryTreeNode> map = this.toTreeMap(root);
        this.orderList = new ArrayList<QueryTreeNode>(map.size());
        for (Map.Entry<String, QueryTreeNode> entry : map.entrySet()) {
            this.orderList.add(entry.getValue());
        }
    }

    private QueryOrders(String queryOrders, QueryTreeNode root) {
        if (queryOrders == null) {
            this.isEffect = false;
        } else {
            queryOrders = queryOrders.trim().toLowerCase();
            Map<String, QueryTreeNode> map = this.toTreeMap(root);
            this.orderList = new ArrayList<QueryTreeNode>(map.size());
            String[] orders = queryOrders.split(",");
            for (String order : orders) {
                QueryTreeNode node = map.get(order);
                if (node == null) continue;
                this.orderList.add(node);
                map.remove(order);
            }
            if (this.orderList.isEmpty()) {
                this.isEffect = false;
            } else {
                this.isEffect = true;
                for (Map.Entry entry : map.entrySet()) {
                    this.orderList.add((QueryTreeNode)entry.getValue());
                }
            }
        }
    }

    private Map<String, QueryTreeNode> toTreeMap(QueryTreeNode root) {
        final TreeMap<String, QueryTreeNode> map = new TreeMap<String, QueryTreeNode>();
        root.accept(new QueryTreeNodeVisitor(){

            @Override
            public void visit(QueryTreeNode node) {
                map.put(node.getQuery().getFullObjName(), node);
                for (QueryTreeNode subNode : node.getChildren()) {
                    subNode.accept(this);
                }
            }
        });
        return map;
    }

    public List<QueryTreeNode> getOrderQueryTreeNode() {
        return this.orderList;
    }

    public boolean effect() {
        return this.isEffect;
    }
}

