/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.oql.g.expr;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.ExprList;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.algo.sql.tree.UnresolvedFuncall;
import kd.bos.orm.query.oql.g.expr.SQLInjectionException;
import kd.bos.orm.query.oql.g.visitor.ExprVisitor;

final class SelectFieldsSQLInjectionVisitor
extends ExprVisitor<Object> {
    private static final Set<String> limitFunction = new HashSet<String>();

    SelectFieldsSQLInjectionVisitor() {
    }

    @Override
    public Object defaultVisit(Expr exp, Object context) {
        if (exp.getChildrenCount() > 0) {
            for (Expr child : exp.getChildren()) {
                child.accept((AstVisitor)this, context);
            }
        }
        return null;
    }

    public Object visitExprList(ExprList node, Object context) {
        for (Expr exp : node.getChildren()) {
            exp.accept((AstVisitor)this, context);
        }
        return null;
    }

    public Object visitUnresolvedFuncall(UnresolvedFuncall node, Object context) {
        if (!this.isRightFunctionName(node.getName())) {
            throw new SQLInjectionException(node.toString() + " is not allowed");
        }
        for (Expr param : node.getChildren()) {
            param.accept((AstVisitor)this, context);
        }
        return null;
    }

    public Object visitUnresolvedAttribute(UnresolvedAttribute node, Object context) {
        for (String id : node.getNameParts()) {
            if (this.isRightID(id)) continue;
            throw new SQLInjectionException(node.toString() + " is not allowed");
        }
        return null;
    }

    private boolean isRightFunctionName(String name) {
        if (!this.isRightID(name)) {
            return false;
        }
        if (name.indexOf(46) != -1) {
            return false;
        }
        return !limitFunction.contains(name.toLowerCase());
    }

    private boolean isRightID(String id) {
        return !(id = id.toLowerCase(Locale.ENGLISH)).startsWith("0x") && !id.startsWith("0o") && !id.startsWith("0b");
    }

    static {
        limitFunction.add("bin");
        limitFunction.add("oct");
        limitFunction.add("hex");
        limitFunction.add("unhex");
        limitFunction.add("chr");
    }
}

