/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.privacy;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.db.privacy.model.DBIdQueryModel;
import kd.bos.db.privacy.model.DBPrivacyDataModel;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.privacy.PrivacyFieldInfo;
import kd.bos.orm.query.privacy.TempField;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;

public class PrivacyDataQuery {
    private static Log logger = LogFactory.getLog(PrivacyDataQuery.class);

    public static boolean isPrivacyProperty(String columnName, String tableName) {
        if (!PrivacyDataCenterManager.isEnable()) {
            return false;
        }
        if (StringUtils.isEmpty(columnName) || StringUtils.isEmpty(tableName)) {
            return false;
        }
        DBPrivacyDataModel model = new DBPrivacyDataModel();
        model.setTableName(tableName);
        model.setFiledName(columnName);
        return PrivacyDataCenterManager.getQueryService().isEncryptField(model, 0);
    }

    public static List<Object> getIdsFromPrivacyCenter(QFilter filter, QContext ctx, String rootName) {
        IDataEntityType entityType;
        if (!PrivacyDataCenterManager.isEnable()) {
            return Collections.emptyList();
        }
        String filterProperty = filter.getProperty();
        int dotIndex = filterProperty.lastIndexOf(".");
        if (dotIndex == -1) {
            entityType = ctx.getEntityItem((String)rootName).entityType;
        } else {
            String fullObjectName = filterProperty.substring(0, dotIndex);
            if (!filterProperty.startsWith(rootName + ".")) {
                fullObjectName = rootName + "." + fullObjectName;
            }
            entityType = ctx.getEntityItem((String)fullObjectName).entityType;
        }
        DBRoute dbRoute = new DBRoute(entityType.getDBRouteKey());
        List<DBPrivacyDataModel> params = PrivacyDataQuery.buildParams(rootName, filter, ctx);
        return PrivacyDataCenterManager.getQueryService().hashQuery(dbRoute, params);
    }

    public static Map<String, Map<String, Object>> getValues(DBRoute dbRoute, String tableName, List<Object> ids, Set<String> fields, Set<String> multiLangFields) throws Exception {
        if (!PrivacyDataCenterManager.isEnable()) {
            return Collections.emptyMap();
        }
        DBIdQueryModel queryModel = new DBIdQueryModel();
        queryModel.setFields(fields);
        queryModel.setIds(ids);
        if (multiLangFields != null && !multiLangFields.isEmpty()) {
            queryModel.setMultiField(multiLangFields);
            queryModel.setLocaleId(Lang.get().toString());
        }
        queryModel.setTableName(tableName);
        return PrivacyDataCenterManager.getQueryService().idQuery(dbRoute, queryModel);
    }

    public static Map<String, Map<String, Map<String, Object>>> getValues(DBRoute dbRoute, Map<String, DBIdQueryModel> queryModel) throws Exception {
        if (!PrivacyDataCenterManager.isEnable()) {
            return Collections.emptyMap();
        }
        return PrivacyDataCenterManager.getQueryService().idQuery(dbRoute, new ArrayList<DBIdQueryModel>(queryModel.values()));
    }

    public static Map<String, Map<String, Object>> getValues(DBRoute dbRoute, String tableName, List<Object> ids, Set<String> fields, String localeId) throws Exception {
        if (!PrivacyDataCenterManager.isEnable()) {
            return Collections.emptyMap();
        }
        DBIdQueryModel queryModel = new DBIdQueryModel();
        queryModel.setFields(fields);
        queryModel.setIds(ids);
        queryModel.setLocaleId(localeId);
        queryModel.setTableName(tableName);
        return PrivacyDataCenterManager.getQueryService().idQuery(dbRoute, queryModel);
    }

    public static Map<String, PrivacyFieldInfo> getPrivacyFields(RowMeta meta, PropertyField[] selectFields, String rootName, String pkAlias, QContext ctx) {
        if (!PrivacyDataCenterManager.isEnable()) {
            return Collections.emptyMap();
        }
        HashMap<String, PrivacyFieldInfo> tableToField = new HashMap<String, PrivacyFieldInfo>();
        ArrayList<DBPrivacyDataModel> params = new ArrayList<DBPrivacyDataModel>();
        HashMap<String, IDataEntityType> cache = new HashMap<String, IDataEntityType>();
        HashMap<String, TempField> allFields = new HashMap<String, TempField>();
        for (PropertyField field : selectFields) {
            DBPrivacyDataModel model = new DBPrivacyDataModel();
            String fieldName = field.getFullName();
            if (field.isExpress()) {
                Collection<PropertyField> propertyFields = field.getPropertySegExpress().getPropertyFields();
                if (propertyFields == null || propertyFields.size() == 0) continue;
                PropertyField propertyField = propertyFields.iterator().next();
                fieldName = propertyField.getFullName();
            }
            String tableName = ORMUtil.getTableName(ctx, rootName, fieldName);
            String columnName = field.getField();
            if (StringUtils.isEmpty(columnName)) {
                columnName = ORMUtil.getColumnName(cache, rootName, fieldName);
            }
            if (StringUtils.isEmpty(tableName) || StringUtils.isEmpty(columnName)) continue;
            tableName = tableName.toLowerCase(Locale.ENGLISH);
            columnName = columnName.toLowerCase(Locale.ENGLISH);
            model.setTableName(tableName);
            model.setFiledName(columnName);
            params.add(model);
            TempField tempField = new TempField();
            tempField.setFiled(meta.getField(field.getAlias()));
            String currentFieldPkAlias = PrivacyDataQuery.getPkAlias(ctx, fieldName, selectFields);
            if (StringUtils.isEmpty(currentFieldPkAlias)) continue;
            if (field.isMultiLangProperty()) {
                tempField.setMultiLang(true);
            }
            if (field.getPeropertyType() != null && field.isGLField()) {
                tempField.setGLproperty(true);
            }
            tempField.setPkAlias(currentFieldPkAlias);
            allFields.put(tableName + "#" + columnName, tempField);
        }
        List encryptFields = PrivacyDataCenterManager.getQueryService().isEncryptField(params, 0);
        if (!CollectionUtils.isEmpty(encryptFields)) {
            for (DBPrivacyDataModel model : encryptFields) {
                PrivacyFieldInfo privacyFieldInfo = (PrivacyFieldInfo)tableToField.get(model.getTableName());
                TempField tempField = (TempField)allFields.get(model.getTableName() + "#" + model.getFiledName());
                if (tempField == null) continue;
                if (privacyFieldInfo == null) {
                    privacyFieldInfo = new PrivacyFieldInfo();
                    privacyFieldInfo.setRootTablePkAlias(pkAlias);
                    HashMap<String, TempField> map = new HashMap<String, TempField>();
                    map.put(model.getFiledName(), tempField);
                    if (tempField.isMultiLang()) {
                        privacyFieldInfo.setMultiLangColumnToField(map);
                    } else {
                        privacyFieldInfo.setColumnToField(map);
                    }
                    privacyFieldInfo.setPkAlias(tempField.getPkAlias());
                    privacyFieldInfo.setTableName(model.getTableName());
                } else {
                    Map<String, TempField> columnToField = tempField.isMultiLang() ? privacyFieldInfo.getMultiLangColumnToField() : privacyFieldInfo.getColumnToField();
                    if (columnToField == null) {
                        columnToField = new HashMap<String, TempField>();
                    }
                    columnToField.put(model.getFiledName(), tempField);
                    if (tempField.isMultiLang()) {
                        privacyFieldInfo.setMultiLangColumnToField(columnToField);
                    } else {
                        privacyFieldInfo.setColumnToField(columnToField);
                    }
                }
                tableToField.put(model.getTableName(), privacyFieldInfo);
            }
        }
        return tableToField;
    }

    public static String getPkAlias(PropertyField[] fields, IDataEntityType type) {
        String pkName = type.getPrimaryKey().getName();
        for (PropertyField field : fields) {
            String fieldName = field.getName();
            if (field.getEntityType() == null || !field.getEntityType().getExtendName().equals(type.getExtendName()) || !pkName.equals(fieldName)) continue;
            return field.getAlias();
        }
        return null;
    }

    public static boolean handlPrivacyFilterPropery(PropertyField field, QFilter filter, QContext ctx, String rootObjName) {
        try {
            if (ORMConfig.PRIVACY_ENABLE.getBoolean() && PrivacyDataQuery.isPrivacy(field, filter, ctx, rootObjName)) {
                PrivacyDataQuery.handlePrivacyProperty(filter, ctx, rootObjName);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (e instanceof KDException && PrivacyDataConstant.WARNCODE.equals((Object)((KDException)e).getErrorCode())) {
                throw e;
            }
            logger.error("isprivacy error", (Throwable)e);
            return false;
        }
    }

    private static String getPkAlias(QContext ctx, String fullName, PropertyField[] fields) {
        String fullObjectName = ORMUtil.getFullObjectName(ctx.getMainEntityItem().getFullObjectName(), fullName);
        EntityItem entityItem = ctx.getEntityItem(fullObjectName);
        if (entityItem != null) {
            IDataEntityType entityType = entityItem.entityType;
            return PrivacyDataQuery.getPkAlias(fields, entityType);
        }
        return null;
    }

    private static boolean isPrivacy(PropertyField field, QFilter filter, QContext ctx, String rootName) {
        boolean isPrivacy;
        if (!PrivacyDataCenterManager.isEnable()) {
            return false;
        }
        String localProperty = filter.getProperty();
        String cp = filter.getCP();
        if (cp.equalsIgnoreCase("ftlike") || cp.equalsIgnoreCase("match")) {
            String[] properties;
            for (String pro : properties = filter.getProperties()) {
                if (!PrivacyDataQuery.isPrivacyProperty(ORMUtil.getColumnName(ctx, rootName, pro), ORMUtil.getTableName(ctx, rootName, pro))) continue;
                throw new KDException(PrivacyDataConstant.WARNCODE, new Object[]{ResManager.loadKDString((String)"Only support\uff1a[equals,not equals,in,not in,like,not like]", (String)"PrivacyDataQuery_1", (String)"bos-ormengine", (Object[])new Object[0])});
            }
            return false;
        }
        if (field == null) {
            return false;
        }
        if (field.isExpress()) {
            Collection<PropertyField> propertyFields = field.getPropertySegExpress().getPropertyFields();
            if (propertyFields == null || propertyFields.size() == 0) {
                return false;
            }
            PropertyField propertyField = propertyFields.iterator().next();
            localProperty = propertyField.getFullName();
        }
        if (!(!(isPrivacy = PrivacyDataQuery.isPrivacyProperty(ORMUtil.getColumnName(ctx, rootName, localProperty), ORMUtil.getTableName(ctx, rootName, localProperty))) || cp.equalsIgnoreCase("=") || cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("!=") || cp.equalsIgnoreCase("<>") || cp.equalsIgnoreCase("not in"))) {
            logger.error("the privacy field " + localProperty + " only support 'equals','in','not equals' or 'not in' operation");
            throw new KDException(PrivacyDataConstant.WARNCODE, new Object[]{ResManager.loadKDString((String)"Privacy field only be accurate matching", (String)"PrivacyDataQuery_0", (String)"bos-ormengine", (Object[])new Object[0])});
        }
        return isPrivacy;
    }

    private static void handlePrivacyProperty(QFilter filter, QContext ctx, String rootName) {
        String property = filter.getProperty();
        List<Object> ids = PrivacyDataQuery.getIdsFromPrivacyCenter(filter, ctx, rootName);
        int dotIndex = property.lastIndexOf(".");
        String idProperty = dotIndex == -1 ? "id" : property.substring(0, dotIndex) + ".id";
        logger.info("privacy QFilter to be replaced ,origin filter property :" + filter.getProperty() + ",operation:" + filter.getCP() + ",the new property is " + idProperty);
        filter.__setProperty(idProperty);
        if (filter.getCP().equalsIgnoreCase("=") || filter.getCP().equalsIgnoreCase("in")) {
            filter.__setCP("in");
        } else if (filter.getCP().equalsIgnoreCase("!=") || filter.getCP().equalsIgnoreCase("not in")) {
            filter.__setCP("not in");
        } else {
            filter.__setCP("in");
        }
        filter.__setValue(ids);
    }

    private static List<DBPrivacyDataModel> buildParams(String rootName, QFilter filter, QContext ctx) {
        Object[] paramsArray;
        if (!PrivacyDataCenterManager.isEnable()) {
            return Collections.emptyList();
        }
        ArrayList<DBPrivacyDataModel> params = new ArrayList<DBPrivacyDataModel>(16);
        Object values = filter.getValue();
        if (values.getClass().isArray()) {
            int c = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(c);
            for (int i = 0; i < c; ++i) {
                set.add(Array.get(values, i));
            }
            c = set.size();
            HugeInConfig.limitInSize(c);
            paramsArray = set.toArray(new Object[c]);
        } else if (values instanceof Set) {
            paramsArray = ((Set)values).toArray(new Object[((Set)values).size()]);
        } else if (values instanceof Collection) {
            HashSet set = new HashSet((Collection)values);
            int c = set.size();
            HugeInConfig.limitInSize(c);
            paramsArray = set.toArray(new Object[c]);
        } else if (values instanceof Iterable) {
            HashSet set = new HashSet(16);
            for (Object item : (Iterable)values) {
                set.add(item);
            }
            int c = set.size();
            HugeInConfig.limitInSize(c);
            paramsArray = set.toArray(new Object[c]);
        } else {
            paramsArray = new Object[]{values};
        }
        PropertyField field = filter.__getParsedProperty(ctx);
        String column = field.getField();
        String alias = ORMUtil.getTableName(ctx, rootName, filter.getProperty());
        boolean multiLangProperty = field.isMultiLangProperty();
        String localId = Lang.get().toString();
        for (Object value : paramsArray) {
            DBPrivacyDataModel model = new DBPrivacyDataModel();
            model.setHashValue(String.valueOf(value));
            if (multiLangProperty) {
                model.setLocaleId(localId);
            }
            model.setTableName(alias);
            model.setFiledName(column);
            params.add(model);
        }
        return params;
    }
}

