/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.privacy;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.privacy.TempField;
import kd.bos.orm.util.StringUtils;

public class PrivacyDataRow
extends AbstractRow {
    private static Log logger = LogFactory.getLog(PrivacyDataRow.class);
    private RowMeta rowMeta;
    private Row row;
    private Map<String, TempField> privacyColumnToField;
    private Map<String, Map<String, Object>> convertValue = new HashMap<String, Map<String, Object>>();
    private Map<String, String> privacyPropertyToColumn;
    private Map<String, TempField> privacyPropertyToField = new HashMap<String, TempField>();

    public PrivacyDataRow(Row row, RowMeta rowMeta, Map<String, Object> privacyColumnValue, Map<String, TempField> privacyColumnToField) {
        this.row = row;
        this.rowMeta = rowMeta;
        this.privacyColumnToField = privacyColumnToField;
        this.convertField(privacyColumnToField);
        this.convertValue(privacyColumnValue);
    }

    public Object[] values() {
        int valueSize = this.rowMeta.getFieldCount();
        Object[] rowValues = new Object[valueSize];
        for (int i = 0; i < valueSize; ++i) {
            rowValues[i] = this.get(i);
        }
        return rowValues;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public int size() {
        return this.rowMeta.getFieldCount();
    }

    public Object get(int i) {
        Field field;
        String column;
        if (this.convertValue != null && !this.convertValue.isEmpty() && !StringUtils.isEmpty(column = this.privacyPropertyToColumn.get((field = this.rowMeta.getField(i)).getAlias()))) {
            TempField tempField = this.privacyPropertyToField.get(field.getAlias());
            Map<String, Object> valueMap = this.convertValue.get(column);
            if (valueMap != null && !valueMap.isEmpty()) {
                if (tempField.isMultiLang()) {
                    return this.handleMultiLangFieldValue(tempField, valueMap, this.row, field, i);
                }
                Object value = valueMap.entrySet().iterator().next().getValue();
                if (value != null && !StringUtils.isEmpty(String.valueOf(value))) {
                    return value;
                }
            }
            logger.warn("the decode value of privacy field \u3010" + field.getAlias() + "\u3011 is null");
        }
        return this.row.get(i);
    }

    private Object handleMultiLangFieldValue(TempField tempField, Map<String, Object> valueMap, Row row, Field field, int i) {
        String language = Lang.get().toString();
        Object value = valueMap.get(language);
        if (value == null || StringUtils.isEmpty(String.valueOf(value))) {
            if (tempField.isGLproperty()) {
                Object gLang = valueMap.get("GLang");
                if (gLang != null && !StringUtils.isEmpty(String.valueOf(gLang))) {
                    return gLang;
                }
                logger.warn("the decode glang value of privacy field \u3010" + field.getAlias() + "\u3011 is null");
                return row.get(i);
            }
            logger.warn("the decode " + language + " value of privacy field \u3010" + field.getAlias() + "\u3011 is null");
            return row.get(i);
        }
        return value;
    }

    private void convertField(Map<String, TempField> privacyColumnToField) {
        if (privacyColumnToField != null && !privacyColumnToField.isEmpty()) {
            this.privacyPropertyToColumn = new HashMap<String, String>(16);
            for (Map.Entry<String, TempField> next : privacyColumnToField.entrySet()) {
                String column = next.getKey();
                TempField tempField = next.getValue();
                String alias = tempField.getFiled().getAlias();
                this.privacyPropertyToColumn.put(alias, column);
                this.privacyPropertyToField.put(alias, tempField);
            }
        }
    }

    private void convertValue(Map<String, Object> privacyColumnValue) {
        for (Map.Entry<String, Object> next : privacyColumnValue.entrySet()) {
            String filedMultiLang = next.getKey();
            String[] filedLang = filedMultiLang.split("#\\$");
            Map<String, Object> valueMap = this.convertValue.get(filedLang[0]);
            if (valueMap == null) {
                valueMap = new HashMap<String, Object>();
                this.convertValue.put(filedLang[0], valueMap);
            }
            if (filedLang.length <= 1) {
                valueMap.put("", next.getValue());
                continue;
            }
            valueMap.put(filedLang[1], next.getValue());
        }
    }
}

