/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.sequence;

import java.sql.ResultSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.sequence.Sequence;

public class MySqlSequence
extends Sequence {
    private static final long auto_from_value = 100001L;

    public MySqlSequence(DBRoute dbRoute) {
        super(dbRoute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] getSequence(T[] a, String key, int count) {
        try (TXHandle h = TX.requiresNew((String)"getSequence");){
            long seq = this.getCurSequence(key);
            this.updateSequence(key, seq + (long)count);
            if (a.getClass().getComponentType() == Integer.class) {
                Integer[] seqList = new Integer[count];
                for (int i = 0; i < count; ++i) {
                    seqList[i] = (int)(seq + (long)i);
                }
                Object[] i = seqList;
                return i;
            }
            Long[] seqList = new Long[count];
            for (int i = 0; i < count; ++i) {
                seqList[i] = seq + (long)i;
            }
            Object[] objectArray = seqList;
            return objectArray;
        }
    }

    private long getCurSequence(String key) {
        String sql = "/*dialect*/select fseq from sequence where fname =?";
        return (Long)DB.query((DBRoute)this.dbRoute, (String)sql, (Object[])new Object[]{key}, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 100001L;
            }
        });
    }

    private void updateSequence(String key, long seq) {
        String sql = "/*dialect*/update sequence set fseq=? where fname=?";
        Object[] params = new Object[]{seq, key};
        if (DB.update((DBRoute)this.dbRoute, (String)sql, (Object[])params) == 0) {
            sql = "/*dialect*/insert into sequence(fname,fseq) values(?,?)";
            params = new Object[]{key, seq};
            DB.update((DBRoute)this.dbRoute, (String)sql, (Object[])params);
        }
    }

    private void ensureCreateSequence() {
        String sql = "/*dialect*/CREATE TABLE IF NOT EXISTS `sequence`(`fname` varchar(255) NOT NULL,`fseq` INT NOT NULL,PRIMARY KEY (`fname`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
        DB.execute((DBRoute)this.dbRoute, (String)sql, null);
    }

    @Override
    public boolean repairMaxSeq() {
        return false;
    }

    @Override
    public void repairMaxValue(String seqName, String tableName, long seqValue) {
    }
}

