/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.entity.DataEntityWalkerEventArgs;
import kd.bos.dataentity.entity.DataEntityWalkerListner;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.SecureExceptionUtil;
import kd.bos.id.ID;
import kd.bos.orm.sequence.IDServiceSequence;
import kd.bos.orm.sequence.Sequence;
import kd.bos.orm.sequence.SetValueHandler;

public class SequenceReader {
    private static final int SYSTEM_MAX_VALUE = 100000;
    private final Sequence sequence;
    private DBRoute dbRoute;

    public SequenceReader() {
        this.sequence = IDServiceSequence.instance;
    }

    public SequenceReader(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
        this.sequence = IDServiceSequence.instance;
    }

    public static UUID[] getGuidSequence(int len) {
        UUID[] ids = new UUID[len];
        for (int i = 0; i < len; ++i) {
            ids[i] = UUID.randomUUID();
        }
        return ids;
    }

    public static String[] getStringSequence(int len) {
        return ID.genStringIds((int)len);
    }

    private boolean existRecodes(String tableName) {
        String sql = "select top 1 1 from " + tableName;
        return (Boolean)DB.query((DBRoute)this.dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1) > 0;
                }
                return false;
            }
        });
    }

    private <T> void setPropValue(List<Object> toDoList, ISimpleProperty pkProperty, T[] pkValues) {
        int i = 0;
        for (Object item : toDoList) {
            pkProperty.setValue(item, pkValues[i]);
            ++i;
        }
    }

    private void setPropValue(List<Object> toDoList, ISimpleProperty pkProperty, String[] pkValues) {
        int i = 0;
        for (Object item : toDoList) {
            pkProperty.setValue(item, (Object)pkValues[i]);
            ++i;
        }
    }

    private void setPropValue(List<Object> toDoList, ISimpleProperty pkProperty, UUID[] pkValues) {
        int i = 0;
        for (Object item : toDoList) {
            pkProperty.setValue(item, (Object)pkValues[i]);
            ++i;
        }
    }

    private <T> void setPrimaryKey(Object[] dataEntities, ISimpleProperty pkProperty, String tableName) {
        ArrayList<Object> toDoList = new ArrayList<Object>();
        for (Object dataEntity : dataEntities) {
            Object currentValue;
            if (dataEntity == null || (currentValue = pkProperty.getValueFast(dataEntity)) != null && (!(currentValue instanceof String) || ((String)currentValue).length() != 0) && (!(currentValue instanceof Number) || ((Number)currentValue).longValue() != 0L)) continue;
            toDoList.add(dataEntity);
        }
        if (toDoList.size() > 0) {
            Class type = pkProperty.getPropertyType();
            if (type == Integer.TYPE) {
                this.setPropValue(toDoList, pkProperty, this.getSequences(new Integer[0], tableName, toDoList.size()));
            } else if (type == Long.TYPE) {
                this.setPropValue(toDoList, pkProperty, this.getSequences(new Long[0], tableName, toDoList.size()));
            } else if (type == String.class) {
                this.setPropValue((List<Object>)toDoList, pkProperty, SequenceReader.getStringSequence(toDoList.size()));
            } else if (type == UUID.class) {
                this.setPropValue((List<Object>)toDoList, pkProperty, SequenceReader.getGuidSequence(toDoList.size()));
            }
        }
    }

    private static String getSequenceName(IDataEntityType dt) {
        return dt.getName();
    }

    private <T> void repairMaxSeq(T[] iret, T[] a, String key, int count) {
        if (this.existRecodes(key)) {
            String seqName = this.sequence.getSequenceNameByKey(key);
            try {
                this.sequence.repairMaxValue(seqName, key, 100001L);
            }
            catch (SQLException e) {
                throw SecureExceptionUtil.wrapSQLException((SQLException)e);
            }
            iret = this.sequence.getSequence(a, key, count);
        }
    }

    public <T> T[] getSequences(T[] a, String tableName, int count) {
        T[] iret = this.sequence.getSequence(a, tableName, count);
        if (this.sequence.repairMaxSeq()) {
            if (a.getClass().getComponentType() == Integer.class) {
                if ((Integer)iret[0] == 100001) {
                    this.repairMaxSeq(iret, a, tableName, count);
                }
            } else if ((Long)iret[0] == 100001L) {
                this.repairMaxSeq(iret, a, tableName, count);
            }
            return SetValueHandler.getValue(a, iret);
        }
        return iret;
    }

    public void autoSetPrimaryKey(Object[] dataEntities, IDataEntityType entityType) {
        this.autoSetPrimaryKey(Arrays.asList(dataEntities), entityType);
    }

    public void autoSetPrimaryKey(List<? extends Object> dataEntities, IDataEntityType entityType) {
        DataEntityWalkerListner action = new DataEntityWalkerListner(){

            public void callback(DataEntityWalkerEventArgs e) {
                ISimpleProperty pkProperty = e.getDataEntityType().getPrimaryKey();
                if (pkProperty != null) {
                    SequenceReader.this.setPrimaryKey(e.toArray(), pkProperty, e.getDataEntityType().getAlias());
                }
            }
        };
        OrmUtils.DataEntityWalker(dataEntities, (IDataEntityType)entityType, (DataEntityWalkerListner)action, (boolean)true);
    }
}

