/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bdsync.BDSync;
import kd.bos.bdsync.BDSyncCheckMsg;
import kd.bos.bdsync.BDSyncStatusType;
import kd.bos.bdsync.BDSyncThreadContext;
import kd.bos.bdsync.DBSyncStatusMsg;
import kd.bos.bdsync.ErrorRowInfo;
import kd.bos.bdsync.check.BDSyncChecker;
import kd.bos.bdsync.resync.BDReSync;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.dts.log.DtsStatusQuery;
import kd.bos.dts.log.query.SyncStatusInfo;
import kd.bos.dts.retry.Retry;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class BDSyncImpl
implements BDSync {
    private static Map<String, Boolean> typeEnableMap = new ConcurrentHashMap<String, Boolean>(5);

    private static void initEnableTypeMap() {
        typeEnableMap.clear();
        String enableQuerytypes = System.getProperty("bdSync.query.enable.types");
        if (StringUtils.isNotEmpty((CharSequence)enableQuerytypes)) {
            for (String type : enableQuerytypes.split(",")) {
                typeEnableMap.put(type.toLowerCase(), true);
            }
        }
    }

    public boolean isAvailable(String entityNumber, DBRoute destinationRoute) {
        if (this.isBDSyncQueryEnable() && DtsAccountPower.isAccountDtsEnable() && this.isFinished(entityNumber, destinationRoute)) {
            DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
            return ORMConfiguration.isBasedata((IDataEntityType)entityType);
        }
        return false;
    }

    private boolean isFinished(String entityNumber, DBRoute destinationRoute) {
        DestinationTransRule[] destinationRules = DataSyncConfigCache.get().getWorkingDestinationType(entityNumber);
        if (destinationRules != null && destinationRules.length > 0) {
            for (DestinationTransRule rule : destinationRules) {
                if (DestinationType.BUSINESSDB != rule.getType() || !rule.getRegion().equals(destinationRoute.getRouteKey())) continue;
                return true;
            }
        }
        return false;
    }

    public DBSyncStatusMsg getBDSyncStatusMsg(String entityNumber, DBRoute destinationRoute) {
        String status;
        if (!DtsAccountPower.isAccountDtsEnable()) {
            return new DBSyncStatusMsg(BDSyncStatusType.FAILED, "DTS is not enable.");
        }
        if (this.isFinished(entityNumber, destinationRoute)) {
            return new DBSyncStatusMsg(BDSyncStatusType.FINISHED, "finished");
        }
        SyncStatusInfo info = DtsStatusQuery.get().queryLastSyncStatusInfo(entityNumber, "basetablebroadcast", destinationRoute.getRouteKey(), DestinationType.BUSINESSDB.getName());
        if (info != null && ("exception".equals(status = info.getSyncStatus()) || "exception_init".equals(status))) {
            return new DBSyncStatusMsg(BDSyncStatusType.FAILED, info.getExceptionInfo());
        }
        return new DBSyncStatusMsg(BDSyncStatusType.RUNNING, "Preparing data ...");
    }

    private boolean isBDSyncQueryEnable() {
        String queryType;
        if ("true".equals(System.getProperty("bdSync.query.enable", "false")) && StringUtils.isNotEmpty((CharSequence)(queryType = BDSyncThreadContext.getQueryType()))) {
            return typeEnableMap.containsKey(queryType.toLowerCase());
        }
        return false;
    }

    public BDSyncCheckMsg check(String entityNumber, DBRoute destinationRoute) {
        return BDSyncChecker.check(entityNumber, destinationRoute);
    }

    public void repairErrorRow(String entityNumber, DBRoute destinationRoute, List<ErrorRowInfo> errorInfos) {
        if (errorInfos.isEmpty()) {
            return;
        }
        ArrayList<Object> retryPks = new ArrayList<Object>(errorInfos.size());
        for (ErrorRowInfo info : errorInfos) {
            retryPks.add(info.getRelationFieldValue());
        }
        DestinationTransRule destinationRule = null;
        DestinationTransRule[] destinationRules = DataSyncConfigCache.get().getEntitySyncDestinationType(entityNumber);
        if (destinationRules != null && destinationRules.length > 0) {
            for (DestinationTransRule rule : destinationRules) {
                if (DestinationType.BUSINESSDB != rule.getType() || !rule.getRegion().equals(destinationRoute.getRouteKey())) continue;
                destinationRule = rule;
                break;
            }
        }
        if (destinationRule == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{"No DestinationTransRule can be queried through entityNumber=" + entityNumber + " and destinationRoute=" + destinationRoute.getRouteKey() + "."});
        }
        Retry.get().retry(destinationRule, entityNumber, retryPks);
    }

    public void reSync(String entityNumber, DBRoute destinationRule) {
        BDReSync.reSyncDtsConfig(entityNumber, destinationRule.getRouteKey());
    }

    static {
        BDSyncImpl.initEnableTypeMap();
        ConfigurationUtil.observeChange((String)"bdSync.query.enable.types", (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                BDSyncImpl.initEnableTypeMap();
            }
        });
    }
}

