/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.bdsync.init.table.AbstractTableCreater;
import kd.bos.bdsync.init.table.TableCreaterFactory;
import kd.bos.bdsync.init.table.hybrid.Table;
import kd.bos.bdsync.init.table.hybrid.execute.Executor;
import kd.bos.bdsync.init.table.hybrid.execute.Executors;
import kd.bos.bdsync.init.table.hybrid.load.Loader;
import kd.bos.bdsync.init.table.hybrid.load.Loaders;
import kd.bos.bdsync.sql.SqlInfo;
import kd.bos.bdsync.sql.SqlInfoContext;
import kd.bos.bdsync.sql.SqlInfoType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.RowInfo;
import kd.bos.dts.init.AbstractInitialize;
import kd.bos.dts.rateofprogress.Rateofprogress;
import kd.bos.dts.rateofprogress.RateofprogressFactory;
import kd.bos.dts.rateofprogress.RateofprogressInfo;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.util.ConfigurationUtil;

public class BDSyncInitialize
extends AbstractInitialize {
    private static boolean useKsql = false;

    public BDSyncInitialize(DestinationTransRule ruleType) {
        super(ruleType);
    }

    public void initCreateEntityMeta(SyncConfigInfo scinfo) {
        String entityKey;
        Rateofprogress rateofprogress;
        RateofprogressInfo rateInfo;
        DBRoute destinationRoute = DBRoute.of((String)scinfo.getRegion());
        String entityNumber = scinfo.getEntitynumber();
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        DBRoute sourceRoute = DBRoute.of((String)entityType.getDBRouteKey());
        if (DB.isUseTheSameDatabase((String[])new String[]{sourceRoute.getRouteKey(), destinationRoute.getRouteKey()})) {
            throw new KDException(BosErrorCode.unsupportedConfigType, new Object[]{"The target dbRoute is the same database as the source dbRoute\uff01"});
        }
        boolean isNeedCreate = true;
        String timingSequenceField = scinfo.getTimingSequenceField();
        if (timingSequenceField != null && timingSequenceField.length() > 0 && (rateInfo = (rateofprogress = RateofprogressFactory.get((String)(entityKey = DtsUtils.getEntitySplitKey((String)entityNumber, (String)DestinationType.getType((String)scinfo.getDestinationtype()).getName(), (String)scinfo.getRegion(), (String)scinfo.getMappingrule())))).getRatePosition()) != null && (rateInfo.getLowObject() != null || rateInfo.getHighObject() != null)) {
            isNeedCreate = false;
        }
        if (isNeedCreate) {
            DBType destinationDbtype;
            Set tables = DataSyncConfigCache.get().getTableNamesByEntityNumber(entityNumber);
            DBType sourceDbtype = DB.getDBType((DBRoute)sourceRoute);
            if (sourceDbtype == (destinationDbtype = DB.getDBType((DBRoute)destinationRoute)) && !useKsql) {
                AbstractTableCreater tableCreater = TableCreaterFactory.get(sourceDbtype);
                tableCreater.dropTable(tables, sourceRoute, destinationRoute);
                tableCreater.createTable(tables, sourceRoute, destinationRoute);
                tableCreater.createIndex(tables, sourceRoute, destinationRoute);
            } else {
                Loader loader = Loaders.get(sourceDbtype);
                ArrayList<Table> tableInfos = new ArrayList<Table>(tables.size());
                for (String table : tables) {
                    Table t = loader.loadTable(sourceRoute.getRouteKey(), table);
                    if (t == null) continue;
                    tableInfos.add(t);
                }
                Executor executor = Executors.getKSQLExecutor();
                String destinationRouteKey = destinationRoute.getRouteKey();
                for (String table : tables) {
                    executor.dropTable(destinationRouteKey, table);
                }
                for (Table tableInfo : tableInfos) {
                    executor.createTable(destinationRouteKey, tableInfo);
                }
            }
        }
    }

    public void deleteEntity(SyncConfigInfo compare) {
        DBType destinationDbtype;
        DBRoute destinationRoute = DBRoute.of((String)compare.getRegion());
        String entityNumber = compare.getEntitynumber();
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        DBRoute sourceRoute = DBRoute.of((String)entityType.getDBRouteKey());
        Set tables = DataSyncConfigCache.get().getTableNamesByEntityNumber(entityNumber);
        DBType sourceDbtype = DB.getDBType((DBRoute)sourceRoute);
        if (sourceDbtype == (destinationDbtype = DB.getDBType((DBRoute)destinationRoute)) && !useKsql) {
            AbstractTableCreater tableCreater = TableCreaterFactory.get(sourceDbtype);
            tableCreater.dropTable(tables, sourceRoute, destinationRoute);
        } else {
            Executor executor = Executors.getKSQLExecutor();
            for (String table : tables) {
                executor.dropTable(destinationRoute.getRouteKey(), table);
            }
        }
        String timingSequenceField = compare.getTimingSequenceField();
        if (timingSequenceField != null && timingSequenceField.length() > 0) {
            String entityKey = DtsUtils.getEntitySplitKey((String)entityNumber, (String)DestinationType.getType((String)compare.getDestinationtype()).getName(), (String)compare.getRegion(), (String)compare.getMappingrule());
            RateofprogressFactory.get((String)entityKey).clear();
        }
    }

    protected int getBatchSize() {
        return Integer.getInteger("dts.bdsync.init.batchsize", 1000);
    }

    protected void deleteEntityFileds(SyncConfigCompareInfo compare, String deleteFileds) {
    }

    public void doTransmitData(List<RowInfo> esconsumers) {
        DBRoute route = DBRoute.of((String)this.region);
        SqlInfoContext sqlInfoContext = new SqlInfoContext(esconsumers, SqlInfoType.INIT, route);
        for (SqlInfo sqlInfo : sqlInfoContext.getSqlInfoList()) {
            DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
            Throwable throwable = null;
            try {
                TXHandle h = TX.requiresNew((String)"BDSyncInitialize");
                Throwable throwable2 = null;
                try {
                    if (sqlInfo.getSqlBuilder() != null) {
                        DB.execute((DBRoute)route, (SqlBuilder)sqlInfo.getSqlBuilder());
                        continue;
                    }
                    DB.executeBatch((DBRoute)route, (String)sqlInfo.getSql(), sqlInfo.getParams());
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (h == null) continue;
                    if (throwable2 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    h.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (context == null) continue;
                if (throwable != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                context.close();
            }
        }
    }

    static {
        ConfigurationUtil.observeBoolean((String)"dts.bdsync.init.useksql", (boolean)false, v -> {
            useKsql = v;
        });
    }
}

