/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.init.table;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.bdsync.init.table.AbstractTableCreater;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;

public class OracleTableCreater
extends AbstractTableCreater {
    @Override
    public void createTable(Set<String> tables, DBRoute sourceRoute, DBRoute destinationRoute) {
        for (String table : tables) {
            table = table.toUpperCase();
            this.executeSql(destinationRoute, this.getDialectSql(this.getTableStructure(table, sourceRoute)));
        }
    }

    @Override
    public void createIndex(Set<String> tables, DBRoute sourceRoute, DBRoute destinationRoute) {
        for (String table : tables) {
            table = table.toUpperCase();
            for (String indexStructure : this.getIndexStructures(table, sourceRoute)) {
                this.executeSql(destinationRoute, this.getDialectSql(indexStructure));
            }
        }
    }

    private String getTableStructure(final String table, DBRoute sourceRoute) {
        String likeTable = DB.getOriginalsnapTableNameIfShardingTable((String)table).toUpperCase();
        String sql = "SELECT DBMS_METADATA.GET_DDL('TABLE','" + likeTable + "') FROM DUAL";
        return (String)DB.query((DBRoute)sourceRoute, (String)this.getDialectSql(sql), null, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String sourceTableStructure = null;
                while (rs.next()) {
                    sourceTableStructure = rs.getString(1);
                }
                if (sourceTableStructure == null) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{"The table of \"" + table + "\" Structure is null!"});
                }
                StringBuilder tableStructure = new StringBuilder();
                tableStructure.append("CREATE TABLE \"").append(table).append("\"\n(");
                sourceTableStructure = sourceTableStructure.substring(sourceTableStructure.indexOf(40) + 1, sourceTableStructure.lastIndexOf(") SEGMENT"));
                int constraintIndex = sourceTableStructure.indexOf("CONSTRAINT");
                if (constraintIndex != -1) {
                    sourceTableStructure = sourceTableStructure.substring(0, constraintIndex);
                    sourceTableStructure = sourceTableStructure.substring(0, sourceTableStructure.lastIndexOf(44));
                }
                tableStructure.append(sourceTableStructure);
                tableStructure.append("\n)");
                return tableStructure.toString();
            }
        });
    }

    private List<String> getIndexStructures(final String table, final DBRoute sourceRoute) {
        String likeTable = DB.getOriginalsnapTableNameIfShardingTable((String)table).toUpperCase();
        String sql = "SELECT DBMS_METADATA.GET_DDL('INDEX',u.index_name) FROM USER_INDEXES u WHERE u.table_name='" + likeTable + "'";
        return (List)DB.query((DBRoute)sourceRoute, (String)this.getDialectSql(sql), null, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> indexStructures = new ArrayList<String>(4);
                while (rs.next()) {
                    int p2;
                    String sourceIndexStructure = rs.getString(1);
                    if (sourceIndexStructure == null || sourceIndexStructure.indexOf("\" ON \"") == -1) continue;
                    String buf = sourceIndexStructure.substring(0, sourceIndexStructure.indexOf(41) + 1);
                    StringBuilder indexStructure = new StringBuilder(buf.length());
                    int p1 = buf.indexOf("INDEX");
                    String indexNameStr = buf.substring(p1 + 6, p2 = buf.indexOf(" ON "));
                    String[] indexNameArr = indexNameStr.split("\\.");
                    String oriIndexName = indexNameArr[1].replaceAll("\"", "");
                    if (oriIndexName.startsWith("PRIMARY_")) {
                        indexStructures.add(OracleTableCreater.this.getPrimaryStructure(table, null, sourceRoute));
                        continue;
                    }
                    if (oriIndexName.startsWith("PK_")) {
                        indexStructures.add(OracleTableCreater.this.getPrimaryStructure(table, oriIndexName, sourceRoute));
                        continue;
                    }
                    indexStructure.append(buf.substring(0, p1 + 6));
                    indexStructure.append(oriIndexName).append(" ON ").append(table).append(' ');
                    indexStructure.append(buf.substring(buf.indexOf(40)));
                    indexStructures.add(indexStructure.toString());
                }
                return indexStructures;
            }
        });
    }

    private String getPrimaryStructure(String table, String indexName, DBRoute sourceRoute) {
        String likeTable = DB.getOriginalsnapTableNameIfShardingTable((String)table).toUpperCase();
        List pkFields = DB.getPrimaryKeys((DBRoute)sourceRoute, (String)likeTable);
        StringBuilder primaryStructure = new StringBuilder();
        primaryStructure.append("ALTER TABLE ").append(table).append(" ADD");
        if (!StringUtils.isEmpty((String)indexName)) {
            primaryStructure.append(" CONSTRAINT ").append(indexName);
        }
        primaryStructure.append(" PRIMARY KEY (");
        for (int i = 0; i < pkFields.size(); ++i) {
            String pkField = (String)pkFields.get(i);
            if (i == 0) {
                primaryStructure.append(pkField);
                continue;
            }
            primaryStructure.append(',').append(pkField);
        }
        primaryStructure.append(')');
        return primaryStructure.toString();
    }
}

