/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.init.table;

import java.util.Map;
import kd.bos.bdsync.init.table.AbstractTableCreater;
import kd.bos.bdsync.init.table.DefaultTableCreater;
import kd.bos.bdsync.init.table.MySQLTableCreater;
import kd.bos.bdsync.init.table.OracleTableCreater;
import kd.bos.bdsync.init.table.PostgreSQLTableCreater;
import kd.bos.db.DBType;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public class TableCreaterFactory {
    private static Map<DBType, AbstractTableCreater> creaters = new ConcurrentHashMap();

    public static AbstractTableCreater get(DBType sourceDbtype) {
        return creaters.computeIfAbsent(sourceDbtype, k -> {
            AbstractTableCreater creater;
            switch (sourceDbtype) {
                case MySQL: {
                    creater = new MySQLTableCreater();
                    break;
                }
                case Oracle: {
                    creater = new OracleTableCreater();
                    break;
                }
                case PostgreSQL: {
                    creater = new PostgreSQLTableCreater();
                    break;
                }
                case DM: 
                case OceanBase_Oracle: 
                case HANA: 
                case YasDB: 
                case SQLServer: 
                case TDSQL: 
                case TiDB: 
                case GS: 
                case GS100: 
                case GaussDB: 
                case Gauss200: 
                case Gbase: 
                case KingBase: 
                case Vastbase: {
                    creater = new DefaultTableCreater();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("upsupport db type: " + sourceDbtype);
                }
            }
            return creater;
        });
    }
}

