/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.init.table.hybrid.execute;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bdsync.init.table.hybrid.Column;
import kd.bos.bdsync.init.table.hybrid.ColumnType;
import kd.bos.bdsync.init.table.hybrid.ConstraintType;
import kd.bos.bdsync.init.table.hybrid.Index;
import kd.bos.bdsync.init.table.hybrid.Table;
import kd.bos.bdsync.init.table.hybrid.TableConstraint;
import kd.bos.bdsync.init.table.hybrid.execute.CreateTableSqlFormatter;

public class KSQLCreateTableSqlFormatter
implements CreateTableSqlFormatter {
    private final Table table;

    public KSQLCreateTableSqlFormatter(Table table) {
        this.table = table;
    }

    @Override
    public String getCreateTableSql() {
        String desc;
        StringBuilder createTableSqlBuilder = new StringBuilder("CREATE TABLE ");
        createTableSqlBuilder.append(this.table.getTableName());
        createTableSqlBuilder.append(" (");
        ArrayList<String> items = new ArrayList<String>(this.table.getColumns().size() + 5);
        for (Column column : this.table.getColumns()) {
            desc = String.format("%s %s", new Object[]{column.getName(), column.getType()});
            if (ColumnType.isBelongTo(column.getType(), ColumnType.CHAR_GROUP)) {
                desc = desc + String.format("(%d)", column.getLength());
            } else if (column.getType() == ColumnType.DECIMAL) {
                desc = desc + String.format("(%d,%d)", column.getPrecision(), column.getScale());
            }
            if (!column.isNullable()) {
                desc = desc + " NOT NULL";
            }
            if (column.getDefaultValueExpression() != null) {
                desc = desc + " DEFAULT " + column.getDefaultValueExpression();
            }
            items.add(desc);
        }
        if (this.table.getConstraints() != null) {
            for (TableConstraint constraint : this.table.getConstraints()) {
                desc = "CONSTRAINT " + constraint.getConstraintName();
                desc = constraint.getType() == ConstraintType.PRIMARY_KEY ? desc + " PRIMARY KEY" : desc + " UNIQUE";
                desc = desc + String.format("(%s)", String.join((CharSequence)",", constraint.getColumnNameList()));
                items.add(desc);
            }
        }
        createTableSqlBuilder.append(String.join((CharSequence)",", items));
        createTableSqlBuilder.append(')');
        if (this.table.getComment() != null) {
            createTableSqlBuilder.append(" COMMENT '").append(this.table.getComment()).append("'");
        }
        return createTableSqlBuilder.toString();
    }

    @Override
    public List<String> getCreateIndexSql() {
        ArrayList<String> createIndices = new ArrayList<String>(10);
        if (this.table.getIndices() != null && this.table.getIndices().size() > 0) {
            for (Index index : this.table.getIndices()) {
                StringBuilder createIndicesSqlBuilder = new StringBuilder("CREATE");
                if (index.isUnique()) {
                    createIndicesSqlBuilder.append(" UNIQUE");
                }
                if (index.isClustered()) {
                    createIndicesSqlBuilder.append(" CLUSTERED");
                }
                createIndicesSqlBuilder.append(" INDEX ").append(index.getIndexName());
                createIndicesSqlBuilder.append(" ON ");
                createIndicesSqlBuilder.append(this.table.getTableName());
                createIndicesSqlBuilder.append(String.format("(%s)", String.join((CharSequence)",", index.getColumnNames())));
                createIndices.add(createIndicesSqlBuilder.toString());
            }
        }
        return createIndices;
    }
}

