/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.init.table.hybrid.execute;

import java.util.List;
import kd.bos.bdsync.init.table.hybrid.Table;
import kd.bos.bdsync.init.table.hybrid.execute.Executor;
import kd.bos.bdsync.init.table.hybrid.execute.KSQLCreateTableSqlFormatter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

public class KSQLExecutor
implements Executor {
    @Override
    public void createTable(String routeKey, Table table) {
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        KSQLCreateTableSqlFormatter formatter = new KSQLCreateTableSqlFormatter(table);
        String createTable = formatter.getCreateTableSql();
        List<String> createIndices = formatter.getCreateIndexSql();
        try (TXHandle h1 = TX.requiresNew((String)"BDSyncInitialize_table");){
            DB.execute((DBRoute)dbRoute, (String)createTable);
            for (String createIndex : createIndices) {
                DB.execute((DBRoute)dbRoute, (String)createIndex);
            }
        }
    }

    @Override
    public void dropTable(String routeKey, String tableName) {
        try (TXHandle h1 = TX.requiresNew((String)"BDSyncInitialize_table");){
            StringBuilder dropSql = new StringBuilder();
            dropSql.append("IF EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '").append(tableName).append("')\n");
            dropSql.append("DROP TABLE ").append(tableName).append(";");
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)dropSql.toString());
        }
    }
}

