/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.output;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bdsync.sql.SqlInfo;
import kd.bos.bdsync.sql.SqlInfoContext;
import kd.bos.bdsync.sql.SqlInfoType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.AbstractSqlOutput;
import kd.bos.dts.RowInfo;
import kd.bos.dts.ksql.DataDDLSyncValue;
import kd.bos.dts.ksql.DataSqlDeleteSyncValue;
import kd.bos.dts.ksql.DataSqlInsertSyncValue;
import kd.bos.dts.ksql.DataSqlSyncValue;
import kd.bos.dts.ksql.DataSqlUpdateSyncValue;
import kd.bos.ksql.KSQLThreadCache;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.datasync.OperationType;
import kd.bos.xdb.tablemanager.TableName;

public class BDSyncSqlOutput
extends AbstractSqlOutput {
    public static final String BD_SYNC_SQL_OUTPUT = "BDSyncSqlOutput";
    public static final String EMPTY_STR = " ";

    public BDSyncSqlOutput(DestinationTransRule ruleType) {
        super(ruleType);
    }

    public void trans(String type, DataSyncValue value) {
        DataSqlSyncValue sqlValue = (DataSqlSyncValue)value;
        String tableName = sqlValue.getTableName();
        TableName xdbTableName = TableName.of((String)tableName);
        if (DB.isSharded((String)xdbTableName.getOriginalName())) {
            this.xdbTrans(type, value, xdbTableName);
        } else {
            this.executeSQL(sqlValue.getSourceSql(), sqlValue.getSourceParams());
        }
    }

    public void reTrans(String type, DataSyncValue value, String configOperateType, String entityfields) {
        this.trans(type, value);
    }

    public void xdbTrans(String type, DataSyncValue value, TableName xdbTableName) {
        if (xdbTableName.isPKTable() || xdbTableName.isMapTable() || xdbTableName.isPKTempTable()) {
            return;
        }
        String tableName = value.getTableName();
        String originalTableName = xdbTableName.getOriginalName();
        if (OperationType.INSERT.getName().equals(type)) {
            DataSqlInsertSyncValue insert = (DataSqlInsertSyncValue)value;
            Object[] params = insert.getSourceParams();
            if (params == null || params.length == 0) {
                params = insert.getValues().toArray(new Object[0]);
            }
            this.executeSQL(this.buildInsertSql(originalTableName, insert.getClomns()), params);
        } else if (OperationType.UPDATE.getName().equals(type)) {
            DataSqlUpdateSyncValue update = (DataSqlUpdateSyncValue)value;
            String pkField = update.getPkField();
            List idList = update.getIds();
            if (idList != null && !idList.isEmpty()) {
                DBRoute route = DBRoute.of((String)this.destinationRule.getRegion());
                try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
                     TXHandle h = TX.requiresNew((String)BD_SYNC_SQL_OUTPUT);){
                    DB.execute((DBRoute)route, (SqlBuilder)this.builderSqlBuiler(originalTableName, pkField, idList));
                    try (DataSet ds = this.getDataSet(update.getRouteKey(), tableName, pkField, idList);){
                        String[] fieldNames = ds.getRowMeta().getFieldNames();
                        int batchSize = this.getBatchSize();
                        ArrayList<RowInfo> consumeDataList = new ArrayList<RowInfo>(4);
                        while (ds.hasNext()) {
                            Row r = ds.next();
                            RowInfo ri = new RowInfo();
                            ri.setType(OperationType.INSERT.getName());
                            ri.setTable(originalTableName);
                            ri.setKey(r.get(pkField));
                            for (String fieldName : fieldNames) {
                                ri.getData().put(fieldName, r.get(fieldName));
                            }
                            consumeDataList.add(ri);
                            if (consumeDataList.size() <= batchSize) continue;
                            this.insertDataList(consumeDataList);
                            consumeDataList.clear();
                        }
                        if (!consumeDataList.isEmpty()) {
                            this.insertDataList(consumeDataList);
                        }
                    }
                }
            }
        } else if (OperationType.DELETE.getName().equals(type)) {
            DataSqlDeleteSyncValue delete = (DataSqlDeleteSyncValue)value;
            List idList = delete.getIds();
            String pkField = delete.getPkField();
            if (idList != null && !idList.isEmpty()) {
                DBRoute route = DBRoute.of((String)this.destinationRule.getRegion());
                try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
                     TXHandle h = TX.requiresNew((String)BD_SYNC_SQL_OUTPUT);){
                    DB.execute((DBRoute)route, (SqlBuilder)this.builderSqlBuiler(originalTableName, pkField, idList));
                }
            }
        } else if (OperationType.DDL.getName().equals(type) && xdbTableName.isOriginalSnapTable()) {
            DataDDLSyncValue ddlValue = (DataDDLSyncValue)value;
            this.executeSQL(this.convertSQL(ddlValue.getSourceSql(), tableName, originalTableName), ddlValue.getSourceParams());
        }
    }

    private void executeSQL(String sql, Object[] params) {
        DBRoute route = DBRoute.of((String)this.destinationRule.getRegion());
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
             TXHandle h = TX.requiresNew((String)BD_SYNC_SQL_OUTPUT);){
            DB.execute((DBRoute)route, (String)sql, (Object[])params);
        }
    }

    private String buildInsertSql(String tableName, List<String> columns) {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ").append(tableName).append("(");
        int size = columns.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(columns.get(i));
        }
        stringBuilder.append(")").append(" VALUES(");
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private SqlBuilder builderSqlBuiler(String tableName, String pkField, List<Object> idList) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]).appendIn(pkField, idList);
        return sqlBuilder;
    }

    private void insertDataList(List<RowInfo> consumeDataList) {
        DBRoute route = DBRoute.of((String)this.destinationRule.getRegion());
        SqlInfoContext sqlInfoContext = new SqlInfoContext(consumeDataList, SqlInfoType.INSERT, route);
        for (SqlInfo sqlInfo : sqlInfoContext.getSqlInfoList()) {
            if (sqlInfo.getSqlBuilder() != null) {
                DB.execute((DBRoute)route, (SqlBuilder)sqlInfo.getSqlBuilder());
                continue;
            }
            DB.executeBatch((DBRoute)route, (String)sqlInfo.getSql(), sqlInfo.getParams());
        }
    }

    private String convertSQL(String sql, String tableName, String originalTableName) {
        sql = sql.replace(tableName, originalTableName);
        return sql;
    }

    private DataSet getDataSet(String sourceRuteKey, String tableName, String pkField, List<Object> pkList) {
        KSQLThreadCache.put((Object)"check.selectAllColumn", (Object)false);
        StringBuilder sb = new StringBuilder("select * ");
        sb.append(" from ").append(tableName).append(" where ").append(pkField).append(" in (");
        for (int i = pkList.size() - 1; i >= 0; --i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return DB.queryDataSet((String)("Query" + pkField), (DBRoute)DBRoute.of((String)sourceRuteKey), (String)sb.toString(), (Object[])pkList.toArray());
    }

    private int getBatchSize() {
        return Integer.getInteger("dts.bdsync.init.batchsize", 1000);
    }
}

