/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.sql.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bdsync.sql.SqlInfo;
import kd.bos.bdsync.sql.impl.AbstractSqlInfoCreater;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.RowInfo;
import kd.bos.orm.datasync.agent.MetaTable;
import kd.bos.orm.datasync.agent.RelationTablesCache;
import kd.bos.orm.datasync.agent.TableInfo;
import kd.bos.util.StringUtils;

public class DeleteSqlInfoCreater
extends AbstractSqlInfoCreater {
    public DeleteSqlInfoCreater(List<RowInfo> rowInfos, DBRoute dbRoute) {
        super(rowInfos, dbRoute);
    }

    @Override
    public List<SqlInfo> create() {
        ArrayList<SqlInfo> sqlInfos = new ArrayList<SqlInfo>(5);
        Map metaTableMap = RelationTablesCache.get().getMetaTableMap(this.entityNumber);
        MetaTable metaTable = (MetaTable)metaTableMap.get(this.tableName.toLowerCase());
        ArrayList<Object> pkList = new ArrayList<Object>();
        this.rowInfos.forEach(row -> pkList.add(row.getKeyObject()));
        this.doCreate(sqlInfos, metaTable, pkList);
        return sqlInfos;
    }

    private void doCreate(List<SqlInfo> sqlInfos, MetaTable metaTable, List<Object> pkList) {
        if (!pkList.isEmpty()) {
            List<List> splitList = this.splitArrayList(pkList);
            String curentPrimartKey = metaTable.getPrimaryKey();
            String currentTableName = metaTable.getTableName();
            for (List range : splitList) {
                if (!metaTable.getChildrenTableMap().isEmpty()) {
                    for (MetaTable childrenMetaTable : new ArrayList(metaTable.getChildrenTableMap().values())) {
                        this.queryAndCreate(sqlInfos, childrenMetaTable, range);
                    }
                }
                sqlInfos.add(this.createDeleteSql(currentTableName, curentPrimartKey, range));
            }
        }
    }

    private void queryAndCreate(List<SqlInfo> sqlInfos, MetaTable metaTable, List<Object> pkList) {
        if (metaTable.getChildrenTableMap().isEmpty()) {
            String relationField = metaTable.getRelationField();
            String tableName = metaTable.getTableName();
            sqlInfos.add(this.createDeleteSql(tableName, relationField, pkList));
        } else {
            StringBuilder inSQL = new StringBuilder(pkList.size() * 2 + 6).append(" in (");
            int n = pkList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    inSQL.append(',');
                }
                inSQL.append('?');
            }
            inSQL.append(')');
            String currentTable = metaTable.getTableName();
            String currentPrimaryKey = metaTable.getPrimaryKey();
            StringBuilder sql = new StringBuilder(128);
            String relationField = StringUtils.isEmpty((String)metaTable.getRelationField()) ? metaTable.getPrimaryKey() : metaTable.getRelationField();
            sql.append("select ").append(currentPrimaryKey).append(" from ").append(currentTable).append(" where ").append(relationField).append((CharSequence)inSQL);
            ArrayList<Object> currentPks = new ArrayList<Object>();
            try (DataSet ds = DB.queryDataSet((String)("DeleteSqlInfoCreater" + currentTable), (DBRoute)this.dbRoute, (String)sql.toString(), (Object[])pkList.toArray());){
                while (ds.hasNext()) {
                    Row r = ds.next();
                    Object currentPkValue = r.get(currentPrimaryKey);
                    currentPks.add(currentPkValue);
                }
            }
            this.doCreate(sqlInfos, metaTable, currentPks);
        }
    }

    private SqlInfo createDeleteSql(String tableName, String relationField, List pkList) {
        StringBuilder sb = new StringBuilder("delete from ");
        sb.append(tableName).append(" where ").append(relationField).append(" in (?)");
        ArrayList<Object[]> values = new ArrayList<Object[]>(5);
        pkList.forEach(row -> values.add(new Object[]{row}));
        SqlInfo info = new SqlInfo(sb.toString(), values);
        return info;
    }

    private SqlInfo createWithTableInfo(TableInfo tableInfo) {
        StringBuilder sb = new StringBuilder("delete from ");
        sb.append(tableInfo.getTableName()).append(" where ").append(tableInfo.getRelationField()).append(" in (?)");
        ArrayList<Object[]> values = new ArrayList<Object[]>(5);
        this.rowInfos.forEach(row -> values.add(new Object[]{row.getKeyObject()}));
        SqlInfo info = new SqlInfo(sb.toString(), values);
        return info;
    }

    private SqlInfo createWithWhere(String tableName, String where) {
        StringBuilder sb = new StringBuilder("delete from ");
        sb.append(tableName).append(" where ").append(where);
        return new SqlInfo(sb.toString(), null);
    }

    private List<List> splitArrayList(List<Object> pks) {
        ArrayList<List> ranges = new ArrayList<List>(10);
        int pageSize = 1000;
        if (pks.size() <= pageSize) {
            ranges.add(pks);
        } else {
            int toIndex;
            int total = pks.size();
            int i = 0;
            do {
                int fromIndex = i;
                toIndex = Math.min(i += pageSize, total) - 1;
                List<Object> range = pks.subList(fromIndex, toIndex + 1);
                ranges.add(range);
            } while (toIndex != total - 1);
        }
        return ranges;
    }
}

