/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.sql.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bdsync.BDSyncRowInfo;
import kd.bos.bdsync.sql.SqlInfo;
import kd.bos.bdsync.sql.impl.AbstractSqlInfoCreater;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.dts.RowInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class UpdateSqlInfoCreater
extends AbstractSqlInfoCreater {
    public UpdateSqlInfoCreater(List<RowInfo> rowInfos, DBRoute dbRoute) {
        super(rowInfos, dbRoute);
    }

    @Override
    public List<SqlInfo> create() {
        Set<String> fields = this.row0.getData().keySet();
        ArrayList<SqlInfo> sqlInfos = new ArrayList<SqlInfo>(5);
        String pkField = ((BDSyncRowInfo)this.row0).getPkName();
        if (StringUtils.isEmpty((CharSequence)pkField)) {
            throw new KDException(BosErrorCode.nullError, new Object[]{"PkField can not be null."});
        }
        Map<String, Set<String>> extTableFieldsMap = this.getExtTableFieldsMap();
        Map<String, Set<String>> tableFieldsMap = this.getTableSaveFieldsMap(extTableFieldsMap, fields);
        for (Map.Entry<String, Set<String>> entry : tableFieldsMap.entrySet()) {
            String tempTableName;
            SqlInfo info;
            Set<String> fieldSet = entry.getValue();
            if (fieldSet.isEmpty() || (info = this.createWithPkField(tempTableName = entry.getKey(), new ArrayList<String>(fieldSet), pkField)) == null) continue;
            sqlInfos.add(info);
        }
        return sqlInfos;
    }

    private SqlInfo createWithWhere(String tableName, List<String> fields, String where) {
        StringBuilder sb = new StringBuilder("update ");
        sb.append(tableName).append(" set ");
        fields.forEach(v -> sb.append((String)v).append("=?").append(','));
        sb.setLength(sb.length() - 1);
        sb.append(' ').append(where);
        ArrayList<Object[]> values = new ArrayList<Object[]>(5);
        this.rowInfos.forEach(row -> {
            ArrayList rowvalue = new ArrayList(5);
            Map rowMap = row.getData();
            fields.forEach(v -> rowvalue.add(rowMap.get(v)));
            values.add(rowvalue.toArray(new Object[0]));
        });
        if (!values.isEmpty()) {
            return new SqlInfo(sb.toString(), values);
        }
        return null;
    }

    private SqlInfo createWithPkField(String tableName, List<String> fields, String pkField) {
        StringBuilder sb = new StringBuilder("update ");
        sb.append(tableName).append(" set ");
        fields.forEach(v -> sb.append((String)v).append("=?").append(','));
        sb.setLength(sb.length() - 1);
        sb.append(" where ").append(pkField).append("=?");
        ArrayList<Object[]> values = new ArrayList<Object[]>(5);
        this.rowInfos.forEach(row -> {
            ArrayList<Object> rowvalue = new ArrayList<Object>(5);
            Map rowMap = row.getData();
            fields.forEach(v -> rowvalue.add(rowMap.get(v)));
            rowvalue.add(((BDSyncRowInfo)((Object)row)).getPkValue());
            values.add(rowvalue.toArray(new Object[0]));
        });
        if (!values.isEmpty()) {
            return new SqlInfo(sb.toString(), values);
        }
        return null;
    }
}

