/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.component;

import java.util.List;
import kd.bos.armor.core.slots.statistic.base.LeapArray;
import kd.bos.armor.core.slots.statistic.base.WindowWrap;
import kd.bos.armor.core.slots.statistic.data.MetricBucket;
import kd.bos.armor.core.slots.statistic.metric.BucketLeapArray;
import kd.bos.ha.component.Counter;

public class SlidingWindowCounter
implements Counter {
    private static final int TOTAL_TIME_DEFAULT = Integer.getInteger("ha.component.offline.time.total", 60000);
    private static final int WINDOW_TIME_DEFAULT = Integer.getInteger("ha.component.offline.time.interval", 1000);
    private LeapArray<MetricBucket> data;

    public SlidingWindowCounter() {
        this(TOTAL_TIME_DEFAULT, WINDOW_TIME_DEFAULT);
    }

    public SlidingWindowCounter(int totalTime, int windowTime) {
        this.data = new BucketLeapArray(totalTime / windowTime, totalTime);
    }

    @Override
    public void addException() {
        WindowWrap wrap = this.data.currentWindow();
        ((MetricBucket)wrap.value()).addException(1);
    }

    @Override
    public boolean hasException() {
        this.data.currentWindow();
        long exception = 0L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            exception += window.exception();
        }
        return exception >= (long)this.getThreshold();
    }

    @Override
    public void addSuccess() {
        WindowWrap wrap = this.data.currentWindow();
        ((MetricBucket)wrap.value()).addSuccess(1);
    }

    @Override
    public boolean isRecover() {
        this.data.currentWindow();
        long success = 0L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            success += window.success();
        }
        return success >= (long)this.getThreshold();
    }

    private int getThreshold() {
        try {
            return Integer.getInteger("ha.component.offline.threshold", 1);
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public void reset() {
        this.data.currentWindow();
        List list = this.data.values();
        for (MetricBucket window : list) {
            window.reset();
        }
    }
}

