/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.AgentContextImpl;
import kd.bos.gptas.autoact.agent.AgentInvokerThreadContext;
import kd.bos.gptas.autoact.agent.DefaultMethodInvoker;
import kd.bos.gptas.autoact.agent.callchain.AgentCall;
import kd.bos.gptas.autoact.agent.callchain.AgentCallChain;
import kd.bos.gptas.autoact.agent.callchain.AgentCallChainImpl;
import kd.bos.gptas.autoact.agent.executor.AgentExecutor;
import kd.bos.gptas.autoact.agent.safepoint.AbstractSafePoint;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.monitor.Cost;
import kd.bos.gptas.autoact.output.convert.ObjectConverter;

final class AgentInvoker
implements InvocationHandler,
Logable {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final AgentContextImpl ctx;
    private final AgentExecutor executor;

    public AgentInvoker(AgentContext ctx) {
        this.ctx = (AgentContextImpl)ctx;
        this.executor = this.ctx.getExecutor();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        String methodName = method.getName();
        if ((args == null || args.length == 0) && methodName.equals("__getContext")) {
            return this.ctx;
        }
        try (AgentInvokerThreadContext atc = AgentInvokerThreadContext.setup(this.ctx);){
            Object ret;
            this.ctx.getSession().getSafePoint().poll();
            String agentName = this.ctx.getAgent().getName();
            logger.info(agentName + "--> " + methodName + ": " + Arrays.toString(args));
            this.ctx.fireAgentListener(al -> al.onBeforeMethod(method, args, this.ctx));
            if (method.isDefault()) {
                Object value = DefaultMethodInvoker.invokeDefaultMethod(proxy, method, args);
                ret = ObjectConverter.convert(value, method.getReturnType());
            } else {
                ret = this.__invoke(methodName, method, args);
            }
            this.ctx.fireAgentListener(al -> al.onAfterMethod(method, ret, this.ctx));
            logger.info(agentName + "<-- " + methodName + ": " + ret);
            this.ctx.getSession().getSafePoint().poll();
            Object object = ret;
            return object;
        }
    }

    private Object __invoke(String methodName, Method method, Object[] args) throws Throwable {
        if (args != null && args.length > 0) {
            Object[] input = args.length == 1 ? args[0] : args;
            this.ctx.getContextVarProvider().setInput(input);
        }
        AgentCallChain cc = this.ctx.getCallChain();
        if (this.ctx.getParent() == null) {
            ((AgentCallChainImpl)cc).reset();
            ((AbstractSafePoint)this.ctx.getSession().getSafePoint()).reset();
        }
        AgentCall cm = cc.addAgentCall(this.ctx.getAgent().getName(), method);
        String className = this.ctx.getAgent().getAgentClass().getName();
        try (Cost cost = Cost.trace("AgentInvoker.invoke." + className + '#' + methodName);){
            boolean loggable;
            String agentName = this.ctx.getAgent().getName();
            int level = this.ctx.getLevel();
            String tag = "level=" + level + ", agent=" + agentName + ", api=" + className + '#' + methodName + ", sessionId=" + this.ctx.getSession().getSessionId() + ", callSeq=" + cm.getCallSeq() + '\n';
            boolean bl = loggable = this.ctx.isVerbose() && logger.isInfoEnabled();
            if (loggable) {
                logger.info("[METHOD call \"" + methodName + "\"] " + tag + "args: " + (args == null ? "" : " " + Arrays.asList(args)));
            }
            Object returnValue = this.executor.execute(method, args == null ? EMPTY_ARGS : args, this.ctx.getAllTools(), loggable, cc.getCurrentAgentCall());
            this.ctx.getContextVarProvider().setOutput(returnValue);
            if (loggable) {
                if (this.ctx.getParent() == null) {
                    StringBuilder msg = new StringBuilder(1024);
                    int i = 0;
                    for (AgentCall tc : cc.getAllAgentCall()) {
                        List logs = tc.getCalledTools().stream().map(Tool::getName).collect(Collectors.toList());
                        msg.append("\n\tlevel=").append(i).append(", seq=").append(tc.getCallSeq()).append(", enter api=").append(tc.getAgentName()).append('#').append(tc.getMethodName()).append("\n\t\tcall tools=").append(logs);
                        ++i;
                    }
                    logger.info("all chains: " + msg);
                } else {
                    List<Tool> tools = cc.getCurrentAgentCall().getCalledTools();
                    List logs = tools.stream().map(Tool::getName).collect(Collectors.toList());
                    logger.info("chains-level-" + level + ": " + logs);
                }
                logger.info("[METHOD return \"" + methodName + "\"] " + tag + returnValue);
            }
            Object object = returnValue;
            return object;
        }
    }
}

