/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent;

import java.util.Collections;
import java.util.Map;
import kd.bos.gptas.autoact.agent.AgentBuilder;
import kd.bos.gptas.autoact.agent.AgentBuilderImpl;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.AgentProxy;
import kd.bos.gptas.autoact.agent.ChatBot;
import kd.bos.gptas.autoact.prompt.var.MapVarProvider;
import kd.bos.gptas.autoact.prompt.var.VarProvider;

public interface Agents {
    public static AgentBuilder<ChatBot> chatBotBuilder() {
        return Agents.builder(ChatBot.class);
    }

    public static <T> AgentBuilder<T> builder(Class<T> serviceClass) {
        return Agents.builder(serviceClass, Collections.emptyMap());
    }

    public static <T> AgentBuilder<T> builder(Class<T> serviceClass, Map<String, Object> varMap) {
        return Agents.builder(serviceClass, new MapVarProvider(varMap));
    }

    public static <T> AgentBuilder<T> builder(Class<T> serviceClass, VarProvider varProvider) {
        return new AgentBuilderImpl<T>(serviceClass, varProvider);
    }

    public static AgentContext getAgentContext(Object agentObject) {
        if (agentObject instanceof AgentProxy) {
            return ((AgentProxy)agentObject).__getContext();
        }
        throw new IllegalArgumentException(agentObject + " is not an agent object.");
    }

    public static <R, P> R callAgent(Object agentObject, P input) {
        if (!(agentObject instanceof AgentProxy)) {
            throw new IllegalArgumentException(agentObject + " is not an agent object.");
        }
        return ((AgentProxy)agentObject).__input__(input);
    }
}

