/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent.callchain;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.gptas.autoact.agent.callchain.AgentCall;
import kd.bos.gptas.autoact.agent.callchain.AgentCallChain;
import kd.bos.gptas.autoact.agent.callchain.AgentCallImpl;

public class AgentCallChainImpl
implements AgentCallChain {
    private final LinkedList<AgentCall> agentCalls = new LinkedList();
    private final AtomicInteger callSeq = new AtomicInteger();

    @Override
    public AgentCall addAgentCall(String agentName, Method method) {
        AgentCallImpl cm = new AgentCallImpl(agentName, method, this.callSeq.incrementAndGet());
        this.agentCalls.add(cm);
        return cm;
    }

    @Override
    public AgentCall getCurrentAgentCall() {
        return this.agentCalls.getLast();
    }

    @Override
    public List<AgentCall> getAllAgentCall() {
        return Collections.unmodifiableList(this.agentCalls);
    }

    public void reset() {
        this.agentCalls.clear();
        this.callSeq.set(0);
    }
}

