/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent.callchain;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.gptas.autoact.agent.callchain.AgentCall;
import kd.bos.gptas.autoact.model.Tool;

public final class AgentCallImpl
implements AgentCall {
    private final int callSeq;
    private final String agentName;
    private final Method method;
    private final List<Tool> calledTools = new LinkedList<Tool>();

    public AgentCallImpl(String agentName, Method method, int callSeq) {
        this.agentName = agentName;
        this.method = method;
        this.callSeq = callSeq;
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public int getCallSeq() {
        return this.callSeq;
    }

    @Override
    public Class<?> getMethodReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public String getMethodName() {
        return this.method.getName();
    }

    @Override
    public List<Tool> getCalledTools() {
        return Collections.unmodifiableList(this.calledTools);
    }

    public void addToolCall(Tool tool) {
        this.calledTools.add(tool);
    }
}

