/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent.executor;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.interact.Interactions;
import kd.bos.gptas.autoact.def.ToolAction;
import kd.bos.gptas.autoact.exception.AgentInteractException;
import kd.bos.gptas.autoact.exception.ExceptionUtil;
import kd.bos.gptas.autoact.exception.MethodExecuteException;
import kd.bos.gptas.autoact.exception.NoScriptCodeBlockException;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.message.MessageStream;
import kd.bos.gptas.autoact.model.Action;
import kd.bos.gptas.autoact.model.ActionType;
import kd.bos.gptas.autoact.model.Parameter;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.output.convert.LLMConverter;
import kd.bos.gptas.autoact.output.parser.CodeBlockExtractor;
import kd.bos.gptas.autoact.util.JsonUtil;
import kd.bos.gptas.autoact.util.StringUtil;

public class MethodAction<R>
implements Action<R, Object>,
Logable {
    private final Tool tool;
    private final Object object;
    private final Method method;
    private final AgentContext ctx;

    public MethodAction(Tool tool, Object object, Method method, AgentContext ctx) {
        this.tool = tool;
        this.object = object;
        this.method = method;
        this.ctx = ctx;
        this.method.setAccessible(true);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.METHOD;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    @ToolAction
    public R act(Object arguments) {
        Object[] args;
        block28: {
            args = new Object[this.method.getParameterCount()];
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            try {
                String name;
                if (args.length == 0) break block28;
                if (args.length == 1) {
                    args[0] = LLMConverter.convert(arguments, parameterTypes[0], this.ctx);
                    break block28;
                }
                Map<String, String> inputs = this.tool.getInput();
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                for (Parameter parameter : this.tool.getParameters()) {
                    String name2 = parameter.getName();
                    String ref = inputs.get(name2);
                    Object value = this.ctx.getContextVarProvider().getByExpression(ref == null ? name2 : ref);
                    if (value == null) continue;
                    map.put(name2, value);
                }
                if (map.isEmpty()) {
                    if (arguments instanceof MessageStream) {
                        arguments = ((MessageStream)arguments).fetch();
                    }
                    try {
                        JSONObject jsonMap;
                        if (arguments instanceof String) {
                            try {
                                String json = CodeBlockExtractor.extractFirst("json", (String)arguments);
                                jsonMap = JsonUtil.parseObject(json);
                            }
                            catch (NoScriptCodeBlockException e) {
                                jsonMap = JsonUtil.parseObject((String)arguments);
                            }
                        } else {
                            jsonMap = JsonUtil.parseObject(JsonUtil.toJSONString(arguments, new SerializerFeature[0]));
                        }
                        for (Parameter parameter : this.tool.getParameters()) {
                            name = parameter.getName();
                            if (!jsonMap.containsKey(name)) continue;
                            map.put(name, jsonMap.get(name));
                        }
                    }
                    catch (Exception jsonMap) {
                        // empty catch block
                    }
                }
                int i = 0;
                for (Parameter parameter : this.tool.getParameters()) {
                    Object arg;
                    block29: {
                        name = parameter.getName();
                        if (parameter.isRequired() && (!map.containsKey(name) || "".equals(map.get(name)) || null == map.get(name))) {
                            try {
                                String inputTool;
                                String desc = parameter.getDescription();
                                if (StringUtil.isEmpty(desc)) {
                                    desc = name;
                                }
                                if (StringUtil.isEmpty(inputTool = parameter.getInputTool())) {
                                    throw new AgentInteractException("Required parameter \"" + name + "\" has no value, and not set input box:" + desc);
                                }
                                while (true) {
                                    if ((arg = Interactions.askInput(inputTool, desc, this.ctx)) == null) {
                                        throw new AgentInteractException("Cancel cause no input: " + desc);
                                    }
                                    try {
                                        arg = LLMConverter.convert(arg, parameterTypes[i], this.ctx);
                                        break block29;
                                    }
                                    catch (ClassCastException classCastException) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Exception e) {
                                throw ExceptionUtil.asRuntimeException(e);
                            }
                        }
                        arg = map.get(name);
                        arg = LLMConverter.convert(arg, parameterTypes[i], this.ctx);
                    }
                    args[i] = arg;
                    ++i;
                }
            }
            catch (JSONException e) {
                if (parameterTypes.length == 1) {
                    args[0] = LLMConverter.convert(arguments, parameterTypes[0], this.ctx);
                }
                throw new MethodExecuteException("Tool #" + this.tool.getName() + " of " + this.method.getDeclaringClass() + '#' + this.method.getName() + Arrays.asList(this.method.getParameterTypes()) + " can't invoke with argument: " + arguments);
            }
        }
        try {
            Object result = this.method.invoke(this.object, args);
            return (R)result;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.getClass().getSimpleName();
            }
            throw new MethodExecuteException(msg, t);
        }
        catch (IllegalAccessException e) {
            throw new MethodExecuteException(e);
        }
    }
}

