/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent.interact;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.AgentContextImpl;
import kd.bos.gptas.autoact.agent.interact.InteractThreadContext;
import kd.bos.gptas.autoact.agent.interact.ServiceNode;
import kd.bos.gptas.autoact.config.GlobalConfig;
import kd.bos.gptas.autoact.exception.AgentDefineError;
import kd.bos.gptas.autoact.exception.AgentInteractTimeout;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.model.Action;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.util.Pair;

public class Interactions
implements Logable {
    private static Map<String, Pair<Object, Object>> threadMap = new ConcurrentHashMap<String, Pair<Object, Object>>();
    private static AtomicInteger seq = new AtomicInteger();
    private static ExecutorService es = new ThreadPoolExecutor(0, 200, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
        Thread t = new Thread(r);
        t.setName("AutoAct-Interaction-" + seq.incrementAndGet());
        t.setDaemon(true);
        return t;
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object askInput(String inputTool, String inputDesc, AgentContext ctx) throws Exception {
        Tool tool = ctx.getTool(inputTool);
        if (tool == null) {
            throw new AgentDefineError("Input tool " + inputTool + " not define.");
        }
        String sessionId = ctx.getSession().getSessionId();
        Action action = ((AgentContextImpl)ctx).getExecutor().getToolAction(tool);
        CountDownLatch cdThread = new CountDownLatch(1);
        Object lock = new Object();
        Future<Object> future = es.submit(() -> {
            logger.info("Interactions submitted: " + sessionId);
            cdThread.await();
            logger.info("Interactions executing: " + sessionId);
            try (InteractThreadContext itx = InteractThreadContext.setup(ctx);){
                Object ret = action.act("Please input " + inputDesc + ":");
                Object object = lock;
                synchronized (object) {
                    logger.info("Interactions resuming: " + sessionId);
                    Interactions.resume(sessionId, ret, false);
                    logger.info("Interactions resumed: " + sessionId);
                }
                object = ret;
                return object;
            }
        });
        Object object = lock;
        synchronized (object) {
            cdThread.countDown();
            logger.info("Interactions suspend: " + sessionId);
            Interactions.suspend(sessionId, lock);
        }
        logger.info("Interactions finished: " + sessionId);
        return future.get();
    }

    private static void suspend(String sessionId, Object lock) throws InterruptedException {
        ServiceNode.get().setSuspend(sessionId);
        Pair<Object, Object> pair = new Pair<Object, Object>(lock, null);
        threadMap.put(sessionId, pair);
        try {
            lock.wait(GlobalConfig.getAgentInteractionTimeout());
        }
        catch (InterruptedException e) {
            throw new AgentInteractTimeout("Agent interact timeout(sessionId:" + sessionId + ").");
        }
        finally {
            threadMap.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resume(String sessionId, Object receivedValue, boolean callByRemoteNode) {
        Pair<Object, Object> pair = threadMap.get(sessionId);
        if (pair == null) {
            if (callByRemoteNode) {
                throw new AgentInteractTimeout("Agent interact has timeout(sessionId:" + sessionId + ").");
            }
            ServiceNode sn = ServiceNode.get();
            String nodeId = sn.getSuspend(sessionId);
            if (nodeId == null) {
                throw new AgentInteractTimeout("Agent interact has timeout(sessionId:" + sessionId + ").");
            }
            sn.resumeRemote(nodeId, sessionId, receivedValue);
        } else {
            Object object = pair.getKey();
            synchronized (object) {
                pair.setValue(receivedValue);
                pair.getKey().notify();
            }
        }
    }
}

