/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent.reflect;

import com.alibaba.fastjson.serializer.SerializerFeature;
import kd.bos.gptas.autoact.model.Agent;
import kd.bos.gptas.autoact.model.AgentImpl;
import kd.bos.gptas.autoact.util.JsonUtil;
import kd.bos.gptas.autoact.util.StringUtil;

public final class AgentReflectInfo {
    private final Class<?> agentCls;
    private final String appId;
    private final String name;
    private final String prompt;
    private final String defineString;

    public AgentReflectInfo(Class<?> agentCls, String appId, String name, String prompt, String defineString) {
        this.agentCls = agentCls;
        this.appId = appId;
        this.name = name;
        this.prompt = prompt;
        this.defineString = defineString;
    }

    public Class<?> getAgentClass() {
        return this.agentCls;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getDefineString() {
        return this.defineString;
    }

    public String toString() {
        if (!StringUtil.isEmpty(this.appId)) {
            return '[' + this.appId + "] " + this.name;
        }
        return this.name;
    }

    public static AgentReflectInfo from(Agent agent) {
        String prompt = agent.getSystemPrompt();
        if (StringUtil.isEmpty(prompt)) {
            prompt = agent.getIntentPrompt();
        }
        String defineString = JsonUtil.toJSONString(((AgentImpl)agent).toMap(), SerializerFeature.PrettyFormat);
        return new AgentReflectInfo(agent.getAgentClass(), agent.getAppId(), agent.getName(), prompt, defineString);
    }
}

