/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent.safepoint;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.safepoint.AbstractSafePoint;
import kd.bos.gptas.autoact.agent.safepoint.SafePointData;
import kd.bos.gptas.autoact.agent.safepoint.Status;
import kd.bos.gptas.autoact.exception.AgentInteractException;

public class MemorySafePoint
extends AbstractSafePoint {
    private final AtomicInteger savingIdSeq = new AtomicInteger();
    private final Map<Long, SafePointData> dataMap = new HashMap<Long, SafePointData>();
    private final Object pauseLock = new Object();
    private volatile Status status = Status.RUNNING;
    private long savingId;

    protected MemorySafePoint(AgentContext agentContext) {
        this.setAgentContext(agentContext);
    }

    @Override
    public long save() {
        this.status = Status.SAVING;
        this.savingId = this.savingIdSeq.getAndIncrement();
        return this.savingId;
    }

    @Override
    public void restore(long savePointId) {
        assert (this.status == Status.RUNNING);
        throw new UnsupportedOperationException();
    }

    @Override
    public void pause() {
        this.status = Status.PAUSING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.pauseLock;
        synchronized (object) {
            assert (this.status == Status.PAUSED);
            this.status = Status.RUNNING;
            this.pauseLock.notify();
        }
    }

    @Override
    public void stop() {
        this.status = Status.STOPPING;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public SafePointData getData(long savePointId) {
        return this.dataMap.get(savePointId);
    }

    @Override
    public void poll() {
        switch (this.status) {
            case PAUSING: {
                this.pollPause();
                break;
            }
            case STOPPING: {
                this.pollStop();
                break;
            }
            case SAVING: {
                this.pollSave();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollPause() {
        Object object = this.pauseLock;
        synchronized (object) {
            try {
                this.status = Status.PAUSED;
                this.pauseLock.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("safe point interrupted on paused", e);
            }
        }
    }

    private void pollStop() {
        assert (this.status == Status.STOPPING);
        this.status = Status.STOPPED;
        throw new AgentInteractException("stop agent");
    }

    private void pollSave() {
        this.status = Status.RUNNING;
        SafePointData data = new SafePointData(this.savingId);
        this.dataMap.put(this.savingId, data);
        throw new UnsupportedOperationException("save safe point");
    }

    @Override
    public void reset() {
        this.dataMap.clear();
        this.status = Status.RUNNING;
    }
}

