/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.def;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import kd.bos.gptas.autoact.def.KV;
import kd.bos.gptas.autoact.exception.AgentDefineError;
import kd.bos.gptas.autoact.model.ActionModel;
import kd.bos.gptas.autoact.model.BeforeOrAfterActionModel;
import kd.bos.gptas.autoact.output.ReturnType;
import kd.bos.gptas.autoact.util.StringUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Agent {
    public String value() default "";

    public String appId() default "";

    public String[] intentPrompt() default {""};

    public String[] systemPrompt() default {""};

    public String llm() default "";

    public ActionModel actionModel() default ActionModel.REACT;

    public ReturnType returnType() default ReturnType.AUTO;

    public String action() default "";

    public String defaultTool() default "";

    public String defaultAction() default "";

    public String[] beforeActionTools() default {};

    public String[] afterActionTools() default {};

    public BeforeOrAfterActionModel beforeActionModel() default BeforeOrAfterActionModel.FLOW;

    public BeforeOrAfterActionModel afterActionModel() default BeforeOrAfterActionModel.FLOW;

    public String[] externalTools() default {};

    public KV[] properties() default {};

    public static class Names {
        public static String getAgentName(Class<?> agentCls) {
            return agentCls.getName();
        }

        public static boolean definedByAgentAPI(String name) {
            return name.indexOf(46) != -1;
        }

        public static boolean definedBySkillConfig(String name) {
            return name.indexOf(46) == -1;
        }

        public static void checkDefinedByAgentAPI(String name) {
            if (!Names.definedByAgentAPI(name)) {
                throw new AgentDefineError("The name of agent defined by @Agent must include dot char.: " + name);
            }
        }

        public static void checkDefinedBySkillConfig(String name) {
            if (!Names.definedBySkillConfig(name)) {
                throw new AgentDefineError("The name of agent defined by skill config cannot contain a dot: " + name);
            }
        }
    }

    public static class Paths {
        public static String get(Agent agent, Class<?> cls) {
            if (agent == null) {
                throw new IllegalArgumentException(cls.getName() + "is not an agent class cause without annotation: " + Agent.class.getName());
            }
            String modelPath = agent.value();
            if (StringUtil.isEmpty(modelPath)) {
                return "";
            }
            if ((modelPath = modelPath.trim()).startsWith("./")) {
                return '/' + cls.getPackage().getName().replace('.', '/') + '/' + modelPath.substring(2);
            }
            return modelPath;
        }
    }
}

