/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.llm.baidu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class BaiduAccessTokenManager {
    private static Map<String, TokenInfo> tokenInfoMap = new ConcurrentHashMap<String, TokenInfo>();

    BaiduAccessTokenManager() {
    }

    private static String genMapKey(String apiKey, String securityKey) {
        return apiKey + '#' + securityKey;
    }

    static String getAccessToken(String apiKey, String securityKey) {
        String key = BaiduAccessTokenManager.genMapKey(apiKey, securityKey);
        TokenInfo tokenInfo = tokenInfoMap.get(key);
        if (tokenInfo != null && tokenInfo.expiredTime > System.currentTimeMillis()) {
            return tokenInfo.accessToken;
        }
        return null;
    }

    static void setAccessToken(String apiKey, String securityKey, String accessToken, long expiredTime) {
        String key = BaiduAccessTokenManager.genMapKey(apiKey, securityKey);
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.accessToken = accessToken;
        tokenInfo.expiredTime = expiredTime;
        tokenInfoMap.put(key, tokenInfo);
    }

    static void clearAccessToken(String apiKey, String securityKey) {
        String key = BaiduAccessTokenManager.genMapKey(apiKey, securityKey);
        tokenInfoMap.remove(key);
    }

    private static class TokenInfo {
        String accessToken;
        long expiredTime;

        private TokenInfo() {
        }
    }
}

