/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.gptas.autoact.agent.AgentProxy;
import kd.bos.gptas.autoact.def.Agent;
import kd.bos.gptas.autoact.def.KV;
import kd.bos.gptas.autoact.def.P;
import kd.bos.gptas.autoact.exception.AgentDefineError;
import kd.bos.gptas.autoact.model.ActionModel;
import kd.bos.gptas.autoact.model.Agent;
import kd.bos.gptas.autoact.model.Parameter;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.model.ToolImpl;
import kd.bos.gptas.autoact.output.ReturnType;
import kd.bos.gptas.autoact.util.StringUtil;

public class AgentImpl
extends ToolImpl
implements Agent {
    public static final String NAME_AS = " as ";
    public static final String APP_ID = "app_id";
    public static final String SYSTEM_PROMPT = "system_prompt";
    public static final String DEFAULT_TOOL = "default_tool";
    public static final String DEFAULT_ACTION = "default_action";
    public static final String TOOLS = "tools";
    public static final String EXTERNAL_TOOLS = "external_tools";
    public static final String LLM = "llm";
    private final Class<?> agentClass;
    private String appId;
    private final List<Tool> internalTools = new ArrayList<Tool>();
    private final List<String> externalTools = new ArrayList<String>();
    private String defaultTool;
    private String defaultAction;
    private String llm;
    private transient AgentProxy agentInstance;

    public static Agent from(Class<?> agentCls, JSONObject ... jsonDefinitions) {
        Agent an = AgentImpl._from(agentCls);
        if (jsonDefinitions == null) {
            return an;
        }
        for (JSONObject jd : jsonDefinitions) {
            an = AgentImpl._merge(jd, an);
        }
        return an;
    }

    private static Agent _from(Class<?> agentCls) {
        kd.bos.gptas.autoact.def.Agent aa;
        kd.bos.gptas.autoact.def.Agent agent = aa = agentCls == null ? null : agentCls.getAnnotation(kd.bos.gptas.autoact.def.Agent.class);
        if (aa == null) {
            throw new IllegalArgumentException(agentCls + " is not an agent class.");
        }
        AgentImpl agent2 = new AgentImpl(agentCls);
        agent2.setAppId(aa.appId());
        agent2.externalTools.addAll(Arrays.asList(aa.externalTools()));
        agent2.setDefaultTool(aa.defaultTool());
        agent2.setDefaultAction(aa.defaultAction());
        agent2.setLlm(aa.llm());
        agent2.setName(Agent.Names.getAgentName(agentCls));
        agent2.setIntentPrompt(AgentImpl.getPromptString(aa.intentPrompt()));
        agent2.setSystemPrompt(AgentImpl.getPromptString(aa.systemPrompt()));
        agent2.setActionModel(aa.actionModel());
        agent2.setReturnType(aa.returnType());
        agent2.setAction(aa.action());
        agent2.getBeforeActionTools().addAll(Arrays.asList(aa.beforeActionTools()));
        agent2.getAfterActionTools().addAll(Arrays.asList(aa.afterActionTools()));
        agent2.setBeforeActionModel(aa.beforeActionModel());
        agent2.setAfterActionModel(aa.afterActionModel());
        Map<String, Object> agentProperties = agent2.getProperties();
        for (KV kv : aa.properties()) {
            agentProperties.put(kv.key(), kv.value());
        }
        for (Method method : agentCls.getMethods()) {
            kd.bos.gptas.autoact.def.Tool at;
            if (!Modifier.isPublic(method.getModifiers()) || (at = method.getAnnotation(kd.bos.gptas.autoact.def.Tool.class)) == null) continue;
            ToolImpl tool = new ToolImpl();
            tool.setExport(at.export());
            tool.setName(StringUtil.isEmpty(at.name()) ? method.getName() : at.name());
            tool.setIntentPrompt(AgentImpl.getPromptString(at.intentPrompt()));
            tool.setActionPrompt(AgentImpl.getPromptString(at.actionPrompt()));
            tool.setReturnType(ReturnType.from(method.getReturnType()));
            tool.setActionModel(at.actionModel());
            if (!Modifier.isAbstract(method.getModifiers())) {
                tool.setAction(agentCls.getName() + '#' + method.getName());
            }
            tool.getBeforeActionTools().addAll(Arrays.asList(at.beforeActionTools()));
            tool.getAfterActionTools().addAll(Arrays.asList(at.afterActionTools()));
            tool.setBeforeActionModel(at.beforeActionModel());
            tool.setAfterActionModel(at.afterActionModel());
            Map<String, Object> toolProperties = tool.getProperties();
            for (KV kv : at.properties()) {
                toolProperties.put(kv.key(), kv.value());
            }
            Map<String, String> inputProperties = tool.getInput();
            for (KV kv : at.input()) {
                inputProperties.put(kv.key(), kv.value());
            }
            java.lang.reflect.Parameter[] parameters = method.getParameters();
            List<Parameter> toolParameters = tool.getParameters();
            for (java.lang.reflect.Parameter p : parameters) {
                P ap = p.getAnnotation(P.class);
                if (ap == null) {
                    throw new AgentDefineError(agentCls.getName() + "#" + method.getName() + "'s  parameters should mark with @P.");
                }
                Parameter tp = new Parameter();
                tp.setName(ap.value());
                tp.setType(p.getType().getName());
                tp.setDescription(ap.desc());
                tp.setInputTool(ap.inputTool());
                tp.setRequired(ap.required());
                toolParameters.add(tp);
            }
            agent2.internalTools.add(tool);
        }
        return agent2;
    }

    private static Agent _merge(JSONObject jsonObject, Agent agent) {
        JSONArray refTools;
        JSONArray tools;
        String llm;
        String defaultAction;
        String defaultTool;
        String appId;
        AgentImpl.merge(jsonObject, (AgentImpl)agent);
        String name = jsonObject.getString("name");
        if (name != null && name.contains(NAME_AS)) {
            agent.setName(name.substring(name.lastIndexOf(NAME_AS) + NAME_AS.length()).trim());
        }
        if ((appId = jsonObject.getString(APP_ID)) != null) {
            agent.setAppId(appId);
        }
        if ((defaultTool = jsonObject.getString(DEFAULT_TOOL)) != null) {
            agent.setDefaultTool(defaultTool);
        }
        if ((defaultAction = jsonObject.getString(DEFAULT_ACTION)) != null) {
            agent.setDefaultAction(defaultAction);
        }
        if ((llm = jsonObject.getString(LLM)) != null) {
            agent.setLlm(llm);
        }
        if ((tools = jsonObject.getJSONArray(TOOLS)) != null) {
            HashMap<String, Tool> toolMap = new HashMap<String, Tool>(agent.getInternalTools().size() + 4);
            for (Tool tool : agent.getInternalTools()) {
                toolMap.put(tool.getName(), tool);
            }
            int n = tools.size();
            for (int i = 0; i < n; ++i) {
                JSONObject p = tools.getJSONObject(i);
                Tool tool = (Tool)toolMap.get(p.getString("name"));
                if (tool == null) {
                    tool = new ToolImpl();
                    ((AgentImpl)agent).internalTools.add(tool);
                }
                Tool.merge(p, tool);
            }
        }
        if ((refTools = jsonObject.getJSONArray(EXTERNAL_TOOLS)) != null) {
            HashSet<String> set = new HashSet<String>(((AgentImpl)agent).externalTools);
            int n = refTools.size();
            for (int i = 0; i < n; ++i) {
                set.add(refTools.getString(i));
            }
            ((AgentImpl)agent).externalTools.clear();
            ((AgentImpl)agent).externalTools.addAll(set);
        }
        return agent;
    }

    private static String getPromptString(String[] array) {
        if (array == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public AgentImpl(Class<?> agentClass) {
        this.agentClass = agentClass;
        Parameter parameter = new Parameter();
        parameter.setName("__input__");
        parameter.setType("string");
        this.parameters.add(parameter);
        this.setActionModel(ActionModel.REACT);
    }

    @Override
    public Class<?> getAgentClass() {
        return this.agentClass;
    }

    public AgentProxy getAgentInstance() {
        return this.agentInstance;
    }

    public void setAgentInstance(AgentProxy agentInstance) {
        this.agentInstance = agentInstance;
    }

    @Override
    public List<Tool> getInternalTools() {
        return Collections.unmodifiableList(this.internalTools);
    }

    @Override
    public List<String> getExternalTools() {
        return Collections.unmodifiableList(this.externalTools);
    }

    @Override
    public String getDefaultTool() {
        return this.defaultTool;
    }

    @Override
    public void setDefaultTool(String defaultTool) {
        this.defaultTool = defaultTool;
    }

    @Override
    public String getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
    }

    @Override
    public String getLlm() {
        return this.llm;
    }

    @Override
    public void setLlm(String llm) {
        this.llm = llm;
    }

    public String getAgentType() {
        return this.agentClass.getName();
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public String getSystemPrompt() {
        return super.getActionPrompt();
    }

    @Override
    public void setSystemPrompt(String systemPrompt) {
        super.setActionPrompt(systemPrompt);
    }

    @Override
    public Tool asTool() {
        return this;
    }

    public Tool findMethodTool(Method method) {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (Tool tool : this.internalTools) {
            if (!name.equals(tool.getName()) || parameterTypes.length != tool.getParameters().size()) continue;
            return tool;
        }
        if (method.getName().equals("__input__") && parameterTypes.length == 1) {
            return this;
        }
        throw new AgentDefineError("Agent " + this.getName() + "'s tools define error (not match the actual method): " + method.getDeclaringClass().getName() + '.' + method.getName() + '#' + Arrays.asList(parameterTypes));
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> mm = new LinkedHashMap<String, Object>(32);
        mm.put("name", this.getName());
        mm.put("agent_type", this.agentClass.getName());
        mm.put(APP_ID, this.appId);
        mm.put(LLM, this.llm);
        mm.put("intent_prompt", this.getPromptForToMap(this.getIntentPrompt()));
        mm.put(SYSTEM_PROMPT, this.getPromptForToMap(this.getSystemPrompt()));
        mm.put("action_model", this.getActionModel().name());
        mm.put("action", this.getAction());
        mm.put(DEFAULT_TOOL, this.defaultTool);
        mm.put(DEFAULT_ACTION, this.defaultAction);
        mm.put("return_type", (Object)this.getReturnType());
        mm.put("before_action_tools", this.getBeforeActionTools());
        mm.put("before_action_model", this.getBeforeActionModel().name());
        mm.put("after_action_tools", this.getAfterActionTools());
        mm.put("after_action_model", this.getAfterActionModel().name());
        ArrayList<Map<String, Object>> tools = new ArrayList<Map<String, Object>>(this.internalTools.size());
        for (Tool tool : this.internalTools) {
            tools.add(((ToolImpl)tool).toMap());
        }
        mm.put(TOOLS, tools);
        mm.put(EXTERNAL_TOOLS, this.externalTools);
        mm.put("properties", this.getProperties());
        return mm;
    }
}

