/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.gptas.autoact.def.ToolAction;
import kd.bos.gptas.autoact.model.Action;
import kd.bos.gptas.autoact.model.ActionType;
import kd.bos.gptas.autoact.util.StringUtil;

public class TaskAction
implements Action<String, String> {
    private TaskAction parent;
    private List<TaskAction> subTaskActions = new ArrayList<TaskAction>();
    private final Action<String, String> executor;
    private String content;

    public TaskAction(Action<String, String> executor) {
        this("", executor);
    }

    public TaskAction(String content, Action<String, String> executor) {
        this.content = content;
        this.executor = executor;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.TASK;
    }

    public void addSub(TaskAction subTaskAction) {
        subTaskAction.parent = this;
        this.subTaskActions.add(subTaskAction);
    }

    @Override
    @ToolAction
    public String act(String msg) {
        if (this.subTaskActions.isEmpty()) {
            return this.executor.act(msg);
        }
        StringBuilder merged = new StringBuilder(512);
        merged.append(msg).append("\n");
        int subTaskLevel = this.calcTaskLevel() + 1;
        int i = 0;
        for (TaskAction taskAction : this.subTaskActions) {
            String indent = StringUtil.multiString("  ", subTaskLevel - 1);
            merged.append(indent).append(++i).append(": ").append(taskAction.act(taskAction.content)).append("\n");
        }
        return this.executor.act(merged.toString());
    }

    private int calcTaskLevel() {
        int i = 1;
        TaskAction taskAction = this;
        while (taskAction.parent != null) {
            ++i;
            taskAction = taskAction.parent;
        }
        return i;
    }
}

