/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.output.OutputParser;
import kd.bos.gptas.autoact.util.JsonUtil;
import kd.bos.gptas.autoact.util.Resources;

public abstract class AbstractOutputParser<T>
implements OutputParser<T>,
Logable {
    private static final String RESOURCE_OUTPUT_FORMAT_PROMPT = "output_format_prompt.json";
    private static final Map<String, JSONObject> pmap = new ConcurrentHashMap<String, JSONObject>();

    private static JSONObject getParserPromptJsonObject(String modelName) {
        JSONObject ret = pmap.get(modelName);
        if (ret == null) {
            String template = Resources.loadAlternative(RESOURCE_OUTPUT_FORMAT_PROMPT, modelName, AbstractOutputParser.class);
            ret = template != null ? JsonUtil.parseObject(template) : new JSONObject();
            pmap.put(modelName, ret);
        }
        return ret;
    }

    @Override
    public String outputFormatPrompt(String modelName) {
        JSONObject json = AbstractOutputParser.getParserPromptJsonObject(modelName);
        String ret = json.getString(this.getClass().getSimpleName());
        return ret == null ? "" : ret;
    }
}

