/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output.convert;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.gptas.autoact.message.BufferedMessageStream;
import kd.bos.gptas.autoact.message.MessageStream;
import kd.bos.gptas.autoact.output.convert.InvokeDataType;
import kd.bos.gptas.autoact.util.DateUtil;
import kd.bos.gptas.autoact.util.JsonUtil;

public final class ObjectConverter {
    public static final BigDecimal ZERO_BIGDECIMAL = BigDecimal.ZERO;
    public static final Long ZERO_LONG = 0L;
    public static final Integer ZERO_INTEGER = 0;
    public static final Double ZERO_DOUBLE = new Double(0.0);
    public static final Float ZERO_FLOAT = new Float(0.0f);
    public static final Short ZERO_SHORT = 0;
    public static final Byte ZERO_BYTE = 0;
    private static Map<Class<?>, Converter<?>> converterMap = new HashMap();

    public static <T> T convert(Object value, Class<T> cls) throws ClassCastException {
        if (cls == null || cls == Object.class || value != null && cls.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        Converter<?> converter = converterMap.get(cls);
        if (converter != null) {
            return (T)converter.convert(value);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof MessageStream) {
            value = ((MessageStream)value).fetch();
        }
        if (cls == String.class) {
            return (T)String.valueOf(value);
        }
        if (MessageStream.class.isAssignableFrom(cls)) {
            return (T)new BufferedMessageStream(String.valueOf(value));
        }
        if (InvokeDataType.isSingleValue(value, false)) {
            throw new ClassCastException("Can't convert to " + cls.getName() + ": " + value);
        }
        try {
            return JsonUtil.parseObject(JsonUtil.toJSONString(value, new SerializerFeature[0]), cls);
        }
        catch (JSONException e) {
            throw new ClassCastException(e.getMessage());
        }
    }

    static {
        converterMap.put(String.class, new StringConverter());
        LongConverter longc = new LongConverter();
        converterMap.put(Long.class, longc);
        converterMap.put(Long.TYPE, longc);
        IntegerConverter intc = new IntegerConverter();
        converterMap.put(Integer.class, intc);
        converterMap.put(Integer.TYPE, intc);
        ShortConverter shortc = new ShortConverter();
        converterMap.put(Short.class, shortc);
        converterMap.put(Short.TYPE, shortc);
        FloatConverter floatc = new FloatConverter();
        converterMap.put(Float.class, floatc);
        converterMap.put(Float.TYPE, floatc);
        DoubleConverter doublec = new DoubleConverter();
        converterMap.put(Double.class, doublec);
        converterMap.put(Double.TYPE, doublec);
        ByteConverter bytec = new ByteConverter();
        converterMap.put(Byte.class, bytec);
        converterMap.put(Byte.TYPE, bytec);
        BooleanConverter booleanc = new BooleanConverter();
        converterMap.put(Boolean.class, booleanc);
        converterMap.put(Boolean.TYPE, booleanc);
        CharConverter charc = new CharConverter();
        converterMap.put(Character.class, charc);
        converterMap.put(Character.TYPE, charc);
        converterMap.put(BigDecimal.class, new BigDecimalConverter());
        DateConverter datec = new DateConverter();
        converterMap.put(java.util.Date.class, datec);
        converterMap.put(Timestamp.class, new SQLTimestampConverter());
        converterMap.put(Date.class, new SQLDateConverter());
        converterMap.put(Time.class, new SQLTimeConverter());
    }

    public static class SQLTimestampConverter
    extends DateConverter {
        @Override
        public java.util.Date convert(Object value) {
            java.util.Date ret = super.convert(value);
            if (value != null && !(ret instanceof Timestamp)) {
                return new Timestamp(ret.getTime());
            }
            return ret;
        }
    }

    public static class SQLTimeConverter
    extends DateConverter {
        @Override
        public java.util.Date convert(Object value) {
            java.util.Date ret = super.convert(value);
            if (value != null && !(ret instanceof Time)) {
                return new Time(ret.getTime());
            }
            return ret;
        }
    }

    public static class SQLDateConverter
    extends DateConverter {
        @Override
        public java.util.Date convert(Object value) {
            java.util.Date ret = super.convert(value);
            if (value != null && !(ret instanceof Date)) {
                return new Date(ret.getTime());
            }
            return ret;
        }
    }

    public static class DateConverter
    implements Converter<java.util.Date> {
        private static final ThreadLocal<SimpleDateFormat> datetime = ThreadLocal.withInitial(() -> DateUtil.getDateFormat("yyyy-MM-dd HH:mm:ss"));
        private static final ThreadLocal<SimpleDateFormat> date = ThreadLocal.withInitial(() -> DateUtil.getDateFormat("yyyy-MM-dd"));
        private static final ThreadLocal<SimpleDateFormat> time = ThreadLocal.withInitial(() -> DateUtil.getDateFormat("HH:mm:ss"));

        @Override
        public java.util.Date convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof java.util.Date) {
                return (java.util.Date)value;
            }
            if (value instanceof Number) {
                return new java.util.Date(((Number)value).longValue());
            }
            String s = String.valueOf(value).trim();
            if (s.length() == 0) {
                return null;
            }
            if (s.matches("\\d+")) {
                return new java.util.Date(Long.parseLong(s));
            }
            try {
                s = s.replace('.', '-');
                if (s.indexOf(32) != -1) {
                    return datetime.get().parse(s);
                }
                if (s.indexOf(58) != -1) {
                    return time.get().parse(s);
                }
                return date.get().parse(s);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Date format error: " + s, e);
            }
        }
    }

    static class BigDecimalConverter
    implements Converter<BigDecimal> {
        BigDecimalConverter() {
        }

        @Override
        public BigDecimal convert(Object value) {
            if (value == null) {
                return ZERO_BIGDECIMAL;
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                if (value instanceof Float) {
                    return new BigDecimal(Float.toString(((Float)value).floatValue()));
                }
                if (value instanceof Double) {
                    return new BigDecimal(Double.toString((Double)value));
                }
                return BigDecimal.valueOf(((Number)value).doubleValue());
            }
            return new BigDecimal(String.valueOf(value));
        }
    }

    static class ByteConverter
    implements Converter<Byte> {
        ByteConverter() {
        }

        @Override
        public Byte convert(Object value) {
            if (value instanceof String && ((String)value).length() > 0) {
                return Byte.valueOf((String)value);
            }
            if (value instanceof Byte) {
                return (Byte)value;
            }
            return null;
        }
    }

    static class CharConverter
    implements Converter<Character> {
        CharConverter() {
        }

        @Override
        public Character convert(Object value) {
            if (value instanceof String && ((String)value).length() > 0) {
                return Character.valueOf(((String)value).charAt(0));
            }
            if (value instanceof Character) {
                return (Character)value;
            }
            return null;
        }
    }

    static class BooleanConverter
    implements Converter<Boolean> {
        BooleanConverter() {
        }

        @Override
        public Boolean convert(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            String s = String.valueOf(value).trim();
            if ("1".equals(s)) {
                return true;
            }
            return Boolean.valueOf(s);
        }
    }

    static class ShortConverter
    implements Converter<Short> {
        ShortConverter() {
        }

        @Override
        public Short convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return (short)0;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(String.valueOf(value));
        }
    }

    static class DoubleConverter
    implements Converter<Double> {
        DoubleConverter() {
        }

        @Override
        public Double convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0.0;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(String.valueOf(value));
        }
    }

    static class FloatConverter
    implements Converter<Float> {
        FloatConverter() {
        }

        @Override
        public Float convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return Float.valueOf(0.0f);
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(String.valueOf(value)));
        }
    }

    static class IntegerConverter
    implements Converter<Integer> {
        IntegerConverter() {
        }

        @Override
        public Integer convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(String.valueOf(value));
        }
    }

    static class LongConverter
    implements Converter<Long> {
        LongConverter() {
        }

        @Override
        public Long convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0L;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(String.valueOf(value));
        }
    }

    static class StringConverter
    implements Converter<String> {
        StringConverter() {
        }

        @Override
        public String convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof MessageStream) {
                return ((MessageStream)value).fetch();
            }
            return String.valueOf(value);
        }
    }

    static interface Converter<T> {
        public T convert(Object var1);
    }
}

