/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import kd.bos.gptas.autoact.exception.NoScriptCodeBlockException;
import kd.bos.gptas.autoact.exception.OutputParseException;
import kd.bos.gptas.autoact.output.AbstractOutputParser;
import kd.bos.gptas.autoact.output.parser.CodeBlockExtractor;
import kd.bos.gptas.autoact.util.JsonUtil;

public abstract class AbstractCollectionParser<T extends Collection>
extends AbstractOutputParser<T> {
    @Override
    public T parse(String text) {
        try {
            text = CodeBlockExtractor.extractFirst("json", text);
        }
        catch (NoScriptCodeBlockException noScriptCodeBlockException) {
            // empty catch block
        }
        if (text.startsWith("{")) {
            JSONObject jsonObject = JsonUtil.parseObject(text);
            if (jsonObject.keySet().size() == 1) {
                return this.to(jsonObject.getJSONArray((String)jsonObject.keySet().iterator().next()));
            }
            throw new OutputParseException("Return json format error(not an array): " + text);
        }
        return this.to(JsonUtil.parseArray(text));
    }

    abstract T to(JSONArray var1);
}

