/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output.parser;

import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.output.AbstractOutputParser;
import kd.bos.gptas.autoact.output.parser.CodeBlockExtractor;

public abstract class AbstractExecScriptParser<T>
extends AbstractOutputParser<T> {
    public static final String VAR_RETURN = "__result";
    protected final String language;
    protected final Class<?> returnType;
    protected final AgentContext ctx;

    public AbstractExecScriptParser(String language, Class<?> returnType, AgentContext ctx) {
        this.language = language;
        this.returnType = returnType;
        this.ctx = ctx;
    }

    @Override
    public T parse(String text) {
        String script = CodeBlockExtractor.extractFirst(this.language, text);
        script = script.replace("let ", "var ").replace("const ", "var ");
        script = AbstractExecScriptParser.addResultCode(script);
        if (AgentContext.getCurrent().isVerbose() && logger.isInfoEnabled()) {
            logger.info("Execute " + this.language + "\n-------------------------------------\n" + script + "\n-------------------------------------");
        }
        return this.execute(script);
    }

    static String addResultCode(String code) {
        CharSequence[] parts = code.split("\n");
        String lastPart = parts[parts.length - 1];
        if (lastPart.startsWith("console.log")) {
            parts[parts.length - 1] = "var __result=" + lastPart.substring(11);
        } else if (lastPart.startsWith("var ")) {
            int p = lastPart.indexOf(61);
            String varName = lastPart.substring(3, p).trim();
            parts[parts.length - 1] = lastPart + "\nvar " + VAR_RETURN + '=' + varName + ';';
        } else if (!lastPart.startsWith("var __result")) {
            parts[parts.length - 1] = "var __result=(" + lastPart.replace(";", "") + ");";
        }
        String fixedCode = String.join((CharSequence)"\n", parts);
        return fixedCode;
    }

    protected abstract T execute(String var1);
}

