/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output.parser;

import java.util.Arrays;
import kd.bos.gptas.autoact.exception.OutputParseException;
import kd.bos.gptas.autoact.output.AbstractOutputParser;

public final class EnumParser
extends AbstractOutputParser<Enum> {
    private final Class<? extends Enum> enumClass;

    public EnumParser(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public Enum parse(String text) {
        for (Enum em : this.enumClass.getEnumConstants()) {
            if (!em.name().equalsIgnoreCase(text)) continue;
            return em;
        }
        throw new OutputParseException(text + " is not an enum value of " + this.enumClass.getName());
    }

    @Override
    public String outputFormatPrompt(String modelName) {
        return "\nYou must answer strictly in one of " + Arrays.toString(this.enumClass.getEnumConstants()) + ".";
    }
}

