/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output.parser;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.gptas.autoact.output.AbstractOutputParser;
import kd.bos.gptas.autoact.output.parser.CodeBlockExtractor;
import kd.bos.gptas.autoact.prompt.Prompt;
import kd.bos.gptas.autoact.util.JsonUtil;

public class POJOParser<T>
extends AbstractOutputParser<T> {
    public static final String VAR_JSON_STRUCT = "json_struct";
    private final Class<T> returnType;

    public POJOParser(Class<T> returnType) {
        this.returnType = returnType;
    }

    @Override
    public T parse(String text) {
        String jsonString = CodeBlockExtractor.extractFirst("json", text);
        if (this.returnType == null) {
            return (T)JsonUtil.parseObject(jsonString);
        }
        return JsonUtil.parseObject(jsonString, this.returnType);
    }

    @Override
    public String outputFormatPrompt(String modelName) {
        String formatPrompt = super.outputFormatPrompt(modelName);
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        varMap.put(VAR_JSON_STRUCT, POJOParser.jsonStructure(this.returnType));
        formatPrompt = new Prompt(formatPrompt, varMap).getContent();
        return formatPrompt;
    }

    private static String jsonStructure(Class<?> structured) {
        if (List.class.isAssignableFrom(structured)) {
            return "[]";
        }
        StringBuilder jsonSchema = new StringBuilder();
        jsonSchema.append("{\n");
        for (Field field : structured.getDeclaredFields()) {
            String name = field.getName();
            jsonSchema.append(String.format("\"%s\": (%s),\n", name, POJOParser.descriptionFor(field)));
        }
        jsonSchema.append("}");
        return jsonSchema.toString();
    }

    private static String descriptionFor(Field field) {
        return "type: " + POJOParser.typeOf(field);
    }

    private static String typeOf(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (parameterizedType.getRawType().equals(List.class) || parameterizedType.getRawType().equals(Set.class)) {
                return String.format("array of %s", POJOParser.simpleTypeName(typeArguments[0]));
            }
        } else {
            if (field.getType().isArray()) {
                return String.format("array of %s", POJOParser.simpleTypeName(field.getType().getComponentType()));
            }
            if (((Class)type).isEnum()) {
                return "enum, must be one of " + Arrays.toString(((Class)type).getEnumConstants());
            }
        }
        return POJOParser.simpleTypeName(type);
    }

    private static String simpleTypeName(Type type) {
        switch (type.getTypeName()) {
            case "java.lang.String": {
                return "string";
            }
            case "java.lang.Integer": 
            case "int": {
                return "integer";
            }
            case "java.lang.Boolean": 
            case "boolean": {
                return "boolean";
            }
            case "java.lang.Float": 
            case "float": {
                return "float";
            }
            case "java.lang.Double": 
            case "double": {
                return "double";
            }
            case "java.util.Date": 
            case "java.time.LocalDate": {
                return "date string (2024-02-19)";
            }
            case "java.time.LocalTime": {
                return "time string (16:57:59)";
            }
            case "java.time.LocalDateTime": {
                return "date-time string (2024-02-19T16:57:59)";
            }
        }
        return type.getTypeName();
    }
}

