/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.prompt.var;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kd.bos.gptas.autoact.exception.GetVarExpressionException;
import kd.bos.gptas.autoact.prompt.var.VarProvider;

final class VarUtil {
    VarUtil() {
    }

    static Object getByExpression(VarProvider vp, String exp) {
        if (!vp.containsKey(exp)) {
            int p1 = exp.indexOf(91);
            int p2 = exp.lastIndexOf(46);
            if (p1 != -1 && (p2 == -1 || p1 > p2)) {
                String arrayDef = exp.substring(p1);
                String property = exp.substring(0, p1);
                Object ret = VarUtil.getByExpression(vp, property);
                if (ret == null) {
                    throw new GetVarExpressionException("Var not found: " + exp);
                }
                return VarUtil.getArrayPropertyValue(ret, property, arrayDef, exp);
            }
            if (p2 == -1) {
                return null;
            }
            String property = exp.substring(p2 + 1);
            String parentKey = exp.substring(0, p2);
            Object parentObject = VarUtil.getByExpression(vp, parentKey);
            if (parentObject == null) {
                throw new GetVarExpressionException("Var not found: " + exp);
            }
            return VarUtil.getObjectProperty(parentObject, property);
        }
        return vp.get(exp);
    }

    private static Object getArrayPropertyValue(Object ret, String property, String arrayDef, String exp) {
        for (String seg : arrayDef.split("\\[")) {
            if (seg.isEmpty()) continue;
            seg = seg.replace("]", "");
            if (ret == null) {
                throw new GetVarExpressionException(property + " is null: " + exp);
            }
            if (ret.getClass().isArray()) {
                ret = Array.get(ret, Integer.parseInt(seg));
                continue;
            }
            if (ret instanceof List) {
                ret = ((List)ret).get(Integer.parseInt(seg));
                continue;
            }
            throw new GetVarExpressionException(property + " is not an array or list: " + exp);
        }
        return ret;
    }

    private static Object getObjectProperty(Object parentObject, String property) {
        Class<?> cls = parentObject.getClass();
        try {
            String uProperty = property;
            uProperty = uProperty.isEmpty() ? uProperty.toUpperCase() : Character.toUpperCase(uProperty.charAt(0)) + uProperty.substring(1);
            String name = uProperty;
            try {
                Method method = cls.getMethod(name, new Class[0]);
                method.setAccessible(true);
                return method.invoke(parentObject, new Object[0]);
            }
            catch (NoSuchMethodException method) {
                name = "get" + uProperty;
                try {
                    Method method2 = cls.getMethod(name, new Class[0]);
                    method2.setAccessible(true);
                    return method2.invoke(parentObject, new Object[0]);
                }
                catch (NoSuchMethodException method2) {
                    name = "is" + uProperty;
                    try {
                        Method method3 = cls.getMethod(name, new Class[0]);
                        method3.setAccessible(true);
                        return method3.invoke(parentObject, new Object[0]);
                    }
                    catch (NoSuchMethodException method3) {
                        for (Method method4 : cls.getMethods()) {
                            if (method4.getParameterCount() != 0 || !(name = method4.getName()).equalsIgnoreCase(property) && !name.equalsIgnoreCase("is" + property) && !name.equalsIgnoreCase("get" + property)) continue;
                            method4.setAccessible(true);
                            return method4.invoke(parentObject, new Object[0]);
                        }
                        try {
                            Field field = cls.getField(property);
                            field.setAccessible(true);
                            return field.get(parentObject);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            if (parentObject instanceof Map) {
                                return ((Map)parentObject).get(property);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new GetVarExpressionException(e);
        }
        throw new GetVarExpressionException("\"" + property + "\" not found in " + parentObject + ".");
    }
}

