/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.retriever;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;

public class ReciprocalRankFusion {
    public static List<String> fuse(Collection<List<String>> lists) {
        return ReciprocalRankFusion.fuse(lists, 60);
    }

    public static List<String> fuse(Collection<List<String>> lists, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("Incorrect k: " + k);
        }
        LinkedHashMap<String, Double> scoreMap = new LinkedHashMap<String, Double>();
        for (List<String> list : lists) {
            for (int i = 0; i < list.size(); ++i) {
                String s = list.get(i);
                double score = scoreMap.getOrDefault(s, 0.0) + 1.0 / (double)(k + i + 1);
                scoreMap.put(s, score);
            }
        }
        ArrayList<String> fused = new ArrayList<String>(scoreMap.keySet());
        fused.sort(Comparator.comparingDouble(scoreMap::get).reversed());
        return fused;
    }
}

