/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.shell;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.Agents;
import kd.bos.gptas.autoact.agent.ChatBot;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.memory.ChatMemory;
import kd.bos.gptas.autoact.tools.javascript.JavaScriptCalculator;
import kd.bos.gptas.autoact.tools.translator.LanguageTranslator;
import kd.bos.gptas.autoact.tools.weather.WeatherForecast;
import kd.bos.gptas.autoact.tools.websearcher.WebSearcher;

public class AutoActShell
implements Logable {
    private AgentContext ctx;
    private Map<String, Object> agentMap = new TreeMap<String, Object>();
    private ChatBot chatBot = Agents.chatBotBuilder().build();
    private Object currentAgent;

    public AutoActShell() {
        this("You are a helpful assistant");
    }

    public AutoActShell(String prompt) {
        this.agentMap.put("default", this.chatBot);
        this.switchAgent(this.chatBot);
        this.ctx.getAgent().setSystemPrompt(prompt);
    }

    private void switchAgent(Object agent) {
        this.currentAgent = agent;
        this.ctx = Agents.getAgentContext(agent);
        this.ctx.setVerbose(false);
    }

    public void addAgent(String name, Object agentObject) {
        this.agentMap.put(name, agentObject);
        if (agentObject != this.chatBot) {
            this.ctx.addAgentAsTool(agentObject);
        }
    }

    public void run() {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        PrintStream output = System.out;
        output.println("AutoAct Shell for " + this.ctx.getAgent().getAgentClass() + ":");
        output.println("cmd: {{message}}, @{{agent}}, clear, verbose, bye");
        block2: while (true) {
            try {
                while (true) {
                    output.print("AutoAct> ");
                    String line = input.readLine();
                    if (line == null || line.equals("bye")) break block2;
                    if ("verbose".equals(line)) {
                        this.ctx.setVerbose(!this.ctx.isVerbose());
                        output.println("set verbose=" + this.ctx.isVerbose());
                        continue;
                    }
                    if ("clear".equals(line)) {
                        ChatMemory memory = this.ctx.getMemory();
                        int round = memory.round();
                        int history = memory.messages().size();
                        memory.clear();
                        output.println("Last is " + round + "'th round, " + history + " history messages was cleared.");
                        continue;
                    }
                    if (line.startsWith("@") && line.indexOf(32) == -1) {
                        String name = line.substring(1);
                        Object switchAssistant = this.agentMap.get(name);
                        if (switchAssistant == null) {
                            output.println("Not found agent: " + name);
                            output.println("All agents: " + this.agentMap.keySet());
                            continue;
                        }
                        this.switchAgent(switchAssistant);
                        output.println("The current agent has been set to: [" + name + "] " + this.ctx.getAgent().getAgentClass().getName());
                        continue;
                    }
                    if (line.isEmpty()) continue;
                    String ret = (String)Agents.callAgent(this.currentAgent, line);
                    output.println(ret);
                }
            }
            catch (Exception t) {
                logger.error(t.getMessage(), (Throwable)t);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        WebSearcher ws = Agents.builder(WebSearcher.class).verbose(true).build();
        JavaScriptCalculator calc = Agents.builder(JavaScriptCalculator.class).verbose(false).build();
        WeatherForecast forecast = Agents.builder(WeatherForecast.class).verbose(false).build();
        LanguageTranslator translator = new LanguageTranslator("German");
        Agents.getAgentContext(translator.getAgentObject()).setVerbose(false);
        AutoActShell shell = new AutoActShell();
        shell.addAgent("WeatherForecast", forecast);
        shell.addAgent("JavaScriptCalculator", calc);
        shell.addAgent("LanguageTranslator", translator.getAgentObject());
        shell.run();
    }
}

