/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.tools.weather;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import kd.bos.gptas.autoact.def.ToolAction;
import kd.bos.gptas.autoact.model.Action;
import kd.bos.gptas.autoact.util.HttpUtil;
import kd.bos.gptas.autoact.util.JsonUtil;

public class SearchCityWeatherAction
implements Action<String, String> {
    private static Map<String, Integer> cityCodeMap;

    private static synchronized void ensureLoadCityCode() {
        if (cityCodeMap == null) {
            try (InputStream is = SearchCityWeatherAction.class.getResourceAsStream("city.json");
                 InputStreamReader reader = new InputStreamReader(is);){
                int len;
                StringBuilder template = new StringBuilder(2048);
                char[] buf = new char[1024];
                while ((len = reader.read(buf)) != -1) {
                    template.append(buf, 0, len);
                }
                cityCodeMap = new HashMap<String, Integer>();
                JSONArray jsonArray = JsonUtil.parseArray(template.toString());
                int n = jsonArray.size();
                for (int i = 0; i < n; ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    cityCodeMap.put(jsonObject.getString("area"), jsonObject.getIntValue("code"));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Read resource city.json error: " + e.getMessage(), e);
            }
        }
    }

    @Override
    @ToolAction
    public String act(String city) {
        Integer code;
        SearchCityWeatherAction.ensureLoadCityCode();
        int p = city.indexOf(10);
        if (p != -1) {
            city = city.substring(0, p).trim();
        }
        if ((code = cityCodeMap.get(city)) == null) {
            return "Unknown city: " + city;
        }
        String url = "http://t.weather.sojson.com/api/weather/city/" + code;
        String content = HttpUtil.get(url);
        JSONObject jsonObject = JsonUtil.parseObject(content);
        return jsonObject.getJSONObject("data").toString();
    }
}

