/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.instance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import kd.bos.instance.GrayUpdateExtension;
import kd.bos.instance.Instance;
import kd.bos.instance.MainGroupChangeListener;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppGroup {
    private static final String KEY_MAINAPPGROUP = "mainAppGroup";
    private static final String KEY_CURAPPGROUP = "curAppGroup";
    private static final String KEY_ISGRAYUPGRADE = "isGrayUpgrade";
    private static final String KEY_PREMAINGRAYGROUP = "preMainAppGroup";
    private static final String KEY_GRAYINGAPPGROUP = "grayingAppGroup";
    private static final String KEY_GRAYINGGROUPWITHACCOUNT = "grayingGroupWithAccount";
    private static Map<String, String> mainGroups;
    private static Map<String, Set<String>> preMainAppGroupMap;
    private static Map<String, Set<String>> grayingAppGroup;
    private static Map<String, Set<String>> grayingGroupWithAccount;
    private static String curAppGroup;
    private static boolean grayUpgrade;
    private static Map<String, Boolean> isGrayAppMap;
    public static final String DEFAULTAPPGROUP = "defaultGroup";
    public static final String ALL = "*";
    private static final Logger log;
    private static final List<MainGroupChangeListener> groupChangeListeners;
    private static String metaGroupAppid;

    private static void init() {
        try {
            preMainAppGroupMap = AppGroup.initPreMainAppGroup();
            mainGroups = AppGroup.initMainGroup();
            metaGroupAppid = AppGroup.initMetaGroupAppid();
            grayingAppGroup = AppGroup.initGrayingAppGroup();
            grayingGroupWithAccount = AppGroup.initGrayingGroupWithAccount();
            curAppGroup = GrayUpdateExtension.getExtension().preHandleCurAppGroup(SystemProperties.getWithEnv(KEY_CURAPPGROUP));
            mainGroups.forEach((k, v) -> isGrayAppMap.put((String)k, curAppGroup == null ? false : !v.equals(curAppGroup)));
            grayUpgrade = Boolean.parseBoolean(SystemProperties.getWithEnv(KEY_ISGRAYUPGRADE));
        }
        catch (Exception e) {
            log.error("AppGroup init error", (Throwable)e);
        }
    }

    public static synchronized void registGroupListener(MainGroupChangeListener listener) {
        groupChangeListeners.add(listener);
    }

    private static Map<String, Set<String>> initGrayingAppGroup() {
        return AppGroup._initMapSet(KEY_GRAYINGAPPGROUP);
    }

    private static Map<String, Set<String>> initGrayingGroupWithAccount() {
        HashMap<String, Set<String>> s = new HashMap<String, Set<String>>(2);
        String str = System.getProperty(KEY_GRAYINGGROUPWITHACCOUNT);
        if (str != null && str.length() > 0) {
            String[] arr;
            for (String groupOne : arr = str.split(",|;")) {
                String[] appids;
                String[] groupOnes = groupOne.split("=");
                if (groupOnes.length != 2) continue;
                String groupName = groupOnes[0];
                for (String appid : appids = groupOnes[1].split("#")) {
                    Set groupSet = s.computeIfAbsent(groupName, k -> new HashSet(1));
                    groupSet.add(appid);
                }
            }
        }
        return s;
    }

    private static Map<String, Set<String>> initPreMainAppGroup() {
        return AppGroup._initMapSet(KEY_PREMAINGRAYGROUP);
    }

    private static String initMetaGroupAppid() {
        String[] ids;
        String str = SystemProperties.getWithEnv("appIds");
        String _id = null;
        if (str != null) {
            ids = Instance.parseAppIds(str);
            _id = AppGroup.getIds(ids);
        }
        if (_id == null && (str = System.getProperty("appIdsFromAppStore")) != null) {
            ids = Instance.parseAppIds(str);
            _id = AppGroup.getIds(ids);
        }
        return _id;
    }

    private static String getIds(String[] ids) {
        String _id = null;
        for (String id : ids) {
            if (id.trim().length() == 0 || "bos".equals(id) || "bd".equals(id) || "base".equals(id)) continue;
            _id = id;
            break;
        }
        return _id;
    }

    public static synchronized void unRegistGroupListener(MainGroupChangeListener listener) {
        groupChangeListeners.remove(listener);
    }

    public static String getMainAppGroup(String appid) {
        String mainGroup = mainGroups.get(appid);
        return mainGroup == null ? DEFAULTAPPGROUP : mainGroup;
    }

    public static String getRegistyAppGroup(String appid) {
        if (AppGroup.isGrayUpgrade()) {
            String curAppGroup = AppGroup.getCurAppGroup();
            if (curAppGroup == null) {
                return AppGroup.getMainAppGroup(appid);
            }
            return curAppGroup;
        }
        return DEFAULTAPPGROUP;
    }

    public static String getMetaLookupAppGroup(String appid) {
        if (AppGroup.isGrayUpgrade()) {
            String curAppGroup = AppGroup.getCurAppGroup();
            if (curAppGroup == null) {
                return DEFAULTAPPGROUP;
            }
            String mainGroup = AppGroup.getMainAppGroup(appid);
            Set<String> preMainGroup = preMainAppGroupMap.get(appid);
            if (curAppGroup.equals(mainGroup) || preMainGroup != null && preMainGroup.contains(curAppGroup)) {
                return DEFAULTAPPGROUP;
            }
            return curAppGroup;
        }
        return DEFAULTAPPGROUP;
    }

    public static String getMetaLookupAppGroup() {
        if (AppGroup.isGrayUpgrade() && metaGroupAppid != null) {
            return AppGroup.getMetaLookupAppGroup(metaGroupAppid);
        }
        return DEFAULTAPPGROUP;
    }

    public static String getCurAppGroup() {
        return curAppGroup;
    }

    public static boolean isCurrentGrayNode(String appid) {
        if (AppGroup.isGrayUpgrade()) {
            String curAppGroup = AppGroup.getCurAppGroup();
            if (curAppGroup == null) {
                return false;
            }
            String mainGroup = AppGroup.getMainAppGroup(appid);
            return !curAppGroup.equals(mainGroup);
        }
        return false;
    }

    public static String getCurrentGrayAppGroup(String appid) {
        if (AppGroup.isCurrentGrayNode(appid)) {
            return AppGroup.getCurAppGroup();
        }
        return null;
    }

    public static String getCurrentGrayAppGroup() {
        if (AppGroup.isCurrentGrayNode(metaGroupAppid)) {
            return AppGroup.getCurAppGroup();
        }
        return null;
    }

    public static boolean isCurrentGrayNode() {
        return AppGroup.isCurrentGrayNode(metaGroupAppid);
    }

    public static Set<String> getGrayingAppGroup(String appid) {
        Set<String> s;
        if (grayingAppGroup.containsKey(ALL)) {
            appid = ALL;
        }
        return (s = grayingAppGroup.get(appid)) == null ? Collections.emptySet() : s;
    }

    public static Set<String> getGrayingAccountGroup(String accountid) {
        Set<String> s = grayingGroupWithAccount.get(accountid);
        return s == null ? Collections.emptySet() : s;
    }

    public static String getGrayingAccountGroup(String appid, String accountid) {
        Set<String> s;
        if (grayingAppGroup.containsKey(ALL)) {
            appid = ALL;
        }
        if ((s = grayingAppGroup.get(appid)) == null) {
            return null;
        }
        if (s.size() == 1) {
            return s.iterator().next();
        }
        Set<String> accountGroupSet = grayingGroupWithAccount.get(accountid);
        if (accountGroupSet != null) {
            HashSet<String> retain = new HashSet<String>(2);
            retain.addAll(s);
            retain.retainAll(accountGroupSet);
            if (!retain.isEmpty()) {
                return (String)retain.iterator().next();
            }
        }
        return null;
    }

    public static boolean isGrayUpgrade() {
        if (!Instance.isAppSplit()) {
            return false;
        }
        return grayUpgrade;
    }

    private static Map<String, String> initMainGroup() {
        HashMap<String, String> groups = new HashMap<String, String>();
        String groupsStr = System.getProperty(KEY_MAINAPPGROUP);
        if (groupsStr != null && groupsStr.length() > 0) {
            try {
                String[] groupPairs;
                for (String groupPair : groupPairs = groupsStr.split(",|;")) {
                    String[] result = groupPair.split("=");
                    String appid = result[0];
                    String appgroup = result[1];
                    groups.put(appid, appgroup);
                }
            }
            catch (Exception e) {
                log.error("AppGroup parse mainAppGroup error :" + groupsStr, (Throwable)e);
            }
        }
        return groups;
    }

    private static Map<String, Set<String>> _initMapSet(String propertyKey) {
        HashMap<String, Set<String>> s = new HashMap<String, Set<String>>(2);
        String str = System.getProperty(propertyKey);
        if (str != null && str.length() > 0) {
            String[] arr;
            for (String groupOne : arr = str.split(",|;")) {
                String[] appids;
                String[] groupOnes = groupOne.split("=");
                if (groupOnes.length != 2) continue;
                String groupName = groupOnes[0];
                for (String appid : appids = groupOnes[1].split("#")) {
                    Set groupSet = s.computeIfAbsent(appid, k -> new HashSet(1));
                    groupSet.add(groupName);
                }
            }
        }
        return s;
    }

    static {
        isGrayAppMap = new ConcurrentHashMap<String, Boolean>(2);
        log = LoggerFactory.getLogger(AppGroup.class);
        groupChangeListeners = new ArrayList<MainGroupChangeListener>(2);
        AppGroup.init();
        ConfigurationUtil.observeChange(KEY_GRAYINGAPPGROUP, new ConfigurationChangeListener(){

            @Override
            public void onChange(Object key, Object newValue) {
                grayingAppGroup = AppGroup.initGrayingAppGroup();
            }
        });
        ConfigurationUtil.observeChange(KEY_PREMAINGRAYGROUP, new ConfigurationChangeListener(){

            @Override
            public void onChange(Object key, Object newValue) {
                preMainAppGroupMap = AppGroup.initPreMainAppGroup();
            }
        });
        ConfigurationUtil.observeChange(KEY_GRAYINGGROUPWITHACCOUNT, new ConfigurationChangeListener(){

            @Override
            public void onChange(Object key, Object newValue) {
                grayingGroupWithAccount = AppGroup.initGrayingGroupWithAccount();
            }
        });
        ConfigurationUtil.observeChange(KEY_MAINAPPGROUP, new ConfigurationChangeListener(){

            @Override
            public void onChange(Object key, Object newValue) {
                Map inner_mainGroups = AppGroup.initMainGroup();
                AtomicBoolean isDealyToEliminate = new AtomicBoolean(false);
                inner_mainGroups.forEach((app, group) -> {
                    if (group.equals(mainGroups.get(app))) {
                        return;
                    }
                    boolean isGrayApp = isGrayAppMap.getOrDefault(app, curAppGroup != null);
                    if (isGrayApp && group.equals(curAppGroup)) {
                        groupChangeListeners.forEach(listener -> listener.grayToProductionNode((String)app, (String)group));
                    }
                    if (!isGrayApp) {
                        groupChangeListeners.forEach(listener -> listener.productionToEliminateNode((String)app, (String)group));
                        isDealyToEliminate.set(true);
                    }
                    isGrayAppMap.put(app, curAppGroup == null ? false : !group.equals(curAppGroup));
                });
                if (isDealyToEliminate.get()) {
                    LockSupport.parkNanos(1000000000L * (long)Integer.getInteger("gray.waitToEliminateNode", 5).intValue());
                }
                mainGroups = inner_mainGroups;
            }
        });
    }
}

