/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.instance;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kd.bos.instance.Cluster;
import kd.bos.instance.InstanceSenior;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.SafeLogUtils;
import kd.bos.util.SystemProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AppStore {
    public static final String APPSTORE_URL = "APPSTORE_URL";
    public static final String LIBSNAMEPATHMAP_KEY = "libs.name.pathmapping";
    public static final String LIBS = "libs";
    private static final String LOADAPPIDFROMAPPSTORE = "loadappidfromappstore";
    private final Set<String> cloudIds = new HashSet<String>(2);
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private Set<String> configAppidSet = new HashSet<String>(1);
    private Set<String> excludeAppIdsFromCloudSet = new HashSet<String>(1);
    private Set<String> appIdsFromLibSet = new HashSet<String>(1);
    private Set<String> configInnerAppidSet = new HashSet<String>(1);
    private static Map<String, AppStore> instances = new ConcurrentHashMap<String, AppStore>(2);
    private final String region;

    private AppStore(String region) {
        this.region = region;
    }

    public static AppStore get() {
        return AppStore.get("");
    }

    public static AppStore get(String region) {
        if (region == null) {
            return null;
        }
        return instances.computeIfAbsent(region, k -> new AppStore(region));
    }

    protected Set<String> getConfiggedAppidsInAppStore() {
        this.init();
        return this.configAppidSet;
    }

    protected Set<String> getConfiggedInnerAppids() {
        this.init();
        return this.configInnerAppidSet;
    }

    private synchronized void init() {
        if (this.inited.compareAndSet(false, true)) {
            this.configAppidSet = this.initConfigInAppStore();
        }
    }

    private Set<String> initConfigInAppStore() {
        HashSet<String> configAppidSet = new HashSet<String>(4);
        String appstore_url = this.getSystemProperties(APPSTORE_URL);
        if (appstore_url == null || "false".equals(this.getSystemProperties(LOADAPPIDFROMAPPSTORE))) {
            return configAppidSet;
        }
        if (!appstore_url.endsWith("/")) {
            appstore_url = appstore_url + "/";
        }
        String appstoreUrl = appstore_url;
        String libstr = this.getSystemProperties(LIBS);
        if (libstr != null && libstr.trim().length() > 0) {
            String[] libs;
            String appidsFromEnvStr = this.getSystemProperties("appIds");
            if (appidsFromEnvStr != null && appidsFromEnvStr.length() > 0) {
                String[] libs2;
                String[] appidsFromEnv;
                for (String appidEnv : appidsFromEnv = appidsFromEnvStr.split(",|;")) {
                    configAppidSet.add(appidEnv);
                }
                for (String libUri : libs2 = libstr.split(",|;")) {
                    String libUrl = appstoreUrl + libUri;
                    try {
                        this.parseCloudLibFromUrl(libUrl, appstoreUrl, null, true);
                    }
                    catch (Exception e) {
                        this.praseAppstoreError(e);
                    }
                }
                return configAppidSet;
            }
            for (String libUri : libs = libstr.split(",|;")) {
                String libUrl = appstoreUrl + libUri;
                try {
                    this.parseCloudLibFromUrl(libUrl, appstoreUrl, configAppidSet, false);
                }
                catch (Exception e) {
                    this.praseAppstoreError(e);
                }
            }
            configAppidSet.addAll(this.appIdsFromLibSet);
            System.setProperty("appIdsFromLib", this.appIdsFromLibSet.stream().collect(Collectors.joining(",")));
            if (this.cloudIds.size() > 0) {
                Map<String, HashMultimap<String, String>> m = Cluster.getAppCloudMapping();
                m.forEach((accountid, cloudappmapping) -> this.cloudIds.forEach(cloud -> {
                    Set appidsInCloud = cloudappmapping.get(cloud);
                    this.initCloudAppids((String)cloud, appidsInCloud, configAppidSet);
                }));
            }
        } else {
            Map<String, String> libsNamePathMap = AppStore.getDefaultlibsNamePathMap();
            String libsNamePathMapStr = this.getSystemProperties(LIBSNAMEPATHMAP_KEY);
            if (libsNamePathMapStr != null) {
                String[] libsNamePathStrs;
                for (String libsNamePathStr : libsNamePathStrs = libsNamePathMapStr.split(",")) {
                    String[] libsNamePathPair = libsNamePathStr.split("=");
                    if (libsNamePathPair.length != 2) continue;
                    libsNamePathMap.put(libsNamePathPair[0], libsNamePathPair[1]);
                }
            }
            libsNamePathMap.forEach((libsName, subPath) -> {
                String libs = this.getSystemProperties((String)libsName);
                if (libs != null) {
                    for (String lib : libs.split(",")) {
                        if (!lib.endsWith(".xml")) continue;
                        String xmlUrl = appstoreUrl + subPath + "/" + lib;
                        try {
                            this.parseAppidFromXml(xmlUrl, configAppidSet, false);
                        }
                        catch (Exception e) {
                            this.praseAppstoreError(e);
                        }
                    }
                }
            });
        }
        if (!configAppidSet.isEmpty()) {
            System.setProperty("appIdsFromAppStore", configAppidSet.stream().collect(Collectors.joining(",")));
        }
        if (!this.configInnerAppidSet.isEmpty()) {
            System.setProperty("innerAppIdsFromAppStore", this.configInnerAppidSet.stream().collect(Collectors.joining(",")));
        }
        return configAppidSet;
    }

    private void initCloudAppids(String cloud, Set<String> appidsInCloud, Set<String> configAppidSet) {
        if (appidsInCloud == null || appidsInCloud.isEmpty()) {
            System.setProperty("cloud--" + cloud, "cloud not exists");
            return;
        }
        Set<String> appidsExcludedSet = this.getExcludeFromCloudSet();
        HashSet<String> appidsDeployInCloud = new HashSet<String>(appidsInCloud);
        appidsDeployInCloud.removeAll(appidsExcludedSet);
        appidsDeployInCloud.removeAll(this.appIdsFromLibSet);
        appidsDeployInCloud.removeAll(this.excludeAppIdsFromCloudSet);
        configAppidSet.addAll(appidsDeployInCloud);
        try {
            InstanceSenior.removeDeployedCloudByAppIds(this.appIdsFromLibSet);
            InstanceSenior.removeDeployedCloudByAppIds(this.excludeAppIdsFromCloudSet);
            InstanceSenior.addCloud(cloud, appidsDeployInCloud);
            System.setProperty("cloud--" + cloud, InstanceSenior.getDeployedAppByCloud(cloud).toString());
        }
        catch (Error | Exception e) {
            ExceptionUtils.parseException(e);
        }
    }

    private void praseAppstoreError(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        SafeLogUtils.error(AppStore.class, "getConfiggedAppidsInAppStoreError", e);
        if (this.getSystemProperties("appIds") == null && Boolean.parseBoolean(this.getSystemProperties("appSplit"))) {
            SafeLogUtils.error(AppStore.class, "Execute System.exit(1), Starting to exit the service", e);
            LockSupport.parkNanos(1000000000L);
            System.exit(1);
        }
    }

    private void parseCloudLibFromUrl(String libUrl, String appstoreUrl, Set<String> configAppidSet, boolean onlyInnerApppIds) throws ParserConfigurationException, IOException, SAXException {
        Consumer<Document> consumer = document -> {
            Element root = (Element)document.getElementsByTagName("root").item(0);
            if (root != null) {
                Element ele;
                int i;
                NodeList list = null;
                if (!onlyInnerApppIds) {
                    list = root.getElementsByTagName("appIds");
                    if (list != null) {
                        for (i = 0; i < list.getLength(); ++i) {
                            ele = (Element)list.item(i);
                            String configAppids = ele.getFirstChild().getNodeValue();
                            String[] appidsExcludedSet = this.getExcludeFromCloudSet();
                            if (configAppids == null) continue;
                            String[] stringArray = configAppids.split(",");
                            int n = stringArray.length;
                            for (int j = 0; j < n; ++j) {
                                String appid = stringArray[j];
                                if (appidsExcludedSet.contains(appid)) continue;
                                this.appIdsFromLibSet.add(appid);
                            }
                        }
                    }
                    if ((list = root.getElementsByTagName("excludeAppIdsFromCloud")) != null) {
                        for (i = 0; i < list.getLength(); ++i) {
                            ele = (Element)list.item(i);
                            String excludeAppIdsFromCloud = ele.getFirstChild().getNodeValue();
                            if (excludeAppIdsFromCloud == null) continue;
                            for (String appid : excludeAppIdsFromCloud.split(",")) {
                                this.excludeAppIdsFromCloudSet.add(appid);
                            }
                        }
                    }
                    if ((list = root.getElementsByTagName("cloud")) != null) {
                        for (i = 0; i < list.getLength(); ++i) {
                            ele = (Element)list.item(i);
                            String configCloud = ele.getFirstChild().getNodeValue();
                            this.parseConfigCloud(configCloud);
                        }
                    }
                }
                if ((list = root.getElementsByTagName("innerAppIds")) != null) {
                    for (i = 0; i < list.getLength(); ++i) {
                        ele = (Element)list.item(i);
                        String innerAppids = ele.getFirstChild().getNodeValue();
                        if (innerAppids == null) continue;
                        for (String innerAppid : innerAppids.split(",")) {
                            this.configInnerAppidSet.add(innerAppid);
                        }
                    }
                }
                list = root.getElementsByTagName(LIBS);
                for (i = 0; i < list.getLength(); ++i) {
                    ele = (Element)list.item(i);
                    NodeList libList = ele.getElementsByTagName("lib");
                    for (int j = 0; j < libList.getLength(); ++j) {
                        Element eleJ = (Element)libList.item(j);
                        String libconfigs = eleJ.getFirstChild().getNodeValue();
                        int splitIndex = libconfigs.indexOf(47);
                        if (splitIndex <= 0) continue;
                        String subPath = libconfigs.substring(0, splitIndex);
                        String libs = libconfigs.substring(splitIndex + 1);
                        for (String lib : libs.split(",")) {
                            if (!lib.endsWith(".xml")) continue;
                            String xmlUrl = appstoreUrl + subPath + "/" + lib;
                            try {
                                this.parseAppidFromXml(xmlUrl, null, true);
                            }
                            catch (Exception e) {
                                SafeLogUtils.error(AppStore.class, "get inner appId Error," + xmlUrl, e);
                            }
                        }
                    }
                }
            }
        };
        AppStore.parseXml(libUrl, consumer);
    }

    private void parseAppidFromXml(String xmlUrl, Set<String> configAppidSet, boolean onlyInnerAppIds) throws ParserConfigurationException, IOException, SAXException {
        Consumer<Document> consumer = document -> {
            Element root = (Element)document.getElementsByTagName("root").item(0);
            if (root != null) {
                NodeList list;
                if (!onlyInnerAppIds && (list = root.getElementsByTagName("appIds")) != null) {
                    for (int i = 0; i < list.getLength(); ++i) {
                        Element ele = (Element)list.item(i);
                        String configAppids = ele.getFirstChild().getNodeValue();
                        this.parseConfigAppids(configAppids, configAppidSet);
                    }
                }
                this.parseInnerAppIds(xmlUrl, root);
            }
        };
        AppStore.parseXml(xmlUrl, consumer);
    }

    private Set<String> getExcludeFromCloudSet() {
        String appdisExcludeFromCloud = this.getSystemProperties("appIds.excludeFromCloudNode");
        HashSet<String> appidsExcludedSet = new HashSet<String>(2);
        if (appdisExcludeFromCloud != null) {
            String[] appidsExcludeFrom;
            for (String appidExcluded : appidsExcludeFrom = appdisExcludeFromCloud.split(",|;")) {
                appidsExcludedSet.add(appidExcluded);
            }
        }
        return appidsExcludedSet;
    }

    private void parseInnerAppIds(String xmlUrl, Element root) {
        NodeList list = root.getElementsByTagName("innerAppIds");
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element ele = (Element)list.item(i);
                String innerAppids = ele.getFirstChild().getNodeValue();
                if (innerAppids == null) continue;
                for (String innerAppid : innerAppids.split(",")) {
                    this.configInnerAppidSet.add(innerAppid);
                }
            }
        }
    }

    private void parseConfigAppids(String configStr, Set<String> configAppidSet) {
        if (configStr == null) {
            return;
        }
        for (String appid : configStr.split(",")) {
            configAppidSet.add(appid);
        }
    }

    private void parseConfigCloud(String configStr) {
        if (configStr == null) {
            return;
        }
        for (String cloudid : configStr.split(",")) {
            this.cloudIds.add(cloudid.toUpperCase());
        }
    }

    private static void parseXml(String xmlUrl, Consumer<Document> consumer) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        URL url = new URL(xmlUrl);
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(3000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        try (InputStream inputStream = connection.getInputStream();){
            Document document = null;
            document = builder.parse(inputStream);
            consumer.accept(document);
        }
    }

    private static Map<String, String> getDefaultlibsNamePathMap() {
        HashMap<String, String> libsNamePathMap = new HashMap<String, String>(4);
        libsNamePathMap.put("BIZLIBS", "biz");
        libsNamePathMap.put("BOSLIBS", "bos");
        libsNamePathMap.put("TRDLIBS", "trd");
        return libsNamePathMap;
    }

    private String getSystemProperties(String key) {
        if ("".equals(this.region)) {
            return SystemProperties.getWithEnv(key);
        }
        return SystemProperties.getWithEnv(this.region + "." + key);
    }
}

