/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.instance;

import java.security.SecureRandom;
import java.util.Set;
import kd.bos.bundle.Resources;
import kd.bos.instance.InstanceSenior;
import kd.bos.util.SystemProperties;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Instance {
    public static final String KEY_CLUSTERNAME = "clusterName";
    public static final int INSTANCE_ID_LENGTH_MAX = 70;
    public static final String KEY_DATACENTERNAME = "dataCenterName";
    public static final String KEY_APPNAME = "appName";
    public static final String MSERVICE_NAME = "mservice";
    public static final String KEY_CONFIGAPPNAME = "configAppName";
    public static final String KEY_APPSPLIT = "appSplit";
    public static final String KEY_WEBMSERVICEINONE = "webmserviceinone";
    public static final String KEY_LIGHTWEIGHTDEPLOY = "lightweightdeploy";
    public static final String KEY_APPIDS = "appIds";
    public static final String KEY_DEPLOYEDAPPIDS = "deployedAppIds";
    public static final String KEY_INNERAPPIDS = "innerAppIds";
    public static final String KEY_HASBOSINNERAPPIDS = "defalutBosInnerAppId.enable";
    public static final String KEY_EXCLUEFROMCLOUD = "appIds.excludeFromCloudNode";
    public static final String KEY_CUSTOMAPPIDS = "customAppIds";
    public static final String KEY_REGISTEDAPPIDS = "registedAppIds";
    public static final String KEY_DEBUG_APP_NAME = "debug";
    public static final String KEY_CLOUD_PRE_TAG = "cloud--";
    private static String clusterName = SystemProperties.getWithEnv("clusterName");
    private static String appName;
    private static String[] configAppNames;
    private static boolean appSplit;
    private static boolean webMserviceInOne;
    private static boolean lightWeightDeploy;
    private static String instanceId;
    protected static String evnAppIds;
    protected static String evnInnerAppIds;
    protected static String evnDeployAppIds;
    private static boolean pausedServiceByMonitor;

    public static String getClusterName() {
        return clusterName;
    }

    @Deprecated
    public static String getDataCenterName() {
        throw new UnsupportedOperationException(Resources.getString("bos-util", "Instance_0", new Object[0]));
    }

    public static String[] parseAppIds(String str) {
        if (str == null) {
            return null;
        }
        return str.split(",|;");
    }

    public static String getAppName() {
        return appName;
    }

    public static String[] getConfigAppName() {
        return configAppNames;
    }

    public static String getInstanceId() {
        return instanceId;
    }

    public static String[] getAppIds() {
        return InstanceSenior.getAppIds();
    }

    public static void addAppIds(String appId) {
        InstanceSenior.addAppIds(appId);
    }

    public static String[] getDeployedAppIds() {
        return InstanceSenior.getDeployedAppIds();
    }

    public static String[] getInnerAppIds() {
        return InstanceSenior.getInnerAppIds();
    }

    public static boolean isAppSplit() {
        return appSplit;
    }

    public static boolean isWebMserviceInOne() {
        return webMserviceInOne;
    }

    public static boolean isStandaloneWebNode() {
        return !webMserviceInOne && Boolean.getBoolean("isWebNode");
    }

    public static boolean isLightWeightDeploy() {
        return lightWeightDeploy;
    }

    private static String createInstanceId(String appName) {
        return appName + "-" + new SecureRandom().nextInt(9) + System.currentTimeMillis() % 1000000000L;
    }

    public static String getAppNameFromInstanceId(String instanceId) {
        if (instanceId == null) {
            return "NON";
        }
        if (!instanceId.contains("-")) {
            return Instance.getAppName();
        }
        int tagIndex = instanceId.lastIndexOf("-");
        return instanceId.substring(0, tagIndex);
    }

    public static boolean isPausedServiceByMonitor() {
        return pausedServiceByMonitor;
    }

    public static boolean isDebugInstance() {
        return InstanceSenior.isDebugInstance();
    }

    public static Set<String> getDeployedClouds() {
        return InstanceSenior.getDeployedClouds();
    }

    public static String getDeployedCloudByApp(String appId) {
        return InstanceSenior.getDeployedCloudByApp(appId);
    }

    static {
        if (clusterName == null) {
            throw new Error("clusterName not configured.");
        }
        appName = SystemProperties.getWithEnv(KEY_APPNAME);
        if (appName == null) {
            throw new Error("appName not configured.");
        }
        String configAppName = SystemProperties.getWithEnv(KEY_CONFIGAPPNAME);
        if (configAppName == null) {
            configAppName = appName;
        }
        configAppNames = configAppName.split(",");
        appSplit = Boolean.parseBoolean(SystemProperties.getWithEnv(KEY_APPSPLIT));
        webMserviceInOne = Boolean.parseBoolean(SystemProperties.getWithEnv(KEY_WEBMSERVICEINONE));
        lightWeightDeploy = Boolean.parseBoolean(SystemProperties.getWithEnv(KEY_LIGHTWEIGHTDEPLOY));
        evnAppIds = SystemProperties.getWithEnv(KEY_APPIDS);
        evnInnerAppIds = SystemProperties.getWithEnv(KEY_INNERAPPIDS);
        evnDeployAppIds = SystemProperties.getWithEnv(KEY_DEPLOYEDAPPIDS);
        instanceId = Instance.createInstanceId(Instance.getAppName());
        pausedServiceByMonitor = false;
    }
}

