/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.AppStore;
import kd.bos.instance.Instance;
import kd.bos.util.SystemProperties;

public class InstanceSenior {
    private static String[] appIds;
    private static String[] deployedAppIds;
    private static String[] innerAppIds;
    private static boolean debugInstance;
    private static Set<String> clouds;
    private static Map<String, String> appCloudMapping;

    private static String[] initDeployedAppIds() {
        String str = Instance.evnDeployAppIds;
        if (str != null) {
            return Instance.parseAppIds(str);
        }
        return null;
    }

    private static String[] initInnerAppIds() {
        String str = Instance.evnInnerAppIds;
        HashSet<Object> set = str != null ? new HashSet<String>(Arrays.asList(Instance.parseAppIds(str))) : new HashSet(1);
        if (!"false".equals(SystemProperties.getWithEnv("defalutBosInnerAppId.enable"))) {
            set.add("bos");
        }
        set.addAll(AppStore.get().getConfiggedInnerAppids());
        return set.toArray(new String[0]);
    }

    private static String[] initAppIds() {
        Set<String> appidSet;
        try {
            appidSet = AppStore.get().getConfiggedAppidsInAppStore();
        }
        catch (Throwable e) {
            appidSet = new HashSet<String>();
        }
        String str = Instance.evnAppIds;
        if (str != null) {
            String[] ids;
            for (String id : ids = Instance.parseAppIds(str)) {
                appidSet.add(id);
            }
        }
        if (appidSet.isEmpty()) {
            return null;
        }
        return appidSet.toArray(new String[0]);
    }

    protected static String[] getAppIds() {
        return appIds;
    }

    protected static void addAppIds(String appId) {
        if (appId != null && appId.length() > 0) {
            if (appIds != null && appIds.length > 0) {
                String[] newAppIds = Arrays.copyOf(appIds, appIds.length + 1);
                newAppIds[newAppIds.length - 1] = appId;
                appIds = newAppIds;
            } else {
                appIds = new String[]{appId};
            }
        }
    }

    protected static String[] getDeployedAppIds() {
        return deployedAppIds;
    }

    protected static String[] getInnerAppIds() {
        return innerAppIds;
    }

    protected static boolean isDebugInstance() {
        return debugInstance;
    }

    protected static Set<String> getDeployedClouds() {
        return Collections.unmodifiableSet(clouds);
    }

    protected static void addCloud(String cloud, Set<String> appidsDeployInCloud) {
        if (cloud != null) {
            clouds.add(cloud);
            appidsDeployInCloud.forEach(appid -> appCloudMapping.put((String)appid, cloud));
        }
    }

    protected static String getDeployedCloudByApp(String appId) {
        return appCloudMapping.get(appId);
    }

    protected static void removeDeployedCloudByAppIds(Set<String> appIds) {
        if (appIds != null && !appIds.isEmpty()) {
            appCloudMapping.keySet().removeAll(appIds);
        }
    }

    protected static Set<String> getDeployedAppByCloud(String cloud) {
        HashSet<String> s = new HashSet<String>(2);
        appCloudMapping.forEach((app, cloudid) -> {
            if (cloudid.equals(cloud)) {
                s.add((String)app);
            }
        });
        return s;
    }

    static {
        debugInstance = false;
        clouds = new HashSet<String>(2);
        appCloudMapping = new ConcurrentHashMap<String, String>(2);
        appIds = InstanceSenior.initAppIds();
        deployedAppIds = InstanceSenior.initDeployedAppIds();
        innerAppIds = InstanceSenior.initInnerAppIds();
        if (appIds != null && appIds.length > 0) {
            for (String id : appIds) {
                if (!"debug".equals(id)) continue;
                debugInstance = true;
                break;
            }
        }
        if (!debugInstance && innerAppIds != null && innerAppIds.length > 0) {
            ArrayList<String> appIds = new ArrayList<String>(innerAppIds.length);
            for (String id : innerAppIds) {
                if ("debug".equals(id)) continue;
                appIds.add(id);
            }
            if (appIds.size() != innerAppIds.length) {
                innerAppIds = appIds.toArray(new String[appIds.size()]);
            }
        }
    }
}

