/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.lang;

import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HZPinyin0 {
    private static Map<String, Integer> spellMap = new LinkedHashMap<String, Integer>(396);
    private static Map<Character, String> uncommonWordsMap = new LinkedHashMap<Character, String>(200);

    private HZPinyin0() {
    }

    private static void initialize() {
        spellMap.put("\u2019a", -20319);
        spellMap.put("\u2019ai", -20317);
        spellMap.put("\u2019an", -20304);
        spellMap.put("\u2019ang", -20295);
        spellMap.put("\u2019ao", -20292);
        spellMap.put("ba", -20283);
        spellMap.put("bai", -20265);
        spellMap.put("ban", -20257);
        spellMap.put("bang", -20242);
        spellMap.put("bao", -20230);
        spellMap.put("bei", -20051);
        spellMap.put("ben", -20036);
        spellMap.put("beng", -20032);
        spellMap.put("bi", -20026);
        spellMap.put("bian", -20002);
        spellMap.put("biao", -19990);
        spellMap.put("bie", -19986);
        spellMap.put("bin", -19982);
        spellMap.put("bing", -19976);
        spellMap.put("bo", -19805);
        spellMap.put("bu", -19784);
        spellMap.put("ca", -19775);
        spellMap.put("cai", -19774);
        spellMap.put("can", -19763);
        spellMap.put("cang", -19756);
        spellMap.put("cao", -19751);
        spellMap.put("ce", -19746);
        spellMap.put("ceng", -19741);
        spellMap.put("cha", -19739);
        spellMap.put("chai", -19728);
        spellMap.put("chan", -19725);
        spellMap.put("chang", -19715);
        spellMap.put("chao", -19540);
        spellMap.put("che", -19531);
        spellMap.put("chen", -19525);
        spellMap.put("cheng", -19515);
        spellMap.put("chi", -19500);
        spellMap.put("chong", -19484);
        spellMap.put("chou", -19479);
        spellMap.put("chu", -19467);
        spellMap.put("chuai", -19289);
        spellMap.put("chuan", -19288);
        spellMap.put("chuang", -19281);
        spellMap.put("chui", -19275);
        spellMap.put("chun", -19270);
        spellMap.put("chuo", -19263);
        spellMap.put("ci", -19261);
        spellMap.put("cong", -19249);
        spellMap.put("cou", -19243);
        spellMap.put("cu", -19242);
        spellMap.put("cuan", -19238);
        spellMap.put("cui", -19235);
        spellMap.put("cun", -19227);
        spellMap.put("cuo", -19224);
        spellMap.put("da", -19218);
        spellMap.put("dai", -19212);
        spellMap.put("dan", -19038);
        spellMap.put("dang", -19023);
        spellMap.put("dao", -19018);
        spellMap.put("de", -19006);
        spellMap.put("deng", -19003);
        spellMap.put("di", -18996);
        spellMap.put("dian", -18977);
        spellMap.put("diao", -18961);
        spellMap.put("die", -18952);
        spellMap.put("ding", -18783);
        spellMap.put("diu", -18774);
        spellMap.put("dong", -18773);
        spellMap.put("dou", -18763);
        spellMap.put("du", -18756);
        spellMap.put("duan", -18741);
        spellMap.put("dui", -18735);
        spellMap.put("dun", -18731);
        spellMap.put("duo", -18722);
        spellMap.put("\u2019e", -18710);
        spellMap.put("\u2019en", -18697);
        spellMap.put("\u2019er", -18696);
        spellMap.put("fa", -18526);
        spellMap.put("fan", -18518);
        spellMap.put("fang", -18501);
        spellMap.put("fei", -18490);
        spellMap.put("fen", -18478);
        spellMap.put("feng", -18463);
        spellMap.put("fo", -18448);
        spellMap.put("fou", -18447);
        spellMap.put("fu", -18446);
        spellMap.put("ga", -18239);
        spellMap.put("gai", -18237);
        spellMap.put("gan", -18231);
        spellMap.put("gang", -18220);
        spellMap.put("gao", -18211);
        spellMap.put("ge", -18201);
        spellMap.put("gei", -18184);
        spellMap.put("gen", -18183);
        spellMap.put("geng", -18181);
        spellMap.put("gong", -18012);
        spellMap.put("gou", -17997);
        spellMap.put("gu", -17988);
        spellMap.put("gua", -17970);
        spellMap.put("guai", -17964);
        spellMap.put("guan", -17961);
        spellMap.put("guang", -17950);
        spellMap.put("gui", -17947);
        spellMap.put("gun", -17931);
        spellMap.put("guo", -17928);
        spellMap.put("ha", -17922);
        spellMap.put("hai", -17759);
        spellMap.put("han", -17752);
        spellMap.put("hang", -17733);
        spellMap.put("hao", -17730);
        spellMap.put("he", -17721);
        spellMap.put("hei", -17703);
        spellMap.put("hen", -17701);
        spellMap.put("heng", -17697);
        spellMap.put("hong", -17692);
        spellMap.put("hou", -17683);
        spellMap.put("hu", -17676);
        spellMap.put("hua", -17496);
        spellMap.put("huai", -17487);
        spellMap.put("huan", -17482);
        spellMap.put("huang", -17468);
        spellMap.put("hui", -17454);
        spellMap.put("hun", -17433);
        spellMap.put("huo", -17427);
        spellMap.put("ji", -17417);
        spellMap.put("jia", -17202);
        spellMap.put("jian", -17185);
        spellMap.put("jiang", -16983);
        spellMap.put("jiao", -16970);
        spellMap.put("jie", -16942);
        spellMap.put("jin", -16915);
        spellMap.put("jing", -16733);
        spellMap.put("jiong", -16708);
        spellMap.put("jiu", -16706);
        spellMap.put("ju", -16689);
        spellMap.put("juan", -16664);
        spellMap.put("jue", -16657);
        spellMap.put("jun", -16647);
        spellMap.put("ka", -16474);
        spellMap.put("kai", -16470);
        spellMap.put("kan", -16465);
        spellMap.put("kang", -16459);
        spellMap.put("kao", -16452);
        spellMap.put("ke", -16448);
        spellMap.put("ken", -16433);
        spellMap.put("keng", -16429);
        spellMap.put("kong", -16427);
        spellMap.put("kou", -16423);
        spellMap.put("ku", -16419);
        spellMap.put("kua", -16412);
        spellMap.put("kuai", -16407);
        spellMap.put("kuan", -16403);
        spellMap.put("kuang", -16401);
        spellMap.put("kui", -16393);
        spellMap.put("kun", -16220);
        spellMap.put("kuo", -16216);
        spellMap.put("la", -16212);
        spellMap.put("lai", -16205);
        spellMap.put("lan", -16202);
        spellMap.put("lang", -16187);
        spellMap.put("lao", -16180);
        spellMap.put("le", -16171);
        spellMap.put("lei", -16169);
        spellMap.put("leng", -16158);
        spellMap.put("li", -16155);
        spellMap.put("lia", -15959);
        spellMap.put("lian", -15958);
        spellMap.put("liang", -15944);
        spellMap.put("liao", -15933);
        spellMap.put("lie", -15920);
        spellMap.put("lin", -15915);
        spellMap.put("ling", -15903);
        spellMap.put("liu", -15889);
        spellMap.put("long", -15878);
        spellMap.put("lou", -15707);
        spellMap.put("lu", -15701);
        spellMap.put("lv", -15681);
        spellMap.put("luan", -15667);
        spellMap.put("lue", -15661);
        spellMap.put("lun", -15659);
        spellMap.put("luo", -15652);
        spellMap.put("ma", -15640);
        spellMap.put("mai", -15631);
        spellMap.put("man", -15625);
        spellMap.put("mang", -15454);
        spellMap.put("mao", -15448);
        spellMap.put("me", -15436);
        spellMap.put("mei", -15435);
        spellMap.put("men", -15419);
        spellMap.put("meng", -15416);
        spellMap.put("mi", -15408);
        spellMap.put("mian", -15394);
        spellMap.put("miao", -15385);
        spellMap.put("mie", -15377);
        spellMap.put("min", -15375);
        spellMap.put("ming", -15369);
        spellMap.put("miu", -15363);
        spellMap.put("mo", -15362);
        spellMap.put("mou", -15183);
        spellMap.put("mu", -15180);
        spellMap.put("na", -15165);
        spellMap.put("nai", -15158);
        spellMap.put("nan", -15153);
        spellMap.put("nang", -15150);
        spellMap.put("nao", -15149);
        spellMap.put("ne", -15144);
        spellMap.put("nei", -15143);
        spellMap.put("nen", -15141);
        spellMap.put("neng", -15140);
        spellMap.put("ni", -15139);
        spellMap.put("nian", -15128);
        spellMap.put("niang", -15121);
        spellMap.put("niao", -15119);
        spellMap.put("nie", -15117);
        spellMap.put("nin", -15110);
        spellMap.put("ning", -15109);
        spellMap.put("niu", -14941);
        spellMap.put("nong", -14937);
        spellMap.put("nu", -14933);
        spellMap.put("nv", -14930);
        spellMap.put("nuan", -14929);
        spellMap.put("nue", -14928);
        spellMap.put("nuo", -14926);
        spellMap.put("\u2019o", -14922);
        spellMap.put("\u2019ou", -14921);
        spellMap.put("pa", -14914);
        spellMap.put("pai", -14908);
        spellMap.put("pan", -14902);
        spellMap.put("pang", -14894);
        spellMap.put("pao", -14889);
        spellMap.put("pei", -14882);
        spellMap.put("pen", -14873);
        spellMap.put("peng", -14871);
        spellMap.put("pi", -14857);
        spellMap.put("pian", -14678);
        spellMap.put("piao", -14674);
        spellMap.put("pie", -14670);
        spellMap.put("pin", -14668);
        spellMap.put("ping", -14663);
        spellMap.put("po", -14654);
        spellMap.put("pu", -14645);
        spellMap.put("qi", -14630);
        spellMap.put("qia", -14594);
        spellMap.put("qian", -14429);
        spellMap.put("qiang", -14407);
        spellMap.put("qiao", -14399);
        spellMap.put("qie", -14384);
        spellMap.put("qin", -14379);
        spellMap.put("qing", -14368);
        spellMap.put("qiong", -14355);
        spellMap.put("qiu", -14353);
        spellMap.put("qu", -14345);
        spellMap.put("quan", -14170);
        spellMap.put("que", -14159);
        spellMap.put("qun", -14151);
        spellMap.put("ran", -14149);
        spellMap.put("rang", -14145);
        spellMap.put("rao", -14140);
        spellMap.put("re", -14137);
        spellMap.put("ren", -14135);
        spellMap.put("reng", -14125);
        spellMap.put("ri", -14123);
        spellMap.put("rong", -14122);
        spellMap.put("rou", -14112);
        spellMap.put("ru", -14109);
        spellMap.put("ruan", -14099);
        spellMap.put("rui", -14097);
        spellMap.put("run", -14094);
        spellMap.put("ruo", -14092);
        spellMap.put("sa", -14090);
        spellMap.put("sai", -14087);
        spellMap.put("san", -14083);
        spellMap.put("sang", -13917);
        spellMap.put("sao", -13914);
        spellMap.put("se", -13910);
        spellMap.put("sen", -13907);
        spellMap.put("seng", -13906);
        spellMap.put("sha", -13905);
        spellMap.put("shai", -13896);
        spellMap.put("shan", -13894);
        spellMap.put("shang", -13878);
        spellMap.put("shao", -13870);
        spellMap.put("she", -13859);
        spellMap.put("shen", -13847);
        spellMap.put("sheng", -13831);
        spellMap.put("shi", -13658);
        spellMap.put("shou", -13611);
        spellMap.put("shu", -13601);
        spellMap.put("shua", -13406);
        spellMap.put("shuai", -13404);
        spellMap.put("shuan", -13400);
        spellMap.put("shuang", -13398);
        spellMap.put("shui", -13395);
        spellMap.put("shun", -13391);
        spellMap.put("shuo", -13387);
        spellMap.put("si", -13383);
        spellMap.put("song", -13367);
        spellMap.put("sou", -13359);
        spellMap.put("su", -13356);
        spellMap.put("suan", -13343);
        spellMap.put("sui", -13340);
        spellMap.put("sun", -13329);
        spellMap.put("suo", -13326);
        spellMap.put("ta", -13318);
        spellMap.put("tai", -13147);
        spellMap.put("tan", -13138);
        spellMap.put("tang", -13120);
        spellMap.put("tao", -13107);
        spellMap.put("te", -13096);
        spellMap.put("teng", -13095);
        spellMap.put("ti", -13091);
        spellMap.put("tian", -13076);
        spellMap.put("tiao", -13068);
        spellMap.put("tie", -13063);
        spellMap.put("ting", -13060);
        spellMap.put("tong", -12888);
        spellMap.put("tou", -12875);
        spellMap.put("tu", -12871);
        spellMap.put("tuan", -12860);
        spellMap.put("tui", -12858);
        spellMap.put("tun", -12852);
        spellMap.put("tuo", -12849);
        spellMap.put("wa", -12838);
        spellMap.put("wai", -12831);
        spellMap.put("wan", -12829);
        spellMap.put("wang", -12812);
        spellMap.put("wei", -12802);
        spellMap.put("wen", -12607);
        spellMap.put("weng", -12597);
        spellMap.put("wo", -12594);
        spellMap.put("wu", -12585);
        spellMap.put("xi", -12556);
        spellMap.put("xia", -12359);
        spellMap.put("xian", -12346);
        spellMap.put("xiang", -12320);
        spellMap.put("xiao", -12300);
        spellMap.put("xie", -12120);
        spellMap.put("xin", -12099);
        spellMap.put("xing", -12089);
        spellMap.put("xiong", -12074);
        spellMap.put("xiu", -12067);
        spellMap.put("xu", -12058);
        spellMap.put("xuan", -12039);
        spellMap.put("xue", -11867);
        spellMap.put("xun", -11861);
        spellMap.put("ya", -11847);
        spellMap.put("yan", -11831);
        spellMap.put("yang", -11798);
        spellMap.put("yao", -11781);
        spellMap.put("ye", -11604);
        spellMap.put("yi", -11589);
        spellMap.put("yin", -11536);
        spellMap.put("ying", -11358);
        spellMap.put("yo", -11340);
        spellMap.put("yong", -11339);
        spellMap.put("you", -11324);
        spellMap.put("yu", -11303);
        spellMap.put("yuan", -11097);
        spellMap.put("yue", -11077);
        spellMap.put("yun", -11067);
        spellMap.put("za", -11055);
        spellMap.put("zai", -11052);
        spellMap.put("zan", -11045);
        spellMap.put("zang", -11041);
        spellMap.put("zao", -11038);
        spellMap.put("ze", -11024);
        spellMap.put("zei", -11020);
        spellMap.put("zen", -11019);
        spellMap.put("zeng", -11018);
        spellMap.put("zha", -11014);
        spellMap.put("zhai", -10838);
        spellMap.put("zhan", -10832);
        spellMap.put("zhang", -10815);
        spellMap.put("zhao", -10800);
        spellMap.put("zhe", -10790);
        spellMap.put("zhen", -10780);
        spellMap.put("zheng", -10764);
        spellMap.put("zhi", -10587);
        spellMap.put("zhong", -10544);
        spellMap.put("zhou", -10533);
        spellMap.put("zhu", -10519);
        spellMap.put("zhua", -10331);
        spellMap.put("zhuai", -10329);
        spellMap.put("zhuan", -10328);
        spellMap.put("zhuang", -10322);
        spellMap.put("zhui", -10315);
        spellMap.put("zhun", -10309);
        spellMap.put("zhuo", -10307);
        spellMap.put("zi", -10296);
        spellMap.put("zong", -10281);
        spellMap.put("zou", -10274);
        spellMap.put("zu", -10270);
        spellMap.put("zuan", -10262);
        spellMap.put("zui", -10260);
        spellMap.put("zun", -10256);
        spellMap.put("zuo", -10254);
    }

    private static void initUncommonWords() {
        HZPinyin0.putUncommonWord('\u5961', "ao");
        HZPinyin0.putUncommonWord('\u705e', "ba");
        HZPinyin0.putUncommonWord('\u7287', "ben");
        HZPinyin0.putUncommonWord('\u730b', "biao");
        HZPinyin0.putUncommonWord('\u9a89', "biao");
        HZPinyin0.putUncommonWord('\u6748', "cha");
        HZPinyin0.putUncommonWord('\u68fd', "chen");
        HZPinyin0.putUncommonWord('\u7424', "cheng");
        HZPinyin0.putUncommonWord('\u9b51', "chi");
        HZPinyin0.putUncommonWord('\u87f2', "chong");
        HZPinyin0.putUncommonWord('\u7fc0', "chong");
        HZPinyin0.putUncommonWord('\u9ea4', "cu");
        HZPinyin0.putUncommonWord('\u6bf3', "cui");
        HZPinyin0.putUncommonWord('\u6609', "fang");
        HZPinyin0.putUncommonWord('\u6ca3', "feng");
        HZPinyin0.putUncommonWord('\u73bd', "gou");
        HZPinyin0.putUncommonWord('\u7113', "han");
        HZPinyin0.putUncommonWord('\u7400', "han");
        HZPinyin0.putUncommonWord('\u6657', "han");
        HZPinyin0.putUncommonWord('\u6d5b', "han");
        HZPinyin0.putUncommonWord('\u7fee', "he");
        HZPinyin0.putUncommonWord('\u7fef', "he");
        HZPinyin0.putUncommonWord('\u5b1b', "huan");
        HZPinyin0.putUncommonWord('\u7fd9', "hui");
        HZPinyin0.putUncommonWord('\u52bc', "jie");
        HZPinyin0.putUncommonWord('\u749f', "jing");
        HZPinyin0.putUncommonWord('\u8aa9', "jing");
        HZPinyin0.putUncommonWord('\u7af6', "jing");
        HZPinyin0.putUncommonWord('\u711c', "kun");
        HZPinyin0.putUncommonWord('\u7428', "kun");
        HZPinyin0.putUncommonWord('\u9e4d', "kun");
        HZPinyin0.putUncommonWord('\u9a8a', "li");
        HZPinyin0.putUncommonWord('\u938f', "liu");
        HZPinyin0.putUncommonWord('\u5ada', "man");
        HZPinyin0.putUncommonWord('\u69d1', "mei");
        HZPinyin0.putUncommonWord('\u6dfc', "miao");
        HZPinyin0.putUncommonWord('\u5a7b', "nan");
        HZPinyin0.putUncommonWord('\u6694', "nan");
        HZPinyin0.putUncommonWord('\u752f', "ning");
        HZPinyin0.putUncommonWord('\u5bd7', "ning");
        HZPinyin0.putUncommonWord('\u63b1', "pa");
        HZPinyin0.putUncommonWord('\u6ec2', "pang");
        HZPinyin0.putUncommonWord('\u73ad', "pi");
        HZPinyin0.putUncommonWord('\u6c67', "qian");
        HZPinyin0.putUncommonWord('\u9a8e', "qin");
        HZPinyin0.putUncommonWord('\u7520', "qing");
        HZPinyin0.putUncommonWord('\u6692', "qing");
        HZPinyin0.putUncommonWord('\u51ca', "qing");
        HZPinyin0.putUncommonWord('\u90ec', "qing");
        HZPinyin0.putUncommonWord('\u9758', "qing");
        HZPinyin0.putUncommonWord('\u60ab', "que");
        HZPinyin0.putUncommonWord('\u6164', "que");
        HZPinyin0.putUncommonWord('\u7462', "rong");
        HZPinyin0.putUncommonWord('\u73c5', "shen");
        HZPinyin0.putUncommonWord('\u5c7e', "shen");
        HZPinyin0.putUncommonWord('\u71ca', "shen");
        HZPinyin0.putUncommonWord('\u713a', "sheng");
        HZPinyin0.putUncommonWord('\u73c4', "sheng");
        HZPinyin0.putUncommonWord('\u665f', "sheng");
        HZPinyin0.putUncommonWord('\u6607', "sheng");
        HZPinyin0.putUncommonWord('\u771a', "sheng");
        HZPinyin0.putUncommonWord('\u6e66', "sheng");
        HZPinyin0.putUncommonWord('\u9679', "sheng");
        HZPinyin0.putUncommonWord('\u7ad4', "sheng");
        HZPinyin0.putUncommonWord('\u741e', "sheng");
        HZPinyin0.putUncommonWord('\u6e5c', "shi");
        HZPinyin0.putUncommonWord('\u7526', "su");
        HZPinyin0.putUncommonWord('\u5f22', "tao");
        HZPinyin0.putUncommonWord('\u7471', "tian");
        HZPinyin0.putUncommonWord('\u4edd', "tong");
        HZPinyin0.putUncommonWord('\u6cb1', "tuo");
        HZPinyin0.putUncommonWord('\u70d3', "wei");
        HZPinyin0.putUncommonWord('\u709c', "wei");
        HZPinyin0.putUncommonWord('\u73ae', "wei");
        HZPinyin0.putUncommonWord('\u6c95', "wu");
        HZPinyin0.putUncommonWord('\u90ac', "wu");
        HZPinyin0.putUncommonWord('\u665e', "xi");
        HZPinyin0.putUncommonWord('\u9855', "xian");
        HZPinyin0.putUncommonWord('\u5a4b', "xiao");
        HZPinyin0.putUncommonWord('\u8653', "xiao");
        HZPinyin0.putUncommonWord('\u7b71', "xiao");
        HZPinyin0.putUncommonWord('\u52f0', "xie");
        HZPinyin0.putUncommonWord('\u5ffb', "xin");
        HZPinyin0.putUncommonWord('\u5ea5', "xiu");
        HZPinyin0.putUncommonWord('\u5aad', "xu");
        HZPinyin0.putUncommonWord('\u73dd', "xu");
        HZPinyin0.putUncommonWord('\u662b', "xu");
        HZPinyin0.putUncommonWord('\u70dc', "xuan");
        HZPinyin0.putUncommonWord('\u714a', "xuan");
        HZPinyin0.putUncommonWord('\u7ffe', "xuan");
        HZPinyin0.putUncommonWord('\u660d', "xuan");
        HZPinyin0.putUncommonWord('\u6684', "xuan");
        HZPinyin0.putUncommonWord('\u5a05', "ya");
        HZPinyin0.putUncommonWord('\u7430', "yan");
        HZPinyin0.putUncommonWord('\u598d', "yan");
        HZPinyin0.putUncommonWord('\u7131', "yan");
        HZPinyin0.putUncommonWord('\u739a', "yang");
        HZPinyin0.putUncommonWord('\u65f8', "yang");
        HZPinyin0.putUncommonWord('\u98cf', "yang");
        HZPinyin0.putUncommonWord('\u579a', "yao");
        HZPinyin0.putUncommonWord('\u5ce3', "yao");
        HZPinyin0.putUncommonWord('\u6021', "yi");
        HZPinyin0.putUncommonWord('\u71da', "yi");
        HZPinyin0.putUncommonWord('\u6679', "yi");
        HZPinyin0.putUncommonWord('\u794e', "yi");
        HZPinyin0.putUncommonWord('\u745b', "ying");
        HZPinyin0.putUncommonWord('\u7150', "ying");
        HZPinyin0.putUncommonWord('\u5a96', "ying");
        HZPinyin0.putUncommonWord('\u668e', "ying");
        HZPinyin0.putUncommonWord('\u6ee2', "ying");
        HZPinyin0.putUncommonWord('\u9533', "ying");
        HZPinyin0.putUncommonWord('\u839c', "you");
        HZPinyin0.putUncommonWord('\u6631', "yu");
        HZPinyin0.putUncommonWord('\u6c84', "yun");
        HZPinyin0.putUncommonWord('\u6893', "zi");
        HZPinyin0.putUncommonWord('\u6662', "zhe");
        HZPinyin0.putUncommonWord('\u5586', "zhe");
        HZPinyin0.putUncommonWord('\u81f8', "zhi");
    }

    private static int getCnAscii(char cn) throws UnsupportedEncodingException {
        byte[] bytes = String.valueOf(cn).getBytes("GBK");
        if (bytes == null || bytes.length == 0 || bytes.length > 2) {
            return 0;
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bytes.length == 2) {
            int hightByte = 256 + bytes[0];
            int lowByte = 256 + bytes[1];
            return 256 * hightByte + lowByte - 65536;
        }
        return 0;
    }

    private static String getSpellByAscii(int ascii) {
        if (ascii > 0 && ascii < 160) {
            return String.valueOf((char)ascii);
        }
        if (ascii < -20319 || ascii > -10247) {
            return "";
        }
        String spell2 = null;
        String spellPrevious = null;
        int asciiRangPrevious = -20319;
        for (String spell2 : spellMap.keySet()) {
            Integer asciiRang = spellMap.get(spell2);
            if (asciiRang == null) continue;
            if (ascii >= asciiRangPrevious && ascii < asciiRang) {
                return spellPrevious == null ? spell2 : spellPrevious;
            }
            spellPrevious = spell2;
            asciiRangPrevious = asciiRang;
        }
        return "";
    }

    private static boolean isHZ(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fb0' || ch >= '\u3400' && ch <= '\u4db6';
    }

    private static String getSpell(String cnStr, String delim, boolean onlyFirstSpell, Map<Character, String> priorMap) throws UnsupportedEncodingException {
        if (cnStr == null) {
            return "";
        }
        boolean lastIsChart = false;
        char[] chs = cnStr.trim().toCharArray();
        StringBuffer sb = new StringBuffer();
        int len = chs.length;
        for (int i = 0; i < len; ++i) {
            int ascii;
            char ch = chs[i];
            boolean bl = lastIsChart = !HZPinyin0.isHZ(ch);
            if (!lastIsChart && i != 0) {
                sb.append(delim);
            }
            if ((ascii = HZPinyin0.getCnAscii(ch)) == 0) {
                sb.append(ch);
                continue;
            }
            String spell = null;
            if (priorMap != null) {
                spell = priorMap.get(Character.valueOf(ch));
            }
            if (spell == null && ((spell = HZPinyin0.getSpellByAscii(ascii)) == null || spell.length() == 0)) {
                spell = uncommonWordsMap.get(Character.valueOf(ch));
            }
            if (spell == null || spell.length() == 0) {
                sb.append(ch);
                continue;
            }
            if (onlyFirstSpell) {
                sb.append(spell.startsWith("\u2019") ? spell.substring(1, 2) : spell.substring(0, 1));
                continue;
            }
            sb.append(spell);
        }
        return sb.toString();
    }

    public static void putUncommonWord(char cnWord, String spell) {
        uncommonWordsMap.put(Character.valueOf(cnWord), spell);
    }

    public static String getFullSpell(String cn) throws UnsupportedEncodingException {
        return HZPinyin0.getFullSpell(cn, null);
    }

    public static String getFullSpell(String cn, Map<Character, String> pinyinMap) throws UnsupportedEncodingException {
        return HZPinyin0.getSpell(cn, " ", false, pinyinMap);
    }

    public static String getFirstSpell(String cn) throws UnsupportedEncodingException {
        return HZPinyin0.getFirstSpell(cn, null);
    }

    public static String getFirstSpell(String cn, Map<Character, String> pinyinMap) throws UnsupportedEncodingException {
        return HZPinyin0.getSpell(cn, "", true, pinyinMap);
    }

    static {
        HZPinyin0.initialize();
        HZPinyin0.initUncommonWords();
    }
}

